/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.BindVar;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.Position;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.arbori.Program;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class PositionalRelation
extends IdentedPredicate {
    Position a;
    Position b;
    Program prog;
    boolean isReflexive;
    boolean isGT;

    public PositionalRelation(Position a, Position b, boolean isReflexive, boolean isGT, Program prog) {
        this.prog = prog;
        this.a = a;
        this.a.setMaster(this);
        this.b = b;
        this.b.setMaster(this);
        this.isReflexive = isReflexive;
        this.isGT = isGT;
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src) {
        if (this.isReflexive && this.isGT) {
            return this.a.eval(attributePositions, tuple) <= this.b.eval(attributePositions, tuple);
        }
        if (this.isReflexive && !this.isGT) {
            return this.a.eval(attributePositions, tuple) == this.b.eval(attributePositions, tuple);
        }
        if (!this.isReflexive && this.isGT) {
            return this.a.eval(attributePositions, tuple) < this.b.eval(attributePositions, tuple);
        }
        throw new AssertionError((Object)"!isReflexive && !isGT");
    }

    public String toString() {
        return this.a.toString() + " <" + (this.isReflexive ? "=" : "") + " " + this.b.toString();
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        if (!(this.a instanceof BindVar)) {
            PositionalRelation.variables(this.a.name, ret);
        }
        if (!(this.b instanceof BindVar)) {
            PositionalRelation.variables(this.b.name, ret);
        }
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        if (this.a instanceof BindVar || this.b instanceof BindVar) {
            return null;
        }
        Attribute attr1 = varDefs.get(this.a.name);
        Attribute attr2 = varDefs.get(this.b.name);
        if (attr1.isDependent(var1, varDefs) && attr2.isDependent(var2, varDefs) || attr2.isDependent(var1, varDefs) && attr1.isDependent(var2, varDefs)) {
            return this;
        }
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int pos = this.a.name.indexOf(46);
        if (0 < pos) {
            ret.put(this.a.name.substring(0, pos), true);
        }
        if (0 < (pos = this.b.name.indexOf(46))) {
            ret.put(this.b.name.substring(0, pos), true);
        }
        return ret;
    }

    @Override
    public Predicate copy(Program prg) {
        return new PositionalRelation(this.a.clone(), this.b.clone(), this.isReflexive, this.isGT, prg);
    }
}

