/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.arbori;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.arbori.Attribute;
import oracle.dbtools.arbori.IdentedPredicate;
import oracle.dbtools.arbori.Predicate;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;

class NodeMatchingSrc
extends IdentedPredicate {
    String nodeVar;
    String literal;

    public NodeMatchingSrc(String nodeVar, String literal) {
        this.nodeVar = nodeVar;
        if (literal.charAt(0) != '\'') {
            throw new AssertionError((Object)"expected string literal");
        }
        this.literal = literal.substring(1, literal.length() - 1);
    }

    @Override
    public boolean eval(Map<String, Integer> attributePositions, ParseNode[] tuple, List<LexerToken> src) {
        ParseNode node = this.getNode(this.nodeVar, attributePositions, tuple);
        if (node == null) {
            return false;
        }
        return node.content(src).equals(this.literal);
    }

    public String toString() {
        return "?" + this.nodeVar + " = '" + this.literal + "'";
    }

    @Override
    public void variables(Set<String> ret, boolean optimizeEqs) {
        NodeMatchingSrc.variables(this.nodeVar, ret);
    }

    @Override
    public void signature(Set<String> ret) {
        this.variables(ret, false);
    }

    @Override
    public Predicate isRelated(String var1, String var2, Map<String, Attribute> varDefs) {
        return null;
    }

    @Override
    public Map<String, Boolean> dependencies() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        int pos = this.nodeVar.indexOf(46);
        if (0 < pos) {
            ret.put(this.nodeVar.substring(0, pos), true);
        }
        return ret;
    }
}

