/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.app.CompletionList;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.arbori.Tuple;
import oracle.dbtools.parser.Cell;
import oracle.dbtools.parser.Earley;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.raptor.newscriptrunner.commands.HiddenParameters;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.util.Service;

public class SqlCompleter {
    private static final String color32 = "\u001b[32m";
    private static final String color1 = "\u001b[1m";
    private static final String color0 = "\u001b[0m";
    SqlEarley earley = null;
    static int approximateIndex = -1;
    static IProgram programInstance = null;
    private Connection conn = null;

    public static void main(String[] args) throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:oracle:thin:@gbr30060.uk.oracle.com:1521/DB12PERF", "scott", "tiger");
        SqlCompleter c = new SqlCompleter(conn);
        String input = Service.readFile(SqlCompleter.class, "test.sql");
        input = "select  from emp, dept where emp.deptno = dept.deptno";
        int pos = input.length();
        pos = "select ".length();
        System.out.println("pos=" + pos);
        CompletionList candidates = c.complete(input, pos);
        System.out.println(candidates.toString());
    }

    public SqlCompleter(Connection conn) {
        this.conn = conn;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public Set<Long> predict(int pos, Matrix matrix) {
        HashSet<Long> predictions = new HashSet<Long>();
        for (int x = 0; x <= pos; ++x) {
            Cell cell = matrix.get(x, pos);
            if (cell == null) continue;
            for (int i = 0; i < cell.size(); ++i) {
                int rule = cell.getRule(i);
                int p = cell.getPosition(i);
                if (p >= this.earley.rules[rule].rhs.length) continue;
                String e = this.earley.allSymbols[this.earley.rules[rule].rhs[p]];
                predictions.add(Service.lPair(this.earley.rules[rule].rhs[p], this.earley.rules[rule].head));
            }
        }
        return predictions;
    }

    public Set<String> topKWsuggestions(Set<Long> suggestions, LexerToken prefix) {
        TreeMap<Long, Integer> topN = new TreeMap<Long, Integer>();
        int N = 7;
        for (long entry : suggestions) {
            String string;
            String sym;
            String prefixKW = "'";
            if (prefix != null) {
                prefixKW = "'" + prefix.content;
            }
            if (!(sym = this.earley.allSymbols[Service.lX(entry)]).startsWith(prefixKW.toUpperCase()) || (string = this.earley.allSymbols[Service.lY(entry)]).endsWith("]\"") && 2 + sym.length() < string.length()) continue;
            long minVar = -1L;
            int minVal = Integer.MAX_VALUE;
            Iterator i$ = topN.keySet().iterator();
            while (i$.hasNext()) {
                long s = (Long)i$.next();
                int tmp = (Integer)topN.get(s);
                if (tmp >= minVal) continue;
                minVar = s;
                minVal = tmp;
            }
            long suggestedVar = entry;
            Integer suggestedVal = HarvestDoc.getFrequencies().get(entry);
            if (suggestedVal == null) {
                suggestedVal = 0;
            }
            if (topN.size() == 7) {
                if (suggestedVal == null || minVal >= suggestedVal) continue;
                topN.remove(minVar);
                topN.put(suggestedVar, suggestedVal);
                continue;
            }
            topN.put(suggestedVar, suggestedVal);
        }
        ArrayList myList = new ArrayList();
        for (Map.Entry e : topN.entrySet()) {
            myList.add(e);
        }
        Collections.sort(myList, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry a, Map.Entry b) {
                return ((Integer)b.getValue()).compareTo((Integer)a.getValue());
            }
        });
        int div = 0;
        if (prefix != null) {
            div = prefix.content.length();
        }
        TreeSet<String> ret = new TreeSet<String>();
        int i = 0;
        for (Map.Entry entry : myList) {
            if (7 < i) break;
            String sugg = this.earley.allSymbols[Service.lX((Long)entry.getKey())];
            sugg = sugg.substring(1, sugg.length() - 1);
            if ("true".equals(HiddenParameters.parameters.get("coloredComplete"))) {
                String pre = sugg.substring(0, div);
                String post = sugg.substring(div);
                ret.add(color0 + pre + color32 + post + color0);
            } else {
                ret.add(sugg);
            }
            ++i;
        }
        return ret;
    }

    private static boolean contains(List<CharSequence> candidates, String entry) {
        for (CharSequence tmp : candidates) {
            if (!((String)tmp).toUpperCase().trim().equals(entry.toUpperCase().trim())) continue;
            return true;
        }
        return false;
    }

    public CompletionList complete(String input, int pos) {
        CompletionList ret = new CompletionList();
        try {
            List<LexerToken> src = LexerToken.parse(input);
            if (0 == src.size()) {
                return ret;
            }
            this.earley = SqlEarley.partialRecognizer();
            Matrix matrix = new Matrix(this.earley);
            this.earley.parse(src, matrix);
            SyntaxError error = SyntaxError.checkSyntax(input, new String[]{"sql_statement", "select", "insert", "update", "delete", "merge"}, src, this.earley, matrix, "^^^", "SyntaxError_DetailedMessage");
            if (error != null) {
                int select = -1;
                int from = -1;
                for (LexerToken t : src) {
                    if ("select".equalsIgnoreCase(t.content) && t.end < pos) {
                        select = t.end;
                    }
                    if (!"from".equalsIgnoreCase(t.content) || pos >= t.begin) continue;
                    from = t.begin;
                    break;
                }
                if (0 <= select && 0 <= from) {
                    input = input.substring(0, select) + " * " + input.substring(from);
                    src = LexerToken.parse(input);
                    pos = select + 1;
                }
            }
            Parsed target = new Parsed(input, src, (Earley)this.earley, (String)null);
            approximateIndex = LexerToken.char2lex(src, pos);
            if (approximateIndex < src.size() && src.get((int)SqlCompleter.approximateIndex).end == pos) {
                ret.prefix = src.get(approximateIndex);
            }
            if (!(ret.prefix == null || ret.prefix.type != Token.OPERATION || ret.prefix.content.equals(":") || ret.prefix.content.equals("!") || ret.prefix.content.equals("^"))) {
                ret.prefix = null;
                ++approximateIndex;
            }
            if ("*".equals(ret.prefix)) {
                ret.prefix = null;
                --approximateIndex;
            }
            if (src.get((int)0).content.equalsIgnoreCase("connect")) {
                String pref = "";
                if (ret.prefix != null) {
                    pref = ret.prefix.content;
                }
                for (String sugg : NetEntries.getMatching(pref)) {
                    ret.add(new CompletionItem(sugg, CompletionItem.Type.TURLNET));
                }
                return ret;
            }
            if (4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("desc") || 3 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 3).equalsIgnoreCase("ddl") || 4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("info") || 4 <= src.get((int)0).content.length() && src.get((int)0).content.substring(0, 4).equalsIgnoreCase("ctas")) {
                String pref = "";
                if (ret.prefix != null) {
                    pref = ret.prefix.content;
                }
                String owner = null;
                String obj = pref;
                if (2 < src.size() && ".".equals(src.get((int)2).content)) {
                    owner = src.get((int)1).content.toUpperCase();
                }
                for (CompletionItem sugg : this.queryObjects(owner, obj.toUpperCase(), "")) {
                    ret.add(sugg);
                }
                ret.pos = pos - pref.length();
                return ret;
            }
            int div = 0;
            if (ret.prefix != null) {
                div = ret.prefix.content.length();
            }
            Set<Long> predicted = this.predict(approximateIndex, target.getMatrix());
            TreeSet<String> predictions = new TreeSet<String>();
            for (long key : predicted) {
                predictions.add(SqlEarley.getInstance().allSymbols[Service.lX(key)]);
            }
            if (programInstance == null) {
                programInstance = new IProgram(Service.readFile(SqlCompleter.class, "completion.prg"));
            }
            SqlCompleter.programInstance.offset = approximateIndex;
            Map<String, MaterializedPredicate> output = programInstance.eval(target);
            MaterializedPredicate tanqb = output.get("\"table_alias in narrowest qb\"");
            block7: for (Tuple tuple : tanqb.getTuples()) {
                String tableExpr;
                ParseNode table = tanqb.getAttribute(tuple, "table");
                ParseNode alias = tanqb.getAttribute(tuple, "alias");
                int begin = src.get((int)table.from).begin;
                int end = src.get((int)(table.to - 1)).end;
                String owner = null;
                String tab = null;
                if (ret.prefix != null) {
                    tab = ret.prefix.content;
                }
                if (0 < (tableExpr = target.getInput().substring(begin, end)).indexOf(46)) {
                    owner = tableExpr.substring(0, tableExpr.indexOf(46));
                    tab = tableExpr.substring(tableExpr.indexOf(46) + 1);
                } else {
                    owner = null;
                    tab = tableExpr;
                }
                if (table == alias && table.to < src.size() && ".".equals(src.get((int)table.to).content)) {
                    owner = tableExpr;
                    tab = "";
                    ret.prefix = null;
                }
                String aliased = src.get((int)alias.from).content + ".";
                if (predictions.contains("column")) {
                    String prefix = null;
                    if (ret.prefix != null) {
                        if (alias == table) {
                            prefix = ret.prefix.content;
                        }
                        if (0 < approximateIndex && ".".equals(src.get((int)(SqlCompleter.approximateIndex - 1)).content)) {
                            prefix = ret.prefix.content;
                        }
                    }
                    for (String sugg : this.queryColumns(owner, tab, prefix)) {
                        if (1 < tanqb.cardinality()) {
                            sugg = aliased + sugg;
                            div += aliased.length();
                        }
                        ret.add(new CompletionItem(sugg, CompletionItem.Type.COLUMN));
                    }
                }
                for (String symbol : predictions) {
                    if (!symbol.startsWith("query_table_expression")) continue;
                    if (!tableExpr.equals(tab) && owner == null) continue block7;
                    if (table != alias) continue;
                    for (CompletionItem sugg : this.queryObjects(owner, tab.toUpperCase(), "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                        ret.add(sugg);
                    }
                    continue block7;
                }
            }
            if (tanqb.cardinality() == 0 && predictions.contains("table_reference")) {
                for (CompletionItem completionItem : this.queryObjects(null, "", "object_type in ('TABLE','VIEW','SYNONYM') and")) {
                    ret.add(completionItem);
                }
            }
            if (ret.size() == 0) {
                for (String string : this.topKWsuggestions(predicted, ret.prefix)) {
                    ret.add(new CompletionItem(string, CompletionItem.Type.KEYWORD));
                }
            }
            if (ret.size() == 1 && 0 < ret.first().toString().indexOf(32)) {
                return ret;
            }
            int p = pos;
            if (ret.prefix != null) {
                p = pos - ret.prefix.content.length();
            }
            ret.pos = p;
            return ret;
        }
        catch (SQLRecoverableException e) {
            return ret;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return ret;
        }
    }

    public static String discolor(String cleaned) {
        cleaned = cleaned.replace(color0, "");
        cleaned = cleaned.replace(color1, "");
        cleaned = cleaned.replace(color32, "");
        return cleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CompletionItem> queryObjects(String owner, String prefix, String typesClause) throws SQLException {
        Connection conn;
        int maxUsers = 20;
        String query = "select /*distinct*/ object_name, object_type from all_objects \nwhere " + typesClause + " owner=user \n" + "and object_name like :1 ESCAPE '\\' and rownum < 50\n" + "union all \n" + "select username||'.', 'USER' from all_users where username like :2 and rownum <= " + 20 + " \n" + "order by object_name";
        if (owner != null) {
            query = "select object_name, object_type from all_objects \nwhere " + typesClause + " owner = :1 and object_name like :2 ESCAPE '\\' \n" + "and rownum < 50 order by object_name";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<CompletionItem>();
        }
        if (3 < prefix.length()) {
            query = query.replace("owner=user", "owner in ('PUBLIC',user)");
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        } else {
            stmt.setObject(pos++, prefix.toUpperCase().replace("_", "\\_") + '%');
        }
        stmt.setObject(pos++, prefix.toUpperCase().replace("_", "\\_") + '%');
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<CompletionItem> users = new LinkedList<CompletionItem>();
            LinkedList<CompletionItem> ret = new LinkedList<CompletionItem>();
            while (rs.next()) {
                String candidate = rs.getString(1);
                String type = rs.getString(2);
                if (candidate.endsWith(".")) {
                    users.add(new CompletionItem(candidate, CompletionItem.Type.USER));
                    continue;
                }
                if ("TABLE".equalsIgnoreCase(type)) {
                    ret.add(new CompletionItem(candidate, CompletionItem.Type.TABLE));
                    continue;
                }
                if ("VIEW".equalsIgnoreCase(type)) {
                    ret.add(new CompletionItem(candidate, CompletionItem.Type.VIEW));
                    continue;
                }
                if ("SYNONYM".equalsIgnoreCase(type)) {
                    ret.add(new CompletionItem(candidate, CompletionItem.Type.SYNONYM));
                    continue;
                }
                if ("PROCEDURE".equalsIgnoreCase(type)) {
                    ret.add(new CompletionItem(candidate, CompletionItem.Type.PROCEDURE));
                    continue;
                }
                if ("FUNCTION".equalsIgnoreCase(type)) {
                    ret.add(new CompletionItem(candidate, CompletionItem.Type.FUNCTION));
                    continue;
                }
                if ("PACKAGE".equalsIgnoreCase(type)) {
                    ret.add(new CompletionItem(candidate, CompletionItem.Type.PACKAGE));
                    continue;
                }
                if ("PACKAGE BODY".equalsIgnoreCase(type)) {
                    ret.add(new CompletionItem(candidate, CompletionItem.Type.PACKAGE_BODY));
                    continue;
                }
                ret.add(new CompletionItem(candidate, null));
            }
            if (users.size() < 20) {
                ret.addAll(users);
            }
            LinkedList<CompletionItem> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> queryColumns(String owner, String table, String prefix) throws SQLException {
        Connection conn;
        String query = "select column_name from user_tab_columns where table_name = :1 \nand column_name like :2 and rownum < 50 order by column_name\n";
        if (owner != null) {
            query = "select column_name from all_tab_columns where owner = :1 and table_name = :2 \nand column_name like :2 and rownum < 50 order by column_name\n";
        }
        if ((conn = this.getConnection()) == null) {
            return new LinkedList<String>();
        }
        PreparedStatement stmt = conn.prepareStatement(query);
        int pos = 1;
        if (owner != null) {
            stmt.setObject(pos++, owner.toUpperCase());
        }
        stmt.setObject(pos++, table.toUpperCase());
        if (prefix != null) {
            stmt.setObject(pos++, prefix.toUpperCase() + '%');
        } else {
            stmt.setObject(pos++, "%");
        }
        ResultSet rs = stmt.executeQuery();
        try {
            LinkedList<String> ret = new LinkedList<String>();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            LinkedList<String> linkedList = ret;
            return linkedList;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static class IProgram
    extends SqlProgram {
        int offset = -1;

        public IProgram(String arboriProgram) throws IOException {
            super(arboriProgram);
        }
    }
}

