/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.List;
import oracle.dbtools.app.Format;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.UnitTest;
import oracle.dbtools.util.Service;

public class FormatTest {
    static final int offset = 0;
    static final int start = 0;
    static int cnt = 0;

    public static void main(String[] args) throws Exception {
        String input = Service.readFile(FormatTest.class, "../parser/plsql/doc/doc_sql.test");
        input = Service.readFile(FormatTest.class, "../parser/plsql/doc/doc_plsql.test");
        List<LexerToken> src = LexerToken.parse(input, "`");
        Parsed parsed = new Parsed(input, src, UnitTest.testParser, "atest");
        ParseNode root = parsed.getRoot();
        FormatTest.test(root, parsed.getSrc(), input);
    }

    static void test(ParseNode root, List<LexerToken> src, String input) throws Exception {
        if (cnt % 25 != 0) {
            ++cnt;
            return;
        }
        if (root.contains(UnitTest.query)) {
            String sql = FormatTest.query(root, src, input);
            if (sql.length() < 200) {
                return;
            }
            if (++cnt < 0) {
                return;
            }
            String output = new Format().format(sql);
            System.out.println("============================================# " + cnt);
            System.out.println(output);
        }
        for (ParseNode child : root.children()) {
            FormatTest.test(child, src, input);
        }
    }

    private static String query(ParseNode root, List<LexerToken> src, String input) {
        String ret = input.substring(src.get((int)root.from).begin, src.get((int)(root.to - 1)).end);
        if (ret.charAt(0) == '\"') {
            ret = ret.substring(1, ret.length() - 1);
        }
        if (ret.charAt(0) == '`') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return " " + ret + " ";
    }
}

