/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import java.sql.Connection;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerEngine;

public final class DebugProbeConnector
implements DebugConnector {
    public static String getVersion() {
        return "8";
    }

    public synchronized DebugConnectArg[] getConnectArgs() {
        DebugConnectArg[] a = new DebugProbeConnectArg[]{new DebugProbeConnectArg("connection", DebugProbeArb.getString(0), "", false), new DebugProbeConnectArg("session", DebugProbeArb.getString(1), "", false)};
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DebugVirtualMachine connect(DebugConnectArg[] connectArgs, DebuggerEngine engine) throws Exception {
        DebugProbe dp = null;
        String connName = connectArgs[0].getValue();
        String debugSessionId = connectArgs[1].getValue();
        if (connName != null) {
            try {
                Database db = (Database)DBObjectProviderFactory.findOrCreateProvider((String)"db", (Object)connName);
                Connection c = db.getConnection();
                StringBuffer sb = new StringBuffer();
                sb.append("begin\n");
                sb.append("  DBMS_DEBUG.attach_session( '" + debugSessionId + "', 0);\n");
                sb.append("  DBMS_DEBUG.probe_version(?, ?);\n");
                sb.append("  ? := DBMS_SESSION.unique_session_id;\n");
                sb.append("end;");
                String s = sb.toString();
                try (CallableStatement cs = c.prepareCall(s);){
                    cs.registerOutParameter(1, 4);
                    cs.registerOutParameter(2, 4);
                    cs.registerOutParameter(3, 12);
                    cs.execute();
                    int major = cs.getInt(1);
                    int minor = cs.getInt(2);
                    String debuggerSessionId = cs.getString(3);
                    dp = new DebugProbe(db, major, minor, debuggerSessionId);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dp;
    }

    public synchronized void startListening(DebugConnectArg[] connectArgs, DebugConnectionListener connectionListener) throws Exception {
        throw new UnsupportedOperationException("Can not listen. Not supported.");
    }

    public synchronized void stopListening() {
        throw new IllegalStateException("Can not stop listening. Not currently listening.");
    }
}

