/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.symbol.PackageSymbol;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeClassLoaderInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeDataArrayInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeFieldInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeLocation;
import oracle.jdevimpl.debugger.probe.DebugProbeValue;
import oracle.jdevimpl.debugger.probe.DebugProbeVariableContainer;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

final class DebugProbeClassInfo
extends DebugProbeVariableContainer
implements DebugClassInfo {
    DebugProbe dp;
    String name;
    boolean isPrimitive;
    boolean isObject;
    boolean isArray;
    int piLibunitType;
    String piOwner;
    String piName;
    private String sourceFilename;
    private String justPackage;
    private String packagePath;
    private String nameWithoutPackage;
    private List fieldNames;
    private Map fieldTypes;
    private int stoppedCount;
    private DebugProbeFieldInfo[] fields;

    private DebugProbeClassInfo(DebugProbe dp, String name) {
        this.dp = dp;
        this.name = name;
        this.stoppedCount = dp.stoppedCount;
    }

    public boolean hasExpired() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        if (this.justPackage == null) {
            this.justPackage = DebugShared.getPackage((String)this.name);
        }
        return this.justPackage;
    }

    public String getPackagePath() {
        if (this.packagePath == null) {
            this.packagePath = DebugShared.getPackagePath((String)this.name);
        }
        return this.packagePath;
    }

    public String getNameWithoutPackage() {
        if (this.nameWithoutPackage == null) {
            this.nameWithoutPackage = DebugShared.getNameWithoutPackage((String)this.name);
        }
        return this.nameWithoutPackage;
    }

    public String getGenericSignature() {
        return null;
    }

    public int getAccess() {
        return 0;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isObject() {
        return this.isObject;
    }

    public boolean isNotYetLoadedType() {
        return false;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public int getSizeOfObject() {
        return 0;
    }

    public long countObjectsOfClass() {
        return 0L;
    }

    public int countMemoryOfClass() {
        return 0;
    }

    public DebugDataObjectInfo getClassObject() {
        return null;
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        if (!this.isPrimitive()) {
            return DebugProbeClassLoaderInfo.makeClassLoaderInfo(this.dp);
        }
        return null;
    }

    public String getPrimarySourceFilename() {
        return this.getSourceFilename();
    }

    public String getSourceFilename() {
        if (this.sourceFilename == null) {
            this.sourceFilename = this.piName != null ? this.piName + ".pls" : "";
        }
        return this.sourceFilename;
    }

    public DebugClassInfo getSuperClass(int level) {
        return null;
    }

    public int getMethodCount() {
        return 0;
    }

    public DebugMethodInfo[] getMethods() {
        return new DebugMethodInfo[0];
    }

    public int getStaticFieldCount() {
        return this.getStaticFieldCount(0, false);
    }

    public DebugFieldInfo[] getStaticFields() {
        return this.getStaticFields(0, false);
    }

    public DebugFieldInfo getStaticField(int index) {
        return this.getStaticField(0, false, index);
    }

    public int getStaticFieldCount(int classLevel) {
        return this.getStaticFieldCount(classLevel, false);
    }

    public DebugFieldInfo[] getStaticFields(int classLevel) {
        return this.getStaticFields(classLevel, false);
    }

    public DebugFieldInfo getStaticField(int classLevel, int index) {
        return this.getStaticField(classLevel, false, index);
    }

    public int getStaticFieldCount(int classLevel, boolean noFinal) {
        this.lookForFields();
        if (classLevel <= 0) {
            return this.fields.length;
        }
        return 0;
    }

    public DebugFieldInfo[] getStaticFields(int classLevel, boolean noFinal) {
        this.lookForFields();
        if (classLevel <= 0) {
            return this.fields;
        }
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getStaticField(int classLevel, boolean noFinal, int index) {
        this.lookForFields();
        if (classLevel <= 0 && index >= 0 && index < this.fields.length) {
            return this.fields[index];
        }
        return null;
    }

    public DebugFieldInfo getStaticField(String name) {
        DebugProbeValue dpv = this.dp.getFieldValue(this, name, null);
        if (dpv != null) {
            String type = this.figureOutFieldType(name);
            if (type != null) {
                dpv.setType(type);
            }
            return new DebugProbeFieldInfo(this.dp, this, name, dpv, true);
        }
        return null;
    }

    public int getFieldCount(int classLevel) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int classLevel) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int classLevel, int index) {
        return null;
    }

    public int getFieldCount(int classLevel, boolean noFinal) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return null;
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        return 0;
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        return new DebugFieldInfo[0];
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        return null;
    }

    public boolean isDebuggable() {
        return true;
    }

    public void setDebuggable(boolean debuggable) {
    }

    public boolean isObfuscated() {
        return false;
    }

    public boolean isCodeCoverage() {
        return false;
    }

    public void setCodeCoverage(boolean codeCoverage) {
    }

    public void discardCodeCoverage() {
    }

    public double getCodeCoverageRatio() {
        return 0.0;
    }

    public DebugClassInfo[] getInterfaces() {
        return new DebugClassInfo[0];
    }

    public DebugClassInfo[] getInterfaces(int classLevel) {
        return new DebugClassInfo[0];
    }

    public int getLanguage() {
        return 2;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof DebugProbeClassInfo) {
            DebugProbeClassInfo other = (DebugProbeClassInfo)o;
            return ModelUtil.areEqual((Object)this.dp, (Object)other.dp) && ModelUtil.areEqual((Object)this.name, (Object)other.name);
        }
        return false;
    }

    private static String[] getClassNameParts(String name) {
        int dot2;
        String header;
        String[] s = new String[3];
        int dot1 = name.indexOf(46);
        if (dot1 != -1 && (header = name.substring(0, dot1)).equals("$Oracle") && (dot2 = name.indexOf(46, dot1 + 1)) != -1) {
            s[0] = name.substring(dot1 + 1, dot2);
            int dot3 = name.indexOf(46, dot2 + 1);
            if (dot3 != -1) {
                s[1] = name.substring(dot2 + 1, dot3);
                s[2] = name.substring(dot3 + 1);
                return s;
            }
        }
        return null;
    }

    static String makeClassName(int piLibunitType, String piOwner, String piName) {
        StringBuffer sb = new StringBuffer("$Oracle.");
        sb.append(DebugProbeLocation.formatLibunitType(piLibunitType));
        sb.append(".");
        sb.append(piOwner);
        sb.append(".");
        sb.append(piName);
        return sb.toString();
    }

    static DebugProbeClassInfo makePrimitiveClass(DebugProbe dp, String name) {
        DebugProbeClassInfo ci = new DebugProbeClassInfo(dp, name);
        ci.isPrimitive = true;
        ci.isObject = false;
        ci.isArray = false;
        return ci;
    }

    static DebugProbeClassInfo makeArrayClass(DebugProbe dp, String name) {
        DebugProbeClassInfo ci = new DebugProbeClassInfo(dp, name);
        ci.isPrimitive = false;
        ci.isObject = false;
        ci.isArray = true;
        return ci;
    }

    static DebugProbeClassInfo makeObjectClass(DebugProbe dp, String name) {
        String[] s = DebugProbeClassInfo.getClassNameParts(name);
        if (s != null) {
            DebugProbeClassInfo ci = new DebugProbeClassInfo(dp, name);
            ci.isPrimitive = false;
            ci.isObject = true;
            ci.isArray = false;
            ci.piLibunitType = DebugProbeLocation.parseLibunitType(s[0]);
            ci.piOwner = s[1];
            ci.piName = s[2];
            return ci;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void lookForFields() {
        if (this.stoppedCount != this.dp.stoppedCount) {
            this.fields = null;
        }
        if (this.fields == null) {
            listOfFields = new ArrayList<Object>();
            if (this.fieldNames == null) {
                this.fieldNames = new ArrayList<E>();
                this.fieldTypes = new HashMap<K, V>();
                sourceCode = this.dp.getSource(this);
                if (sourceCode != null) {
                    try {
                        buffer = TextBufferFactory.createReadTextBuffer((String)sourceCode);
                        rs = PlsqlParser.parse((ReadTextBuffer)buffer);
                        if (rs == null || (packages = rs.getPackages()) == null) ** GOTO lbl34
                        for (PackageSymbol pakkage : packages) {
                            nameSymbol = pakkage.getName();
                            if (nameSymbol == null || !(name = nameSymbol.getValue()).equalsIgnoreCase(this.piName)) continue;
                            this.processTypes(pakkage.getTypes());
                            this.processVariables(pakkage.getVariables(), this.fieldNames, listOfFields);
                        }
                    }
                    catch (Throwable e) {
                        Assert.println((String)("exception during parsing: " + e));
                        if (!(e instanceof ThreadDeath)) ** GOTO lbl34
                        throw (ThreadDeath)e;
                    }
                }
            } else {
                fieldNamesSize = this.fieldNames.size();
                for (i = 0; i < fieldNamesSize; ++i) {
                    name = (String)this.fieldNames.get(i);
                    var = this.getVariable(name, type = (String)this.fieldTypes.get(name));
                    if (var == null) continue;
                    listOfFields.add(var);
                }
            }
lbl34:
            // 6 sources

            this.fields = listOfFields.toArray(new DebugProbeFieldInfo[listOfFields.size()]);
            this.stoppedCount = this.dp.stoppedCount;
        }
    }

    private String figureOutFieldType(String name) {
        String type = null;
        boolean tableElement = false;
        String baseName = name;
        String tableName = DebugProbeDataArrayInfo.isTableElementName(name);
        if (tableName != null) {
            baseName = tableName;
            tableElement = true;
        }
        this.lookForFields();
        DebugProbeFieldInfo field = DebugProbeClassInfo.lookForFieldNamed(baseName, this.fields);
        if (field != null) {
            type = field.dpv.getType();
            String typeDefinition = this.getTypeDefinition(type);
            if (typeDefinition != null) {
                type = typeDefinition;
            }
            if (tableElement) {
                type = DebugProbeDataArrayInfo.getTableElementType(type);
            }
        }
        return type;
    }

    private static DebugProbeFieldInfo lookForFieldNamed(String name, DebugProbeFieldInfo[] fields) {
        if (name != null) {
            for (int i = fields.length - 1; i >= 0; --i) {
                if (!name.equalsIgnoreCase(fields[i].name)) continue;
                return fields[i];
            }
        }
        return null;
    }

    @Override
    protected Object getVariable(String name, String type) {
        this.fieldTypes.put(name, type);
        DebugProbeValue dpv = this.dp.getFieldValue(this, name, type);
        if (dpv != null) {
            return new DebugProbeFieldInfo(this.dp, this, name, dpv, true);
        }
        return null;
    }

    @Override
    void clearCachedData() {
        this.fields = null;
    }

    public boolean isEnum() {
        return false;
    }

    public DebugFieldInfo[] getEnumConstants() {
        return new DebugFieldInfo[0];
    }

    public int getConstantPoolCount() {
        return 0;
    }

    public byte[] getConstantPool() {
        return new byte[0];
    }
}

