/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBUtil;

public class DBArgusUtil
extends DBUtil {
    private static final Map _argusNames = new HashMap();
    private static final Map _argusTypes = new HashMap();

    private DBArgusUtil() {
    }

    public static String getArgusNameForType(String dbType) {
        return DBArgusUtil.getArgusNameForType(dbType, null);
    }

    public static String getArgusNameForType(String dbType, String subType) {
        if (subType != null && subType.length() > 0) {
            dbType = dbType + "/" + subType;
        }
        return (String)_argusNames.get(dbType);
    }

    public static String getArgusTypeForName(String name) {
        int idx;
        String type = (String)_argusTypes.get(name);
        if (type != null && (idx = type.indexOf(47)) >= 0) {
            type = type.substring(0, idx);
        }
        return type;
    }

    public static String getArgusSubTypeForName(String name) {
        int idx;
        String subtype = null;
        String type = (String)_argusTypes.get(name);
        if (type != null && (idx = type.indexOf(47)) >= 0) {
            subtype = type.substring(idx + 1);
        }
        return subtype;
    }

    private static void registerArgusTypeAndName(String type, String subtype, String name) {
        if (subtype != null) {
            type = type + "/" + subtype;
        }
        _argusNames.put(type, name);
        _argusTypes.put(name, type);
    }

    static {
        DBArgusUtil.registerArgusTypeAndName("PACKAGE", null, "Package");
        DBArgusUtil.registerArgusTypeAndName("PACKAGE", "Body", "PackageBody");
        DBArgusUtil.registerArgusTypeAndName("PROCEDURE", null, "Procedure");
        DBArgusUtil.registerArgusTypeAndName("FUNCTION", null, "Function");
        DBArgusUtil.registerArgusTypeAndName("TYPE", null, "Type");
        DBArgusUtil.registerArgusTypeAndName("TYPE", "Body", "TypeBody");
        DBArgusUtil.registerArgusTypeAndName("TRIGGER", null, "Trigger");
        DBArgusUtil.registerArgusTypeAndName("BLOCK", null, "Block");
    }
}

