/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.hadoop.ui.OSCHUtilityPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public abstract class OSCHUActions
extends AbstractMenuAction {
    static final String KEY_FILENAME = "FILENAME";
    static final String KEY_CONN = "CONNECTION";
    static final String KEY_CNAME = "CONNECTION_NAME";
    static final String KEY_TARGETFORMAT = "TARGETFORMAT";
    static final String KEY_DATA_LIST = "DATA_LIST";
    static final String KEY_ACTION_OBJECT_LIST = "ACTION_OBJECT_LIST";
    static final String KEY_WIZARD_TYPE = "WIZARD_TYPE";
    public static final String OSCHU_NAME = "raptor.oschuaction";
    public static final int OSCHU_ACTION = Ide.findOrCreateCmdID((String)"raptor.oschuaction");
    private JEWTDialog _dlg;
    private DBObject _dbo;
    HadoopProperties _hProps;

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)OSCHU_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public void launch() {
        HadoopProperties hadoopProperties;
        this._dbo = this.getDBObject();
        this._hProps = hadoopProperties = new HadoopProperties();
        hadoopProperties.put(ImportKeys.OBJECTACTION, this.getObjectAction());
        hadoopProperties.put(ImportKeys.DBOBJECT, this._dbo);
        hadoopProperties.put(ImportKeys.CONNECTION_NAME, this._dbo.getConnectionName());
        hadoopProperties.put(HadoopKeys.DEST_CONN_NAME, this._dbo.getConnectionName());
        hadoopProperties.put(ImportKeys.IS_CONFIGFILE, false);
        hadoopProperties.put(ImportKeys.TABLE_NAME, this._dbo.getObjectName());
        hadoopProperties.put(ImportKeys.IS_EXISTING_TABLE, this._dbo.getObjectName() != null);
        ExtractDataFormat extractDataFormat = new ExtractDataFormat(ExtractDataFormat.EXPORT_WIZARD, ExtractDataFormat.DELIMITED);
        hadoopProperties.put(HadoopKeys.EXTRACT_DATA_FORMAT, extractDataFormat);
        String string = HadoopWizArb.getString("OSCHU_UTILITY_ACTIONS");
        OSCHUtilityPanel oSCHUtilityPanel = (OSCHUtilityPanel)this.getUI(this._hProps);
        oSCHUtilityPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)oSCHUtilityPanel, null, (String)string, (int)20);
        oSCHUtilityPanel.setDialog(this._dlg);
        this._dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OSCHUActions.this._dlg.setVisible(false);
                OSCHUActions.this._dlg.dispose();
            }
        });
        Dimension dimension = oSCHUtilityPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 200;
        int n2 = (int)dimension.getWidth() + 300;
        this._dlg.setMinimumSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._dlg);
        this._dlg.setVisible(true);
    }

    protected abstract JComponent getUI(HadoopProperties var1);

    protected JEWTDialog getDialog() {
        return this._dlg;
    }

    static boolean acquireLock(String string) {
        return LockedConnection.acquireLock(string);
    }

    static void freeLock() {
        LockedConnection.freeLock();
    }

    private static class LockedConnection {
        private static String _connName;
        private static boolean _locked;

        private LockedConnection() {
        }

        static synchronized boolean acquireLock(String string) {
            boolean bl = false;
            LockedConnection.freeLock();
            bl = _locked = Connections.getInstance().lock(string, true);
            if (bl) {
                _connName = string;
            }
            return bl;
        }

        static synchronized void freeLock() {
            if (_connName != null && _locked) {
                Connections.getInstance().unlock(_connName);
                _locked = false;
                _connName = null;
            }
        }

        static {
            _locked = false;
        }
    }
}

