/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.data.core.ImportProperties;
import oracle.dbtools.raptor.data.core.ImportSummary;
import oracle.dbtools.raptor.extract.ExtractResources;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.hadoop.core.HadoopImportDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.execute.OSCHExec;
import oracle.dbtools.raptor.hadoop.ui.HadoopUIUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class OSCHIWizSummaryPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane _summaryTabbedPane = new JTabbedPane();
    private JTree _summaryTree = new JTree();
    private JButton _testCmp = new JButton();
    private JTextComponent _xTabPane;
    private JTextComponent _msgsPane;
    private OSCHExec _exec = new OSCHExec();
    private boolean _isTested;
    private HadoopProperties _hProps;
    ExtractListModel _listModel;

    public OSCHIWizSummaryPage() {
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this._summaryTree.setCellRenderer(new NodeRenderer());
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_SUMMARY_TITLE"), new JScrollPane(this._summaryTree, 20, 30));
        this._xTabPane = this.createTextPane(false);
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_DDL_TITLE"), new JScrollPane(this._xTabPane, 20, 30));
        this._msgsPane = this.createTextPane(false);
        this._summaryTabbedPane.add(HadoopWizArb.getString("SUMMARY_MSGS_TITLE"), new JScrollPane(this._msgsPane, 20, 30));
        this._testCmp.setText(StringUtils.stripMnemonic((String)HadoopWizArb.getString("SUMMARY_TEST")));
        this._testCmp.setMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("SUMMARY_TEST")));
        this._testCmp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                OSCHIWizSummaryPage.this._isTested = true;
                OSCHIWizSummaryPage.this._exec.start(OSCHIWizSummaryPage.this._hProps);
                ExitCode exitCode = OSCHIWizSummaryPage.this._exec.doTest();
                String string2 = OSCHIWizSummaryPage.this._exec.getLogFromTest();
                if (string2 != null) {
                    OSCHIWizSummaryPage.this._msgsPane.setText(OSCHIWizSummaryPage.this._exec.getLogFromTest());
                    OSCHIWizSummaryPage.this._msgsPane.setCaretPosition(0);
                    string = OSCHIWizSummaryPage.this._exec.getDDL();
                    if (string != null && !string.isEmpty()) {
                        OSCHIWizSummaryPage.this._xTabPane.setText(string);
                        OSCHIWizSummaryPage.this._summaryTabbedPane.setSelectedIndex(1);
                    } else {
                        OSCHIWizSummaryPage.this._xTabPane.setText(HadoopWizArb.getString("SUMMARY_NO_DDL"));
                        OSCHIWizSummaryPage.this._summaryTabbedPane.setSelectedIndex(2);
                    }
                    OSCHIWizSummaryPage.this._xTabPane.setCaretPosition(0);
                }
                string = "";
                string = exitCode == ExitCode.EXIT_SUCCESS ? HadoopWizArb.getString("OSCH_EXEC_SUCCESS") : (exitCode == ExitCode.EXIT_WARNING ? HadoopWizArb.getString("OSCH_EXEC_WARN") : HadoopWizArb.getString("OSCH_EXEC_FAIL"));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)(HadoopWizArb.getString("SUMMARY_RESULT") + " " + string), (String)string, null);
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add((Component)this._testCmp, "South");
        this.add(this._summaryTabbedPane, "Center");
        this.add(jPanel, "South");
    }

    private JTextComponent createTextPane(boolean bl) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._isTested = false;
        this._listModel = (ExtractListModel)traversableContext.get("EXTRACT_LIST_MODEL");
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        this._summaryTree.removeAll();
        this._summaryTree.setModel(this.getSummaryTreeModel(HadoopWizArb.getString("STEP_SUMMARY")));
        this._msgsPane.setText(HadoopWizArb.getString("SUMMARY_DDL_TEST"));
        this._xTabPane.setText(HadoopWizArb.getString("SUMMARY_DDL_TEST"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this._exec.start((HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES")));
            this._exec.doExec();
        }
    }

    public DefaultTreeModel getSummaryTreeModel(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        boolean bl = ((String)this._hProps.get(HadoopKeys.SOURCE_TYPE)).equals(HadoopWizArb.getString("HIVE_TABLE"));
        String string2 = bl ? HadoopWizArb.getString("HIVE_TABLE") : HadoopWizArb.getString("TEXT");
        defaultMutableTreeNode.add(this.getDestConnectionNode());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(StringUtils.stripMnemonic((String)HadoopWizArb.getString("SOURCE_TYPE")) + " " + string2);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        if (bl) {
            defaultMutableTreeNode2.add(this.getSourceConnectionNode());
        }
        if (!bl) {
            defaultMutableTreeNode2.add(ImportSummary.getFileNode((ImportProperties)this._hProps));
        }
        JLabel jLabel = new JLabel();
        jLabel.setText(HadoopWizArb.getString("HOST_SUMM") + " " + (String)this._hProps.get(HadoopKeys.SSH_HOST));
        jLabel.setIcon(OracleIcons.getIcon((String)"hostconnection.png"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(jLabel);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private DefaultMutableTreeNode getDestConnectionNode() {
        String string = (String)this._hProps.get(ImportKeys.CONNECTION_NAME);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(DataImportArb.getString((String)"CONN"));
        if (string != null) {
            JLabel jLabel;
            JLabel jLabel2 = new JLabel();
            String string2 = Connections.getDisplayName((String)string);
            jLabel2.setText(DataImportArb.getString((String)"DEST_CONN") + ": " + string2);
            jLabel2.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel2);
            String string3 = (String)this._hProps.get(HadoopKeys.LOAD_METHOD_NAME);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(HadoopWizArb.getString("METHOD_LABEL") + " " + string3));
            JLabel jLabel3 = new JLabel();
            jLabel3.setIcon(OracleIcons.getIcon((String)"table.png"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel3);
            if (string3.equals(HadoopImportDataFormat.METHOD_EXTERNAL_TABLE_NAME)) {
                jLabel3.setText(StringUtils.stripMnemonic((String)HadoopWizArb.getString("DEST_XTAB_LABEL")) + " " + this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + (String)this._hProps.get(ImportKeys.TABLE_NAME));
            } else {
                jLabel3.setText(StringUtils.stripMnemonic((String)HadoopWizArb.getString("TABLE_NAME_LABEL")) + this._hProps.get(HadoopKeys.DEST_SCHEMA) + ". " + (String)this._hProps.get(ImportKeys.TABLE_NAME));
                jLabel = new JLabel();
                jLabel.setIcon(OracleIcons.getIcon((String)"table.png"));
                jLabel.setText(HadoopWizArb.getString("STAGING_TABLE_NAME_LABEL") + " " + this._hProps.get(HadoopKeys.DEST_SCHEMA) + "." + (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(jLabel));
                defaultMutableTreeNode.add(HadoopUIUtils.getSummaryBooleanItem(StringUtils.stripMnemonic((String)HadoopWizArb.getString("METHOD_DROP_STAGING")), this._hProps.getValueBoolean(ImportKeys.DROP_STAGING_TABLE)));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            jLabel = (GenericTable)this._hProps.get(ImportKeys.TABLE);
            for (Column column : jLabel.getColumns()) {
                JLabel jLabel4 = new JLabel();
                jLabel4.setText(DataImportArb.getString((String)"COLUMN") + ": " + column.getName());
                jLabel4.setIcon(OracleIcons.getIcon((String)"field.png"));
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(jLabel4));
            }
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getSourceConnectionNode() {
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_CONN_NAME);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(HadoopWizArb.getString("SUMMARY_NODE_SOURCE_CONN"));
        if (string != null) {
            JLabel jLabel = new JLabel();
            String string2 = Connections.getDisplayName((String)string);
            jLabel.setText(HadoopWizArb.getString("SUMMARY_NODE_SOURCE_CONN") + ": " + string2);
            jLabel.setIcon(ExtractResources.getIcon((String)"CONNECTION_ICON"));
            defaultMutableTreeNode = new DefaultMutableTreeNode(jLabel);
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(HadoopWizArb.getString("HIVE_TABLE") + ": " + this._hProps.get(HadoopKeys.SOURCE_SCHEMA_NAME) + "." + this._hProps.get(HadoopKeys.SOURCE_TABLE_NAME));
            jLabel2.setIcon(OracleIcons.getIcon((String)"table.png"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jLabel2);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            String string3 = (String)this._hProps.get(HadoopKeys.WHERE);
            if (string3 != null) {
                string3.trim();
                if (!string3.isEmpty()) {
                    JLabel jLabel3 = new JLabel();
                    jLabel3.setText(HadoopWizArb.getString("WHERE") + ": " + string3);
                    jLabel3.setIcon(OracleIcons.getIcon((String)"filter.png"));
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(jLabel3);
                    defaultMutableTreeNode.add(defaultMutableTreeNode3);
                }
            }
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getImportMethodNode() {
        String string = HadoopWizArb.getString("METHOD_LABEL") + " " + (String)this._hProps.get(HadoopKeys.LOAD_METHOD_NAME);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        if (string.equals(HadoopImportDataFormat.METHOD_EXTERNAL_TABLE_NAME)) {
            String string2 = HadoopWizArb.getString("DEST_XTAB_LABEL") + " " + (String)this._hProps.get(ImportKeys.TABLE_NAME);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string2));
        } else {
            String string3 = HadoopWizArb.getString("TABLE_NAME_LABEL") + " " + (String)this._hProps.get(ImportKeys.TABLE_NAME);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string3));
            String string4 = HadoopWizArb.getString("STAGING_TABLE_NAME_LABEL") + " " + (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME);
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string4));
        }
        return defaultMutableTreeNode;
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

