/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.HadoopUIUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class OSCHIOptionalParmsPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private static final String OSCH_BIN_PATH = "OSCH_BIN_PATH";
    private HadoopProperties _hProps;
    private Vector<String> _dirList;
    protected JLabel _preProcDirLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("PREPROC_DIR_LABEL")));
    protected JComboBox<String> _preProcDirCmp = new JComboBox();
    protected JLabel _parallelLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("PARALLEL")));
    protected NumericSpinBox _parallelCmp = new NumericSpinBox(0, Integer.MAX_VALUE);
    private JLabel _defaultDirLabel;
    private JComboBox<String> _defaultDirCmp;
    private JCheckBox _logDirCheckBox;
    private JComboBox<String> _logDirCmp;
    private JCheckBox _badDirCheckBox;
    private JTextField _badDirCmp;
    private JTextField _numChars;
    private JCheckBox _walletCheckBox;
    private JLabel _walletCredentialsLabel;
    private JTextField _walletCredentialsCmp;
    private JCheckBox _deleteDeployCheckBox;
    private DBObject _dbo;
    private boolean _init = false;
    private boolean _isHive;
    private boolean _isLogDirSelected = false;
    private boolean _isSelectingDefault = false;

    public void onEntry(TraversableContext traversableContext) {
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_TYPE);
        this._isHive = string != null && string.equals(HadoopWizArb.getString("HIVE_TABLE"));
        this._dbo = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        this.build();
        super.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    protected void build() {
        if (!this._init) {
            Object object;
            this._init = true;
            this.setLayout(new GridBagLayout());
            this._preProcDirLabel.setLabelFor(this._preProcDirCmp);
            this._preProcDirCmp = HadoopUIUtils.getSQLCombo(this._preProcDirLabel);
            this._preProcDirCmp.setToolTipText(HadoopWizArb.getString("PREPROC_DIR_TIP"));
            this._preProcDirLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("PREPROC_DIR_LABEL")));
            HadoopUIUtils.setOraDirModel(this._preProcDirCmp, (String)this._hProps.get(ImportKeys.CONNECTION_NAME), false);
            int n = -1;
            this._dirList = new Vector();
            for (int i = 0; i < this._preProcDirCmp.getItemCount(); ++i) {
                object = this._preProcDirCmp.getItemAt(i);
                this._dirList.addElement((String)object);
                if (n != -1 || !((String)object).equals(OSCH_BIN_PATH)) continue;
                n = i;
            }
            this._preProcDirCmp.setSelectedIndex(n);
            this._preProcDirCmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)OSCHIOptionalParmsPage.this._preProcDirCmp.getSelectedItem();
                    if (string != null && !string.isEmpty() && !string.equals(OSCHIOptionalParmsPage.OSCH_BIN_PATH)) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)HadoopWizArb.getString("PREPROC_DIR_WARNING"), (String)HadoopWizArb.getString("WARNING"), null);
                    }
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new TitledBorder(null, HadoopWizArb.getString("OSCH_PARMS"), 0, 0, null, null));
            object = new JPanel(new GridBagLayout());
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.initParallel();
            int n2 = 0;
            ((Container)object).add((Component)this._preProcDirLabel, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            ((Container)object).add(this._preProcDirCmp, LayoutControl.GBC.gbc((int)1, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            ((Container)object).add((Component)this._parallelLabel, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            ((Container)object).add((Component)this._parallelCmp, LayoutControl.GBC.gbc((int)1, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.initDefaultDir();
            this.initLogDir();
            this.initBadDir();
            this.initWallet();
            this.initDeleteDeploy();
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(new TitledBorder(null, HadoopWizArb.getString("EXTERNAL_TABLE_PARMS"), 0, 0, null, null));
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            n2 = 0;
            jPanel3.add((Component)this._defaultDirLabel, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel3.add(this._defaultDirCmp, LayoutControl.GBC.gbc((int)1, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel3.add((Component)this._logDirCheckBox, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel3.add(this._logDirCmp, LayoutControl.GBC.gbc((int)1, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel3.add((Component)this._badDirCheckBox, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel3.add((Component)this._badDirCmp, LayoutControl.GBC.gbc((int)1, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(new TitledBorder(null, HadoopWizArb.getString("DEST_CONN"), 0, 0, null, null));
            JPanel jPanel5 = new JPanel(new GridBagLayout());
            jPanel5.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            n2 = 0;
            jPanel5.add((Component)this._walletCheckBox, LayoutControl.GBC.gbc((int)0, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel5.add((Component)this._walletCredentialsLabel, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel5.add((Component)this._walletCredentialsCmp, LayoutControl.GBC.gbc((int)1, (int)n2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel4.add((Component)jPanel5, "North");
            jPanel.add((Component)object, "North");
            jPanel2.add((Component)jPanel3, "North");
            n2 = 0;
            this.add(jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.add(this._deleteDeployCheckBox, LayoutControl.GBC.gbc((int)0, (int)(++n2), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n2));
        }
    }

    protected void initParallel() {
        this._parallelCmp.setMinimum(1);
        this._parallelCmp.setToolTipText(HadoopWizArb.getString("PARALLEL"));
        this._parallelLabel.setToolTipText(HadoopWizArb.getString("PARALLEL_TIP"));
        this._parallelCmp.setIntValue(4);
    }

    protected void initDefaultDir() {
        if (this._defaultDirCmp == null) {
            this._defaultDirLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._defaultDirLabel, this._defaultDirCmp, (String)HadoopWizArb.getString("DEFAULT_DIR_LABEL"));
            this._defaultDirCmp = new JComboBox<String>(this._dirList);
            this._defaultDirCmp.setEditable(false);
            this._defaultDirCmp.setSelectedIndex(-1);
            this._defaultDirCmp.setToolTipText(HadoopWizArb.getString("DEFAULT_DIR_TOOL_TIP"));
            this._defaultDirCmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)OSCHIOptionalParmsPage.this._defaultDirCmp.getSelectedItem();
                    if (!OSCHIOptionalParmsPage.this._isLogDirSelected) {
                        OSCHIOptionalParmsPage.this._isSelectingDefault = true;
                        OSCHIOptionalParmsPage.this._logDirCmp.setSelectedItem(string);
                        OSCHIOptionalParmsPage.this._badDirCmp.setText(string);
                    }
                }
            });
        }
    }

    protected void initLogDir() {
        if (this._logDirCmp == null) {
            this._isLogDirSelected = false;
            this._logDirCheckBox = new JCheckBox();
            this._logDirCheckBox.setSelected(true);
            ResourceUtils.resButton((AbstractButton)this._logDirCheckBox, (String)PreferencesArb.getString((String)"IMPORT_USE_LOG"));
            this._logDirCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    boolean bl = jCheckBox.isSelected();
                    OSCHIOptionalParmsPage.this._logDirCmp.setEnabled(bl);
                    String string = (String)OSCHIOptionalParmsPage.this._defaultDirCmp.getSelectedItem();
                    if (string == null) {
                        string = "";
                    }
                    if (bl) {
                        String string2 = (String)OSCHIOptionalParmsPage.this._logDirCmp.getSelectedItem();
                        OSCHIOptionalParmsPage.this._badDirCmp.setText(string2 != null && !string2.isEmpty() ? string2 : string);
                    } else {
                        OSCHIOptionalParmsPage.this._badDirCmp.setText(string);
                    }
                }
            });
            this._logDirCmp = new JComboBox<String>(this._dirList);
            this._logDirCmp.setToolTipText(HadoopWizArb.getString("LOG_DIR_TIP"));
            this._logDirCmp.setEditable(false);
            this._logDirCmp.setSelectedIndex(-1);
            this._logDirCmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!OSCHIOptionalParmsPage.this._isSelectingDefault) {
                        OSCHIOptionalParmsPage.this._isLogDirSelected = true;
                    } else {
                        OSCHIOptionalParmsPage.this._isSelectingDefault = false;
                    }
                    String string = (String)OSCHIOptionalParmsPage.this._logDirCmp.getSelectedItem();
                    OSCHIOptionalParmsPage.this._badDirCmp.setText(string);
                }
            });
        }
    }

    protected void initBadDir() {
        if (this._badDirCmp == null) {
            this._badDirCheckBox = new JCheckBox();
            this._badDirCheckBox.setSelected(true);
            ResourceUtils.resButton((AbstractButton)this._badDirCheckBox, (String)PreferencesArb.getString((String)"IMPORT_USE_BAD"));
            this._badDirCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    OSCHIOptionalParmsPage.this._badDirCmp.setEnabled(jCheckBox.isSelected());
                }
            });
            this._badDirCmp = new JTextField();
            this._badDirCmp.setToolTipText(HadoopWizArb.getString("BAD_DIR_TIP"));
            this._badDirCmp.setEditable(false);
        }
    }

    protected void initNumChars() {
        if (this._numChars == null) {
            this._numChars = new JTextField("4000", 8);
        }
        this._numChars.setVisible(false);
    }

    protected void initWallet() {
        if (this._walletCheckBox == null) {
            this._walletCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._walletCheckBox, (String)HadoopWizArb.getString("USE_WALLET"));
            this._walletCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    OSCHIOptionalParmsPage.this._walletCredentialsCmp.setEnabled(jCheckBox.isSelected());
                    OSCHIOptionalParmsPage.this._walletCredentialsLabel.setEnabled(jCheckBox.isSelected());
                }
            });
            this._walletCredentialsLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._walletCredentialsLabel, (Component)this._walletCredentialsCmp, (String)HadoopWizArb.getString("WALLET_CREDENTIALS"));
            this._walletCredentialsCmp = new JTextField();
            Dimension dimension = new Dimension(80, (int)this._walletCredentialsCmp.getPreferredSize().getHeight());
            this._walletCredentialsCmp.setPreferredSize(dimension);
            this._walletCheckBox.setSelected(false);
            this._walletCredentialsCmp.setEnabled(false);
            this._walletCredentialsLabel.setEnabled(false);
        }
    }

    protected void initDeleteDeploy() {
        if (this._deleteDeployCheckBox == null) {
            this._deleteDeployCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._deleteDeployCheckBox, (String)HadoopWizArb.getString("DELETE_DEPLOY"));
            this._deleteDeployCheckBox.setSelected(true);
            this._deleteDeployCheckBox.setToolTipText(HadoopWizArb.getString("DELETE_DEPLOY_TIP"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            String string = (String)this._preProcDirCmp.getSelectedItem();
            if (string == null || string.isEmpty()) {
                throw new TraversalException(HadoopWizArb.getString("PREPROC_DIR_ERROR"));
            }
            this._hProps.put(HadoopKeys.PREPROC_DIR, string);
            this._hProps.put(HadoopKeys.PARALLEL, this._parallelCmp.getIntValue());
            String string2 = (String)this._defaultDirCmp.getSelectedItem();
            if (string2 == null || string2.isEmpty()) {
                throw new TraversalException(HadoopWizArb.getString("DEFAULT_DIR_ERROR"));
            }
            this._hProps.put(ImportKeys.ORADIRNAME, string2);
            this._hProps.put(ImportKeys.USELOGFILE, this._logDirCheckBox.isSelected());
            this._hProps.put(ImportKeys.USEBADFILE, this._badDirCheckBox.isSelected());
            string2 = (String)this._logDirCmp.getSelectedItem();
            if (this._logDirCheckBox.isSelected()) {
                if (string2 == null || string2.isEmpty()) {
                    throw new TraversalException(HadoopWizArb.getString("LOG_DIR_ERROR"));
                }
                this._hProps.put(ImportKeys.LOGDIRNAME, string2);
            }
            string2 = this._badDirCmp.getText();
            if (this._badDirCheckBox.isSelected()) {
                if (string2 == null || string2.isEmpty()) {
                    throw new TraversalException(HadoopWizArb.getString("BAD_DIR_ERROR"));
                }
                this._hProps.put(ImportKeys.BADDIRNAME, string2);
            }
            if (!this._walletCheckBox.isSelected()) {
                HadoopUIUtils.updateConnectionInfo(this._hProps, (String)this._hProps.get(HadoopKeys.DEST_CONN_NAME));
            } else if (this._walletCredentialsCmp.getText().length() == 0) {
                throw new TraversalException(HadoopWizArb.getString("WALLET_CREDENTIALS_MISSING"));
            }
            this._hProps.put(HadoopKeys.IS_USE_WALLET, this._walletCheckBox.isSelected());
            this._hProps.put(HadoopKeys.WALLET_CREDENTIAL, this._walletCredentialsCmp.getText());
            this._hProps.put(HadoopKeys.DELETE_DEPLOY, this._deleteDeployCheckBox.isSelected());
        }
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        return "Fin";
    }
}

