/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopGenericTable;
import oracle.dbtools.raptor.hadoop.core.HadoopImportDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.OSCHImportDataFormat;
import oracle.dbtools.raptor.hadoop.ui.HadoopIGeneralPage;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class OSCHIGeneralPage
extends HadoopIGeneralPage {
    private static final long serialVersionUID = 1L;
    private JPanel _sourcePanel;
    private JPanel _sourceTypePanel;

    @Override
    protected String[] getSourceTypes() {
        String[] stringArray = new String[]{HadoopWizArb.getString("HIVE_TABLE"), HadoopWizArb.getString("TEXT")};
        return stringArray;
    }

    @Override
    protected String getInstructionsText() {
        return HadoopWizArb.getString("OSCH_GEN_INSTRUCTIONS");
    }

    @Override
    protected String getHostTooltip() {
        return HadoopWizArb.getString("OSCH_HOST_TIP");
    }

    @Override
    protected JPanel getSourcePanel() {
        int n = 0;
        this._sourceTypePanel = new JPanel(new GridBagLayout());
        this._sourceTypePanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(HadoopWizArb.getString("S_HIVE_BORDER")));
        jPanel.add((Component)this._sourceTypePanel, "North");
        this._sourceTypePanel.add((Component)this._sourceTypeLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this._sourceTypePanel.add((Component)this._sourceTypeCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._sourceTypePanel.add((Component)this._sConnLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this._sourceTypePanel.add((Component)this._sourceConnSelector.getJComboBox(), LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this._sourceTypePanel.add((Component)this._schemaLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this._sourceTypePanel.add((Component)this._schemaCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        this._sourceTypePanel.add((Component)this._tableLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
        this._sourceTypePanel.add((Component)this._tableCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this._sourcePanel = new JPanel(new BorderLayout(0, 16));
        this._sourcePanel.add((Component)jPanel, "Center");
        this._sourceTypeCmp.setSelectedIndex(0);
        return this._sourcePanel;
    }

    @Override
    protected HadoopImportDataFormat getDataFormat() {
        return new OSCHImportDataFormat(BaseDataFormat.IMPORT_WIZARD, BaseDataFormat.DELIMITED);
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            super.onExit(traversableContext);
            String string = (String)this._hProps.get(HadoopKeys.SOURCE_TYPE);
            if (string != null && string.equals(HadoopWizArb.getString("HIVE_TABLE"))) {
                HadoopGenericTable hadoopGenericTable = (HadoopGenericTable)((Object)this._hProps.get(HadoopKeys.SOURCE_GENERIC_TABLE));
                if (this._isSourceChanged) {
                    this._hProps.put(HadoopKeys.DDL, hadoopGenericTable.getDDL());
                }
                if (!hadoopGenericTable.isText()) {
                    throw new TraversalException(HadoopWizArb.getString("TABLE_TYPE_NOT_SUPPORTED"));
                }
                this._hProps.put(HadoopKeys.IS_SOURCE_PARTITIONED, hadoopGenericTable.isPartitioned());
            } else {
                this._hProps.put(HadoopKeys.IS_SOURCE_PARTITIONED, false);
                this._hProps.put(HadoopKeys.DDL, "");
            }
        }
    }

    @Override
    protected void updateExpectedTransition() {
        this.getContext().getWizardCallbacks().wizardUpdateExpectedTransition(this.getTransition());
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        if (this._sourceTypeCmp.getSelectedIndex() == 0) {
            return "C";
        }
        return "B";
    }
}

