/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import com.jcraft.jsch.Session;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopFileHelper;
import oracle.dbtools.raptor.hadoop.core.HadoopImportDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopUIUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.dialogs.MessageDetailsDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DetailedTraversalException;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class OLHIOptionalParmsPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private HadoopProperties _hProps;
    private JLabel _loadMethodLabel;
    private String _loadMethodName;
    private JComboBox<String> _loadMethodCmp;
    private JLabel _parallelLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("PARALLEL")));
    private NumericSpinBox _parallelCmp = new NumericSpinBox(0, Integer.MAX_VALUE);
    private JLabel _uiJobDirLabel;
    private JTextField _uiJobDirCmp;
    private JCheckBox _logBadCmp;
    private JCheckBox _walletCheckBox;
    private JLabel _walletCredentialsLabel;
    private JTextField _walletCredentialsCmp;
    private JCheckBox _deleteDeployCheckBox;
    private String _hostName;
    private String _rootDir;
    private String _lastSelectedDir = this._rootDir = "/user";
    private String _oraConnType;
    private String _serviceName;
    private HadoopFileHelper _fileHelper;
    private DBObject _dbo;
    private int _parallel;
    private boolean _isDestPartitioned;
    private boolean _isSourcePartitioned;
    private boolean _init = false;
    private boolean _isHive = true;
    private boolean _isShowDestConnWarning = false;

    public void onEntry(TraversableContext traversableContext) {
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_TYPE);
        this._isHive = string != null && string.equals(HadoopWizArb.getString("HIVE_TABLE"));
        this._dbo = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        this._isSourcePartitioned = this._hProps.getValueBoolean(HadoopKeys.IS_SOURCE_PARTITIONED);
        this._isDestPartitioned = this._hProps.getValueBoolean(HadoopKeys.IS_DEST_PARTITIONED);
        this.build();
        super.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    protected void build() {
        if (!this._init) {
            this._init = true;
            this.setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new TitledBorder(null, HadoopWizArb.getString("OLH_PARMS"), 0, 0, null, null));
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            int n = 0;
            this.initParallel();
            this.initLoadMethod();
            this.initJobDir();
            this.initLogBad();
            this.initWallet();
            this.initDeleteDeploy();
            jPanel2.add((Component)this._loadMethodLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel2.add(this._loadMethodCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel2.add((Component)this._parallelLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel2.add((Component)this._parallelCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel.add((Component)jPanel2, "North");
            n = 0;
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            jPanel3.add((Component)this._uiJobDirLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel3.add((Component)this._uiJobDirCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel3.add((Component)this._logBadCmp, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel.add((Component)jPanel3, "South");
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(new TitledBorder(null, HadoopWizArb.getString("DEST_CONN"), 0, 0, null, null));
            JPanel jPanel5 = new JPanel(new GridBagLayout());
            jPanel5.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            n = 0;
            jPanel5.add((Component)this._walletCheckBox, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel5.add((Component)this._walletCredentialsLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel5.add((Component)this._walletCredentialsCmp, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel4.add((Component)jPanel5, "North");
            n = 0;
            this.add(jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.add(this._deleteDeployCheckBox, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
            if (this._isShowDestConnWarning) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)HadoopWizArb.getString("OLH_WARNING_CONNECTION"), (String)HadoopWizArb.getString("WARNING"), null);
            } else {
                this._isShowDestConnWarning = false;
            }
        }
    }

    protected void initParallel() {
        this._parallelCmp.setMinimum(1);
        this._parallelCmp.setToolTipText(HadoopWizArb.getString("OLH_PARALLEL_TIP"));
        this._parallelLabel.setToolTipText(HadoopWizArb.getString("OLH_PARALLEL_TIP"));
        this._parallel = 1;
        if (this._isDestPartitioned) {
            this._parallel = 16;
        }
        this._parallelLabel.setVisible(this._isDestPartitioned);
        this._parallelCmp.setVisible(this._isDestPartitioned);
        this._parallelCmp.setIntValue(this._parallel);
    }

    protected void initLoadMethod() {
        if (this._loadMethodCmp == null) {
            this._loadMethodLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._loadMethodLabel, this._loadMethodCmp, (String)HadoopWizArb.getString("METHOD_LABEL"));
            this._loadMethodCmp = new JComboBox();
            this._loadMethodCmp.setToolTipText(HadoopWizArb.getString("OLH_METHOD_TOOLTIP"));
            this._loadMethodCmp.addItem(HadoopWizArb.getString("METHOD_JDBC"));
            if (this._isDestPartitioned) {
                DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
                Properties properties = Connections.getInstance().getConnectionInfo(this._dbo.getConnectionName());
                this._oraConnType = properties.getProperty("OracleConnectionType");
                this._serviceName = properties.getProperty("serviceName");
                this._loadMethodCmp.addItem(HadoopWizArb.getString("METHOD_OCI"));
                if (this._oraConnType.equals(OracleConnectionType.BASIC.name()) && (this._serviceName == null || this._serviceName.isEmpty())) {
                    this._loadMethodCmp.setSelectedIndex(0);
                } else {
                    this._loadMethodCmp.setSelectedIndex(1);
                    if (!this._oraConnType.equals(OracleConnectionType.BASIC.name())) {
                        this._isShowDestConnWarning = true;
                    }
                }
            } else {
                this._loadMethodCmp.setSelectedIndex(0);
            }
        }
    }

    protected void initJobDir() {
        if (null == this._uiJobDirCmp) {
            this._uiJobDirLabel = new JLabel();
            this._hostName = (String)this._hProps.get(HadoopKeys.SSH_HOST);
            String string = HadoopUtils.getTempName("sqldev_olh");
            this._hProps.put(HadoopKeys.WORK_NAME, string);
            this._uiJobDirCmp = new JTextField("/user/" + this._hProps.get(HadoopKeys.SSH_USER) + "/sqldev_temp/" + string + "_log");
            ResourceUtils.resLabel((JLabel)this._uiJobDirLabel, (Component)this._uiJobDirCmp, (String)HadoopWizArb.getString("HDFS_JOB_DIR"));
            this._uiJobDirCmp.setToolTipText(HadoopWizArb.getString("JOB_DIR_TOOLTIP"));
        }
    }

    protected void initLogBad() {
        if (this._logBadCmp == null) {
            this._logBadCmp = new JCheckBox();
            this._logBadCmp.setSelected(true);
            ResourceUtils.resButton((AbstractButton)this._logBadCmp, (String)HadoopWizArb.getString("LOG_BAD"));
        }
    }

    protected void initWallet() {
        if (this._walletCheckBox == null) {
            this._walletCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._walletCheckBox, (String)HadoopWizArb.getString("USE_WALLET"));
            this._walletCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    OLHIOptionalParmsPage.this._walletCredentialsCmp.setEnabled(jCheckBox.isSelected());
                    OLHIOptionalParmsPage.this._walletCredentialsLabel.setEnabled(jCheckBox.isSelected());
                }
            });
            this._walletCredentialsLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this._walletCredentialsLabel, (Component)this._walletCredentialsCmp, (String)HadoopWizArb.getString("WALLET_CREDENTIALS"));
            this._walletCredentialsCmp = new JTextField();
            Dimension dimension = new Dimension(80, (int)this._walletCredentialsCmp.getPreferredSize().getHeight());
            this._walletCredentialsCmp.setPreferredSize(dimension);
            this._walletCheckBox.setSelected(false);
            this._walletCredentialsCmp.setEnabled(false);
            this._walletCredentialsLabel.setEnabled(false);
        }
    }

    protected void initDeleteDeploy() {
        if (this._deleteDeployCheckBox == null) {
            this._deleteDeployCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this._deleteDeployCheckBox, (String)HadoopWizArb.getString("DELETE_DEPLOY"));
            this._deleteDeployCheckBox.setSelected(true);
            this._deleteDeployCheckBox.setToolTipText(HadoopWizArb.getString("DELETE_DEPLOY_TIP"));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this._loadMethodName = (String)this._loadMethodCmp.getSelectedItem();
            this._hProps.put(HadoopKeys.LOAD_METHOD_NAME, this._loadMethodName);
            if (this._loadMethodName.equals(HadoopImportDataFormat.METHOD_OCI_NAME)) {
                this._hProps.put(ImportKeys.LOAD_METHOD, 5);
            } else {
                this._hProps.put(ImportKeys.LOAD_METHOD, 0);
            }
            if (this._oraConnType != null && this._oraConnType.equals(OracleConnectionType.BASIC.name()) && (this._serviceName == null || this._serviceName.isEmpty()) && this._loadMethodCmp.getSelectedIndex() == 1) {
                throw new TraversalException(HadoopWizArb.getString("OLH_ERROR_CONNECTION"));
            }
            this._hProps.put(HadoopKeys.PARALLEL, this._isDestPartitioned ? this._parallelCmp.getIntValue() : 1);
            String string = (String)this._hProps.get(HadoopKeys.JOB_DIR);
            String string2 = this._uiJobDirCmp.getText();
            if (string2 == null || string2.isEmpty()) {
                throw new TraversalException(HadoopWizArb.getString("JOB_DIR_MISSING_ERROR"));
            }
            if (string == null || !string.equals(string2)) {
                String string3 = "hadoop fs -mkdir -p " + string2;
                Session session = (Session)this._hProps.get(HadoopKeys.SSH_SESSION);
                ScriptOutput scriptOutput = HadoopUtils.executeScript(session, string3);
                if (scriptOutput.rc != 0) {
                    String string4 = "STDOUT: " + scriptOutput.stdout + HadoopUtils.getTerm() + "STDERR: " + scriptOutput.stderr + HadoopUtils.getTerm();
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(HadoopWizArb.getString("JOB_DIR_ERROR1"), string4);
                    throw new DetailedTraversalException(null);
                }
                string3 = "hadoop fs -rmdir " + string2;
                scriptOutput = HadoopUtils.executeScript(session, string3);
                if (scriptOutput.rc != 0) {
                    String string5 = "STDOUT: " + scriptOutput.stdout + HadoopUtils.getTerm() + "STDERR: " + scriptOutput.stderr + HadoopUtils.getTerm();
                    MessageDetailsDialog messageDetailsDialog = new MessageDetailsDialog();
                    messageDetailsDialog.showErrorDialog(HadoopWizArb.getString("JOB_DIR_ERROR2"), string5);
                    throw new DetailedTraversalException(null);
                }
                this._hProps.put(HadoopKeys.JOB_DIR, string2);
            }
            this._hProps.put(HadoopKeys.LOG_BAD_RECS, this._logBadCmp.isSelected());
            if (!this._walletCheckBox.isSelected()) {
                HadoopUIUtils.updateConnectionInfo(this._hProps, (String)this._hProps.get(HadoopKeys.DEST_CONN_NAME));
            } else if (this._walletCredentialsCmp.getText().length() == 0) {
                throw new TraversalException(HadoopWizArb.getString("WALLET_CREDENTIALS_MISSING"));
            }
            this._hProps.put(HadoopKeys.IS_USE_WALLET, this._walletCheckBox.isSelected());
            this._hProps.put(HadoopKeys.WALLET_CREDENTIAL, this._walletCredentialsCmp.getText());
            this._hProps.put(HadoopKeys.DELETE_DEPLOY, this._deleteDeployCheckBox.isSelected());
        }
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        return "Fin";
    }
}

