/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopGenericTable;
import oracle.dbtools.raptor.hadoop.core.HadoopImportDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public abstract class HadoopImportMethodPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 8282169188783793125L;
    private static final Logger LOGGER = Logger.getLogger(HadoopImportMethodPage.class.getName());
    protected JLabel _tableNameLabel;
    protected JTextField _tableNameField;
    protected JTextField _stagingTableNameField;
    protected JLabel _stagingTableNameLabel;
    protected JCheckBox _dropStagingTable;
    protected String _stagingTableName;
    protected String _stagingSuffix;
    protected HadoopGenericTable _table;
    protected JTextPane _instructions;
    protected JPanel _mainPanel;
    private boolean _init = false;
    protected boolean _isExistingTable;
    protected TraversableContext _ctx;
    protected JLabel _loadMethodLabel;
    protected String _loadMethodName;
    protected JComboBox<String> _loadMethod;
    protected DefaultComboBoxModel<String> _loadMethodModel;
    protected boolean _isOracleLoaderReadable = true;
    protected Boolean _isSourcePartitioned;
    private DBUtil _dbUtil;
    protected HadoopProperties _hProps;

    protected abstract void build();

    protected abstract String getDefaultExistingMethodName(boolean var1);

    protected abstract String getDefaultNewMethodName(boolean var1);

    protected abstract String[] getExistingLoadMethods(boolean var1);

    protected abstract String[] getNewLoadMethods(boolean var1);

    protected abstract String getMethodToolTip();

    public void onEntry(TraversableContext traversableContext) {
        this._ctx = traversableContext;
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (this._init && this._isSourcePartitioned != this._hProps.getValueBoolean(HadoopKeys.IS_SOURCE_PARTITIONED)) {
            this.removeAll();
            this._init = false;
        }
        this._isSourcePartitioned = this._hProps.getValueBoolean(HadoopKeys.IS_SOURCE_PARTITIONED);
        if (!this._init) {
            this._init = true;
            this.initComponents();
            this.build();
            this._isExistingTable = this._hProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            this.populateDBO(traversableContext);
            this.populateTableName();
            this._loadMethodModel = null;
            boolean bl = (Boolean)this._hProps.get(ImportKeys.IS_CONFIGFILE);
            String string = bl ? (String)this._hProps.get(HadoopKeys.LOAD_METHOD_NAME) : this.getDefaultNewMethodName(this._isOracleLoaderReadable);
            if (this._isExistingTable && !bl) {
                this._loadMethodModel = new DefaultComboBoxModel<String>(this.getExistingLoadMethods(this._isOracleLoaderReadable));
                string = this.getDefaultExistingMethodName(this._isOracleLoaderReadable);
            } else {
                this._loadMethodModel = new DefaultComboBoxModel<String>(this.getNewLoadMethods(this._isOracleLoaderReadable));
            }
            if (bl) {
                this._stagingTableName = (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME);
                this._tableNameField.setText((String)this._hProps.get(ImportKeys.TABLE_NAME));
            }
            this.setLayout(new BorderLayout());
            this.add(this._mainPanel, "North");
            this._loadMethod.setToolTipText(this.getMethodToolTip());
            this._loadMethod.setModel(this._loadMethodModel);
            try {
                this._loadMethodModel.setSelectedItem(string);
            }
            catch (Exception exception) {
                string = HadoopImportDataFormat.METHOD_JDBC_NAME;
                this._loadMethodModel.setSelectedItem(HadoopImportDataFormat.METHOD_JDBC_NAME);
            }
            this.changeLoadMethod(string);
        }
    }

    protected void initComponents() {
        DBConfig dBConfig = DBConfig.getInstance();
        this._stagingSuffix = HadoopWizArb.getString("STAGING_TABLE_NAME_SUFFIX");
        this._instructions = new JTextPane();
        this._instructions.setEditable(false);
        this._instructions.setOpaque(false);
        this._instructions.setRequestFocusEnabled(false);
        this._instructions.setFocusable(false);
        this._instructions.setText(HadoopWizArb.getString("METHOD_EXISTING_INFO"));
        this._mainPanel = new JPanel(new GridBagLayout());
        this._loadMethodLabel = new JLabel();
        this._loadMethodLabel.setText(HadoopWizArb.getString("METHOD_LABEL"));
        this._loadMethod = new JComboBox();
        this._loadMethodLabel.setLabelFor(this._loadMethod);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    HadoopImportMethodPage.this.changeLoadMethod((String)HadoopImportMethodPage.this._loadMethodModel.getSelectedItem());
                }
            }
        };
        this._loadMethod.addItemListener(itemListener);
        this._tableNameLabel = new JLabel(StringUtils.stripMnemonic((String)HadoopWizArb.getString("TABLE_NAME_LABEL")));
        this._tableNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)HadoopWizArb.getString("TABLE_NAME_LABEL")));
        this._tableNameField = new JTextField();
        this._tableNameLabel.setLabelFor(this._tableNameField);
        this._tableNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                if (string != null && string.trim().length() > 0) {
                    HadoopImportMethodPage.this._table.setTableName(string);
                    HadoopImportMethodPage.this._table.getTable().setTablename(string);
                    HadoopImportMethodPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    HadoopImportMethodPage.this._tableNameField.setText("");
                    HadoopImportMethodPage.this._table.setTableName("");
                    HadoopImportMethodPage.this._table.getTable().setTablename("");
                    HadoopImportMethodPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
                HadoopImportMethodPage.this._stagingTableName = string.startsWith("\"") && string.endsWith("\"") ? string.substring(0, string.length() - 2) + HadoopImportMethodPage.this._stagingSuffix + "\"" : string + HadoopImportMethodPage.this._stagingSuffix;
                HadoopImportMethodPage.this._stagingTableNameField.setText(HadoopImportMethodPage.this._stagingTableName);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this._tableNameField.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                String string2 = HadoopImportMethodPage.this._tableNameField.getText();
                HadoopImportMethodPage.this._stagingTableName = string2.startsWith("\"") && string2.endsWith("\"") ? string2.substring(0, string2.length() - 2) + HadoopImportMethodPage.this._stagingSuffix + "\"" : string2 + HadoopImportMethodPage.this._stagingSuffix;
                HadoopImportMethodPage.this._stagingTableNameField.setText(HadoopImportMethodPage.this._stagingTableName);
                HadoopImportMethodPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            }
        });
        this._stagingTableNameLabel = new JLabel();
        this._stagingTableNameLabel.setText(this._isSourcePartitioned != false ? HadoopWizArb.getString("STAGING_META_TABLE_NAME_LABEL") : HadoopWizArb.getString("STAGING_TABLE_NAME_LABEL"));
        this._dropStagingTable = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._dropStagingTable, (String)HadoopWizArb.getString("METHOD_DROP_STAGING"));
        this._dropStagingTable.setToolTipText(HadoopWizArb.getString("METHOD_DROP_STAGING_TIP"));
        this._dropStagingTable.setSelected(true);
        this._stagingTableNameField = new JTextField();
        this._stagingTableNameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                if (string != null && string.trim().length() > 0) {
                    HadoopImportMethodPage.this._stagingTableName = HadoopImportMethodPage.this._stagingTableNameField.getText();
                    HadoopImportMethodPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                } else {
                    HadoopImportMethodPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this._stagingTableNameField.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(n, string, attributeSet);
                HadoopImportMethodPage.this._stagingTableName = HadoopImportMethodPage.this._stagingTableNameField.getText();
                HadoopImportMethodPage.this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            }
        });
    }

    protected void changeLoadMethod(String string) {
        this._loadMethodName = string;
        this.switchComponents(this._loadMethodName.equalsIgnoreCase(HadoopImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE_NAME));
        this._stagingTableNameField.setText(this._stagingTableName);
    }

    private void populateTableName() {
        String string;
        this._tableNameField.setEnabled(!this._isExistingTable);
        String string2 = string = this._table.getTable().getTablename() == null ? "" : this._table.getTable().getTablename();
        if (!this._isExistingTable) {
            this._tableNameField.setText(string);
        } else {
            this._tableNameField.setText(DBUtil.addDoubleQuote((String)string));
        }
        DBConfig dBConfig = DBConfig.getInstance();
        if (this._stagingTableName == null) {
            this._stagingTableName = string.startsWith("\"") && string.endsWith("\"") ? string.substring(0, string.length() - 2) + this._stagingSuffix + "\"" : string + this._stagingSuffix;
        }
        this._stagingTableNameField.setText(this._stagingTableName);
        if (this._tableNameField.getText().trim().length() > 0) {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
            DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
            String string = ((DBObject)this._hProps.get(ImportKeys.DBOBJECT)).getConnectionName();
            this._dbUtil = DBUtil.getInstance((String)string);
            String string2 = (String)this._hProps.get(ImportKeys.TABLE_NAME);
            String string3 = this._tableNameField.getText().trim();
            if (!(this._isExistingTable || string2 != null && string3.equals(string2))) {
                if (string3.length() > 0) {
                    if (!dBObject.getDatabase().isValidName("TABLE", string3)) {
                        throw new TraversalException(HadoopWizArb.getString("INVALID_TABLE_NAME"));
                    }
                } else {
                    this._tableNameField.setText("");
                    throw new TraversalException(HadoopWizArb.getString("INVALID_TABLE_NAME"));
                }
                this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                if (this._dbUtil.resolveName(string3) != null) {
                    throw new TraversalException(HadoopWizArb.format("TABLE_NAME_EXISTS_ERROR", string3));
                }
            }
            if (this._loadMethodName.equals(HadoopImportDataFormat.METHOD_EXTERNAL_TABLE_NAME) || this._loadMethodName.equals(HadoopImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE_NAME) || this._loadMethodName.equals(HadoopImportDataFormat.METHOD_SQLLDR_NAME)) {
                this._hProps.put(ImportKeys.SELECTED_COLUMNS, this._hProps.get(ImportKeys.FILE_COLUMNS));
                this._hProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
            }
            if (this._loadMethodName.equals(HadoopImportDataFormat.METHOD_EXTERNAL_TABLE_NAME)) {
                this._hProps.put(ImportKeys.LOAD_METHOD, 2);
            } else if (this._loadMethodName.equals(HadoopImportDataFormat.METHOD_STAGING_EXTERNAL_TABLE_NAME)) {
                this.validateStagingTable();
                this._hProps.put(ImportKeys.LOAD_METHOD, 3);
                this._hProps.put(ImportKeys.DROP_STAGING_TABLE, this._dropStagingTable.isSelected());
            } else {
                this._hProps.put(ImportKeys.LOAD_METHOD, 0);
            }
            this._hProps.put(ImportKeys.IS_EXISTING_TABLE, this._isExistingTable);
            String string4 = this._isExistingTable ? dBObject.getSchemaName() : HadoopUtils.getFolderSchema(dBObject);
            this._hProps.put(HadoopKeys.DEST_SCHEMA, string4);
            this._hProps.put(ImportKeys.TABLE_NAME, this._tableNameField.getText());
            this._table.setTableName(this._tableNameField.getText());
            this._hProps.put(HadoopKeys.LOAD_METHOD_NAME, this._loadMethodName);
        }
    }

    protected void validateStagingTable() throws TraversalException {
        String string = this._stagingTableNameField.getText().trim();
        String string2 = (String)this._hProps.get(ImportKeys.STAGING_TABLE_NAME);
        this._hProps.put(ImportKeys.STAGING_TABLE_NAME, string);
        this._hProps = (HadoopProperties)((Object)this._ctx.get("HADOOP_PROPERTIES"));
        DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
        if (string.length() > 0) {
            if (string.equals(this._tableNameField.getText().trim())) {
                throw new TraversalException(HadoopWizArb.getString("STAGING_AND_TABLE_SAME"));
            }
            if (string2 == null || !string2.equals(string)) {
                if (!dBObject.getDatabase().isValidName("TABLE", this._stagingTableNameField.getText().trim())) {
                    throw new TraversalException(HadoopWizArb.getString("INVALID_STAGING_TABLE_NAME"));
                }
                if (this._dbUtil.resolveName(string) != null) {
                    throw new TraversalException(HadoopWizArb.format("STAGING_TABLE_NAME_EXISTS_ERROR", string));
                }
            }
        } else {
            throw new TraversalException(HadoopWizArb.getString("MISSING_STAGING_TABLE_NAME"));
        }
        this._ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private void populateDBO(TraversableContext traversableContext) {
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        HadoopGenericTable hadoopGenericTable = null;
        if (this._hProps.get(ImportKeys.TABLE) != null) {
            hadoopGenericTable = (HadoopGenericTable)((Object)this._hProps.get(ImportKeys.TABLE));
            this.setTable(hadoopGenericTable);
        } else {
            if (this._hProps.get(ImportKeys.DBOBJECT) == null) {
                hadoopGenericTable = new HadoopGenericTable();
            } else if (((DBObject)this._hProps.get(ImportKeys.DBOBJECT)).getObjectName() != null) {
                DBObject dBObject = (DBObject)this._hProps.get(ImportKeys.DBOBJECT);
                try {
                    hadoopGenericTable = new HadoopGenericTable(dBObject.getConnection(), dBObject.getSchemaName(), dBObject.getObjectName());
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
            } else {
                hadoopGenericTable = new HadoopGenericTable();
            }
            if (!this._isExistingTable) {
                hadoopGenericTable.setColumns((Column[])this._hProps.get(ImportKeys.FILE_COLUMNS));
            }
            this.setTable(hadoopGenericTable);
            this._hProps.put(ImportKeys.TABLE, (Object)hadoopGenericTable);
        }
        this.setInstruction((DBObject)this._hProps.get(ImportKeys.DBOBJECT));
    }

    private void setInstruction(DBObject dBObject) {
        if (dBObject != null && dBObject.getObjectName() != null) {
            this._instructions.setText(HadoopWizArb.getString("METHOD_EXISTING_INFO"));
            return;
        }
        this._instructions.setText(HadoopWizArb.getString("METHOD_CREATE_INFO"));
    }

    protected void switchComponents(boolean bl) {
        this.enableStagingComponents(bl);
        if (this._isSourcePartitioned.booleanValue()) {
            this._tableNameLabel.setText(bl ? StringUtils.stripMnemonic((String)HadoopWizArb.getString("TABLE_NAME_LABEL")) : StringUtils.stripMnemonic((String)HadoopWizArb.getString("META_TABLE_NAME_LABEL")));
        } else {
            this._tableNameLabel.setText(bl ? StringUtils.stripMnemonic((String)HadoopWizArb.getString("TABLE_NAME_LABEL")) : StringUtils.stripMnemonic((String)HadoopWizArb.getString("DEST_XTAB_LABEL")));
        }
    }

    private void enableStagingComponents(boolean bl) {
        this._stagingTableNameField.setEnabled(bl);
        this._stagingTableNameLabel.setEnabled(bl);
        this._dropStagingTable.setEnabled(bl);
    }

    private void setTable(HadoopGenericTable hadoopGenericTable) {
        this._table = hadoopGenericTable;
    }
}

