/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.extract.models.ExtractListModel;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.ui.BDACopyActionExistPanel;
import oracle.dbtools.raptor.hadoop.ui.BDACopyDBConnPanel;
import oracle.dbtools.raptor.hadoop.ui.BDACopyDirectoriesPanel;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class BDACopyGeneralPage
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private HadoopProperties _hProps;
    private BDACopyDBConnPanel _copyDBConnPanel = new BDACopyDBConnPanel();
    private BDACopyDirectoriesPanel _copyDirsPanel = new BDACopyDirectoriesPanel();
    private BDACopyActionExistPanel _copyActionPanel = new BDACopyActionExistPanel();
    private final JCheckBox _chkbxToSummary = new JCheckBox();
    private ExtractListModel _listModel;
    private TargetFormat _targetFormat;
    private boolean init = false;
    private TraversableContext _dataContext;

    public void onEntry(TraversableContext traversableContext) {
        this._dataContext = traversableContext;
        this._hProps = (HadoopProperties)((Object)traversableContext.get("HADOOP_PROPERTIES"));
        this._dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        this._listModel = (ExtractListModel)this._hProps.get(HadoopKeys.EXTRACT_LIST_MODEL);
        this._copyDBConnPanel.setSourceConnection((String)this._hProps.get(HadoopKeys.SOURCE_CONN_NAME));
        this._copyDBConnPanel.setTargetConnection((String)this._hProps.get(HadoopKeys.DEST_CONN_NAME));
        if (!this.init) {
            this.build();
            this.init = true;
        }
    }

    private void build() {
        this._targetFormat = new TargetFormat(1, 1, false);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._chkbxToSummary, (String)HadoopWizArb.getString("GOTO_SUMMARY"));
        this._chkbxToSummary.setEnabled(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add((Component)this._chkbxToSummary, "South");
        this.add(jPanel2, "South");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)this._copyDBConnPanel.getPanel(this._hProps), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this._copyDirsPanel.getPanel(this._hProps), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 23, 1, new Insets(6, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this._copyActionPanel.getPanel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 23, 1, new Insets(6, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel3.add((Component)jPanel4, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 20, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.setBorder(BorderFactory.createEmptyBorder());
        this.add(jPanel3, "Center");
    }

    protected void repaintPanel() {
        this.repaint();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Object[] objectArray;
        boolean bl;
        String string = this._copyDBConnPanel.getSourceConnection();
        Connection connection = null;
        this._dataContext = traversableContext;
        if (string != null) {
            try {
                connection = Connections.getInstance().getConnection(string);
            }
            catch (Exception exception) {
                Throwable throwable;
                Exception exception2;
                while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                    exception2 = (Exception)throwable;
                }
                ExceptionHandler.handleException((String)string, (Throwable)exception2);
                throw new TraversalException(null);
            }
        }
        if (connection == null) {
            throw new TraversalException(HadoopWizArb.getString("NO_SOURCE_CONNECTION"));
        }
        String string2 = this._copyDBConnPanel.getTargetConnection();
        Connection connection2 = null;
        if (string2 != null) {
            try {
                connection2 = Connections.getInstance().getConnection(string2);
            }
            catch (Exception exception) {
                Throwable throwable;
                Exception exception3;
                while (exception3 instanceof DBException && (throwable = exception3.getCause()) instanceof Exception) {
                    exception3 = (Exception)throwable;
                }
                ExceptionHandler.handleException((String)string2, (Throwable)exception3);
                throw new TraversalException(null);
            }
        }
        if (connection2 == null) {
            throw new TraversalException(HadoopWizArb.getString("NO_DEST_CONNECTION"));
        }
        if (this.checkDatabaseConnections(connection, connection2)) {
            throw new TraversalException(HadoopWizArb.getString("SAME_CONNECTION"));
        }
        if (RaptorVersionTracker.getDbVersion((Connection)connection).compareTo(RaptorVersionTracker.getDbVersion((Connection)connection2)) > 0 && !(bl = MessageDialog.confirm((Component)((Object)this), (Object)HadoopWizArb.format("COMPATIBILITY_WARNING", objectArray = new Object[]{Connections.getDisplayName((String)string), RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString(), Connections.getDisplayName((String)string2), RaptorVersionTracker.getDbVersion((Connection)connection2).toCanonicalString()}), (String)HadoopWizArb.getString("COMPATIBILITY_TITLE"), null))) {
            throw new TraversalException(null);
        }
        this._hProps.put(HadoopKeys.SOURCE_CONN, connection);
        this._hProps.put(HadoopKeys.SOURCE_CONN_NAME, string);
        this._dataContext.put(HadoopKeys.SOURCE_CONN_NAME.toString(), (Object)string);
        this._hProps.put(HadoopKeys.DEST_CONN, connection2);
        this._hProps.put(HadoopKeys.DEST_CONN_NAME, string2);
        this._hProps.put(ImportKeys.CONNECTION_NAME, string);
        this._listModel.setSourceConnName(string);
        this._listModel.setDestConnName(string2);
        this._copyDirsPanel.onExit();
        this._listModel.isDDLEnabled(false);
        this._listModel.isDataEnabled(true);
        this._hProps.put(HadoopKeys.DDL_ENABLED, false);
        this._hProps.put(HadoopKeys.DATA_ENABLED, true);
        this._hProps.put(HadoopKeys.SKIP, this._copyActionPanel.getSkip());
        this._hProps.put(HadoopKeys.REPLACE, this._copyActionPanel.getReplace());
        this._hProps.put(HadoopKeys.APPEND, this._copyActionPanel.getAppend());
    }

    public Object getExitTransition() {
        return this.getTransition();
    }

    private Object getTransition() {
        if (this._chkbxToSummary.isSelected()) {
            return "Fin";
        }
        return "A";
    }

    protected boolean validateRolesOfUsers(String string) {
        boolean bl = false;
        try {
            DBUtil dBUtil = DBUtil.getInstance((String)string);
            String string2 = Connections.getInstance().getConnection(string).getMetaData().getUserName();
            String string3 = "select granted_role ROLE from USER_ROLE_PRIVS where username = '" + string2 + "'";
            List list = dBUtil.executeReturnList(string3, null);
            for (Map map : list) {
                if (!"DBA".equals((String)map.get("ROLE"))) continue;
                bl = true;
                break;
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (DBException dBException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return bl;
    }

    public boolean validateDatabases(Connection connection, Connection connection2) {
        boolean bl = false;
        try {
            String string = connection.getMetaData().getURL();
            String string2 = connection2.getMetaData().getURL();
            if (string.equals(string2)) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return bl;
    }

    public boolean checkDatabaseConnections(Connection connection, Connection connection2) {
        boolean bl = false;
        try {
            String string;
            String string2;
            if (this.validateDatabases(connection, connection2) && (string2 = connection.getMetaData().getUserName()).equals(string = connection2.getMetaData().getUserName())) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return bl;
    }
}

