/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.readers;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.readservice.DataFormatException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.data.readers.DataReader;
import oracle.dbtools.raptor.data.readers.DataReaderException;
import oracle.dbtools.raptor.datatools.core.BaseDataFormat;
import oracle.dbtools.raptor.hadoop.core.HadoopGenericTable;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.jdbc.OracleResultSet;

public class TableReader
extends DataReader {
    public static final String NAME = "Table";
    public static final String FORMAT = BaseDataFormat.DELIMITED;
    public static final String EXT = "dsv";
    public static final int BUFFER_SIZE = 1024;
    public static final int BUFFER_KSIZE = 1;
    public static final String KEY_HEADER = "IMPORT_DLM_HEADER";
    public static final String KEY_DELIMITER = "IMPORT_DLM_DELIMITER";
    public static final String KEY_REC_TERM = "IMPORT_DLM_REC_TERM";
    public static final String KEY_ENCL_LEFT = "IMPORT_DLM_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "IMPORT_DLM_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "IMPORT_DLM_ENCL_RIGHT_DOUBLE";
    private List<Object[]> m_previewRows = null;
    private HadoopGenericTable _genTable;
    private ResultSet _rs;
    private List<?> _bindList;
    private Map<String, ?> _bindMap;

    public void setGenericTable(HadoopGenericTable hadoopGenericTable) {
        this._genTable = hadoopGenericTable;
    }

    public String getName() {
        return NAME;
    }

    public String getType() {
        return EXT;
    }

    public String getFormat() {
        return FORMAT;
    }

    public String[] getColumnNames() {
        this.m_headerRowColumnNames = new String[this._genTable.getTable().getColumnCount()];
        int n = 0;
        for (Column column : this._genTable.getColumns()) {
            this.m_headerRowColumnNames[n++] = column.getName();
        }
        return this.m_headerRowColumnNames;
    }

    public boolean hasMoreRows() {
        return false;
    }

    public void openFile(String string) throws DataReaderException {
        this.openTable();
    }

    public void closeFile() {
    }

    public void start() throws DataReaderException {
    }

    public void openTable() {
        if (this._rs == null) {
            String string = "";
            string = this._genTable.getSchema() != null && this._genTable.getSchema().length() > 0 ? "select * from " + this._genTable.getSchema() + "." + this._genTable.getTable().getTablename() : "select * from " + this._genTable.getTable().getTablename();
            try {
                HashMap hashMap = new HashMap();
                if (Connections.getInstance().lock(this._genTable.getConnection())) {
                    this._rs = DBUtil.getInstance((Connection)this._genTable.getConnection()).executeQuery(string, (List)null);
                } else {
                    System.out.println("Unable to get lock for connection");
                }
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            finally {
                Connections.getInstance().unlock(this._genTable.getConnection());
            }
        }
    }

    public void refreshPreview(boolean bl) {
        super.refreshPreview(bl);
    }

    public int getColumnCount() {
        return this._genTable.getTable().getColumnCount();
    }

    public String getType(int n) {
        return this._genTable.getColumn(n).getType();
    }

    public int getWidth(int n) {
        return this._genTable.getColumn(n).getPrecision();
    }

    public int getNosPages() {
        return 1;
    }

    public String[] getPageNames() {
        return null;
    }

    public String getPageLabel() {
        return null;
    }

    public void setPage(int n) {
    }

    public Object[] readline() throws DataFormatException {
        return null;
    }

    public void restartPreview() {
    }

    public void closePreviewFile() {
    }

    public List<Object[]> getPreviewRows() {
        if (this.m_previewRows == null) {
            this.m_previewRows = new ArrayList<Object[]>();
            try {
                int n = 0;
                while (this._rs != null && this._rs.next() && n < 100) {
                    ++n;
                    Object object = null;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < this._genTable.getTable().getColumnCount(); ++i) {
                        object = this._rs instanceof OracleResultSet ? ((OracleResultSet)this._rs).getObject(i + 1) : this._rs.getObject(i + 1);
                        try {
                            arrayList.add(i, this.getValue(object));
                            continue;
                        }
                        catch (Exception exception) {
                            arrayList.add("");
                        }
                    }
                    this.m_previewRows.add(arrayList.toArray(new String[arrayList.size()]));
                }
                this._rs.close();
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
        }
        return this.m_previewRows;
    }

    private String getValue(Object object) {
        try {
            return DataTypesUtil.stringValue((Object)object, (Connection)this._genTable.getConnection());
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    public boolean isLineTerminatorSupported() {
        return false;
    }

    public boolean isDelimiterSupported() {
        return false;
    }

    public boolean isDelimiterConfigurable() {
        return false;
    }

    public boolean isEnclosuresSupported() {
        return false;
    }

    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }
}

