/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.hadoop.execute;

import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.text.SimpleDateFormat;
import javax.swing.SwingUtilities;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportDataFormat;
import oracle.dbtools.raptor.data.core.ImportKeys;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.hadoop.core.HadoopEncryption;
import oracle.dbtools.raptor.hadoop.core.HadoopKeys;
import oracle.dbtools.raptor.hadoop.core.HadoopProperties;
import oracle.dbtools.raptor.hadoop.core.HadoopUtils;
import oracle.dbtools.raptor.hadoop.execute.HadoopExec;
import oracle.dbtools.raptor.hadoop.ui.HadoopWizArb;
import oracle.dbtools.raptor.nls.JavaFormat;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.transfer.location.JSchSessionLocation;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class OLHExec
extends HadoopExec {
    public static final int TYPE_DB_OBJECTS = 0;
    public static final int TYPE_QUERY = 1;
    public static final int SUCCESS = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static final String P_IFORMAT = "mapreduce.job.inputformat.class=";
    private static final String P_HIVE_DBN = "oracle.hadoop.loader.input.hive.databaseName=";
    private static final String P_HIVE_TABLE_NAME = "oracle.hadoop.loader.input.hive.tableName=";
    private static final String P_INPUT_DIR = "mapred.input.dir=";
    private static final String P_HIVE_FIELD_TERM = "oracle.hadoop.loader.input.fieldTerminator=";
    private static final String P_OFORMAT = "mapreduce.job.outputformat.class=";
    private static final String P_ODIR = "mapreduce.output.fileoutputformat.outputdir=";
    private static final String P_CONN_URL = "oracle.hadoop.loader.connection.url=";
    private static final String P_CONN_USER = "oracle.hadoop.loader.connection.user=";
    private static final String P_CONN_P = "oracle.hadoop.loader.connection.password";
    private static final String P_LOG_BAD = "oracle.hadoop.loader.logBadRecords=";
    private static final String P_MAP_REDUCE_TASKS = "mapred.reduce.tasks=";
    private static final String P_WALLET_LOC = "oracle.hadoop.loader.connection.wallet_location=${WALLET_LOCATION}";
    private static final String P_WALLET_TNS_ENTRY = "oracle.hadoop.loader.connection.tnsEntryName=";
    private static final String P_WALLET_TNS_ADMIN = "oracle.hadoop.loader.connection.tns_admin=${TNS_ADMIN}";
    private static final String P_CONF = "-conf MyConf.xml";
    private static final String P_LIBJARS = "-libjars ${OLH_LIB_JARS}";
    private static final String P_LM_TARGET_TABLE = "oracle.hadoop.loader.loaderMap.targetTable=";
    private static final String P_LM_COL_NAMES = "oracle.hadoop.loader.loaderMap.columnNames=";
    private static final String P_LM_FIELD_PREFIX = "oracle.hadoop.loader.loaderMap.";
    private static final String P_LM_FIELD_SUFFIX = ".field=";
    private static final String P_LM_FIELD_SUFFIX_DATE_FORMAT = ".format=";
    private static final String P_FIELD_ENCLOSURE_INITIAL = "oracle.hadoop.loader.input.initialFieldEncloser=";
    private static final String P_FIELD_ENCLOSURE_TRAILING = "oracle.hadoop.loader.input.trailingFieldEncloser=";
    private static final String P_FIELD_TERM = "oracle.hadoop.loader.input.fieldTerminator=";
    private static final String P_ROW_FILTER = "oracle.hadoop.loader.input.hive.rowFilter=";
    private static final String V_IFORMAT_HIVE2AVRO = "oracle.hadoop.loader.lib.input.HiveToAvroInputFormat";
    private static final String V_IFORMAT_DELIMITED = "oracle.hadoop.loader.lib.input.DelimitedTextInputFormat";
    private static final String V_OFORMAT_OCI = "oracle.hadoop.loader.lib.output.OCIOutputFormat";
    private static final String V_OFORMAT_JDBC = "oracle.hadoop.loader.lib.output.JDBCOutputFormat";
    private static final String V_TRUE = "true";
    private static final String V_FALSE = "false";
    private static final String V_TAB = "\t";
    private static final String CLASSPATH1 = "setenv HADOOP_CLASSPATH  ";
    private static final String CLASSPATH2 = "/jlib/*\n";
    private static final String ENV = "#!/bin/bash\nsource .sqldev_olh_env\nenv\n";
    private static final String MKDIR = "mkdir -p ";
    private static final String EXEC_OLH = "hadoop jar  ${OLH_HOME}/jlib/oraloader.jar oracle.hadoop.loader.OraLoader";
    private static final String PARM = "-D ";
    private static final String SEP = " \\\n";
    private static final String EXEC = "\r\n";
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    protected final String ENCODING_UTF8 = "UTF-8";
    private RaptorTask<Void> _task = null;
    private ExtractObject _EO;
    private DBObject _dbo;
    boolean _isExistingTable;
    boolean _isCleanupNeeded = false;
    boolean _isSuccess = true;
    boolean _isStaging;
    boolean _isDropStaging;
    boolean _isWallet;
    private String encoding = IdeUtil.getIdeEncoding();
    private String _tempDir;
    private String _tempName;
    private String _script;
    private String _xmlName;
    private String _xml;
    private String _outputFormat;
    private String _outputDir;
    private ScriptOutput _result;
    private int finalStatus = 0;

    @Override
    public ExitCode start(HadoopProperties hadoopProperties) {
        this._isExistingTable = (Boolean)hadoopProperties.get(ImportKeys.IS_EXISTING_TABLE);
        this._logPrefix = HadoopWizArb.getString("OLH_EXEC_LOG_PREFIX");
        this._tempDir = "sqldev_temp/";
        this._tempName = HadoopUtils.getTempName("sqldev_olh");
        this._outputFormat = hadoopProperties.getValueInteger(ImportKeys.LOAD_METHOD) == 5 ? V_OFORMAT_OCI : V_OFORMAT_JDBC;
        this._outputDir = (String)hadoopProperties.get(HadoopKeys.JOB_DIR);
        this._exitCode = super.start(hadoopProperties);
        this._destUser = HadoopUtils.getOracleUser(this._hProps);
        this._destConnUrl = HadoopUtils.getOracleUrl(this._hProps);
        this.openLog();
        this.loadTemplates();
        this.log(HadoopWizArb.format("OLH_EXEC_START", HadoopWizArb.getString("OLH_MAIN_TITLE")));
        return this._exitCode;
    }

    @Override
    public ExitCode doExec() {
        this.doWithRaptorTask();
        return this._exitCode;
    }

    public String getScript() {
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_TYPE);
        this._EO = (ExtractObject)this._hProps.get(HadoopKeys.EXTRACT_OBJECT);
        if (this._EO != null) {
            this._dbo = this._EO.getDBObject();
        }
        this._tempName = (String)this._hProps.get(HadoopKeys.WORK_NAME);
        this._script = string != null && string.equals(HadoopWizArb.getString("HIVE_TABLE")) ? this.getHiveScript() : this.getTextScript();
        return this._script;
    }

    private String getHiveScript() {
        String string = HadoopWizArb.format("OLH_EXEC_STEP_LOAD", this._destTableName, this._destConnDisplayName, this._dbo.getSchemaName() + "." + this._dbo.getObjectName());
        this.log("\n" + HadoopWizArb.format("OLH_EXEC_STEP_START", string));
        String string2 = "/ade/jscapicc_hadoop01/oracle/work/olhp_scratch/oraloader-3.4.0-h2";
        StringBuilder stringBuilder = new StringBuilder("hadoop jar  ${OLH_HOME}/jlib/oraloader.jar oracle.hadoop.loader.OraLoader \\\n");
        stringBuilder.append("-D mapreduce.job.inputformat.class=oracle.hadoop.loader.lib.input.HiveToAvroInputFormat \\\n");
        stringBuilder.append("-D oracle.hadoop.loader.input.hive.databaseName=" + this._dbo.getSchemaName() + SEP);
        stringBuilder.append("-D oracle.hadoop.loader.input.hive.tableName=" + this._dbo.getObjectName() + SEP);
        stringBuilder.append("-D mapreduce.job.outputformat.class=" + this._outputFormat + SEP);
        stringBuilder.append("-D mapreduce.output.fileoutputformat.outputdir=" + this._outputDir + SEP);
        stringBuilder.append("-D oracle.hadoop.loader.logBadRecords=" + (this._hProps.getValueBoolean(HadoopKeys.LOG_BAD_RECS) != false ? V_TRUE : V_FALSE) + SEP);
        stringBuilder.append("-D mapred.reduce.tasks=" + this._hProps.getValueInteger(HadoopKeys.PARALLEL).toString() + SEP);
        String string3 = (String)this._hProps.get(HadoopKeys.WHERE);
        if (string3 != null) {
            string3.trim();
            if (!string3.isEmpty()) {
                stringBuilder.append("-D oracle.hadoop.loader.input.hive.rowFilter='" + string3 + " '" + SEP);
            }
        }
        stringBuilder.append("-D oracle.hadoop.loader.loaderMap.targetTable=" + this._destTableName + SEP);
        GenericTable genericTable = (GenericTable)this._hProps.get(ImportKeys.TABLE);
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "";
        for (Column column : genericTable.getColumns()) {
            stringBuffer.append(string4 + "\"" + column.getName() + "\"");
            string4 = ",";
        }
        stringBuilder.append("-D oracle.hadoop.loader.loaderMap.columnNames='" + stringBuffer.toString() + " '" + SEP);
        LoadFile loadFile = (LoadFile)this._hProps.get(ImportKeys.LOAD_FILE);
        for (LoadField loadField : loadFile.getFields()) {
            Column column;
            column = loadField.getColumn();
            stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + column.getName() + "\"'" + P_LM_FIELD_SUFFIX + loadField.getName().toUpperCase() + SEP);
            String string5 = column.getFormat();
            String string6 = "";
            if (string5 == null || string5.isEmpty()) continue;
            string6 = JavaFormat.convertToSimplifiedDateFormat((String)string5.toLowerCase());
            if (column.getType().equals("DATE")) {
                stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + column.getName() + "\"'" + P_LM_FIELD_SUFFIX_DATE_FORMAT + "'" + string6 + "'" + SEP);
                continue;
            }
            if (column.getType().equals("TIMESTAMP")) {
                stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + column.getName() + "\"'" + P_LM_FIELD_SUFFIX_DATE_FORMAT + "'" + string6 + "'" + SEP);
                continue;
            }
            if (!column.getType().equals("TIMESTAMP")) continue;
            stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + column.getName() + "\"'" + P_LM_FIELD_SUFFIX_DATE_FORMAT + "'" + string6 + "'" + SEP);
        }
        this.doCredentials(stringBuilder);
        stringBuilder.append("-libjars ${OLH_LIB_JARS}\n");
        return stringBuilder.toString();
    }

    private String getTextScript() {
        String string = (String)this._hProps.get(HadoopKeys.SOURCE_ROOT_DIR);
        String string2 = HadoopWizArb.format("OLH_EXEC_STEP_LOAD", this._destTableName, this._destConnDisplayName, string);
        this.log("\n" + HadoopWizArb.format("OLH_EXEC_STEP_START", string2));
        String string3 = "/ade/jscapicc_hadoop01/oracle/work/olhp_scratch/oraloader-3.4.0-h2";
        StringBuilder stringBuilder = new StringBuilder("hadoop jar  ${OLH_HOME}/jlib/oraloader.jar oracle.hadoop.loader.OraLoader \\\n");
        stringBuilder.append("-D mapreduce.job.inputformat.class=oracle.hadoop.loader.lib.input.DelimitedTextInputFormat \\\n");
        stringBuilder.append("-D mapred.input.dir=" + string + SEP);
        ImportDataFormat importDataFormat = (ImportDataFormat)this._hProps.get(ImportKeys.IMPORT_DATA_FORMAT);
        String string4 = importDataFormat.getDelimiterValue();
        if (!string4.equals(V_TAB)) {
            stringBuilder.append("-D oracle.hadoop.loader.input.fieldTerminator=\"" + string4 + "\"" + SEP);
        } else {
            stringBuilder.append("-D oracle.hadoop.loader.input.fieldTerminator=\"\\u0009\" \\\n");
        }
        String string5 = importDataFormat.getEnclosureLeftValue();
        String string6 = importDataFormat.getEnclosureRightValue();
        if (string5 != null && !string5.isEmpty()) {
            if (string5.equals("\"")) {
                stringBuilder.append("-D oracle.hadoop.loader.input.initialFieldEncloser=\"\\u0022\" \\\n");
            } else {
                stringBuilder.append("-D oracle.hadoop.loader.input.initialFieldEncloser=\"" + string5 + "\"" + SEP);
            }
            if (string6.equals("\"")) {
                stringBuilder.append("-D oracle.hadoop.loader.input.trailingFieldEncloser=\"\\u0022\" \\\n");
            } else {
                stringBuilder.append("-D oracle.hadoop.loader.input.trailingFieldEncloser=\"" + string6 + "\"" + SEP);
            }
        }
        stringBuilder.append("-D mapreduce.job.outputformat.class=" + (this._hProps.getValueInteger(ImportKeys.LOAD_METHOD) == 5 ? V_OFORMAT_OCI : V_OFORMAT_JDBC) + SEP);
        stringBuilder.append("-D mapreduce.output.fileoutputformat.outputdir=" + (String)this._hProps.get(HadoopKeys.JOB_DIR) + SEP);
        stringBuilder.append("-D oracle.hadoop.loader.logBadRecords=" + (this._hProps.getValueBoolean(HadoopKeys.LOG_BAD_RECS) != false ? V_TRUE : V_FALSE) + SEP);
        stringBuilder.append("-D mapred.reduce.tasks=" + this._hProps.getValueInteger(HadoopKeys.PARALLEL).toString() + SEP);
        stringBuilder.append("-D oracle.hadoop.loader.loaderMap.targetTable=" + this._destTableName + SEP);
        GenericTable genericTable = (GenericTable)this._hProps.get(ImportKeys.TABLE);
        StringBuffer stringBuffer = new StringBuffer();
        String string7 = "";
        for (Column column : genericTable.getColumns()) {
            stringBuffer.append(string7 + "\"" + column.getName() + "\"");
            string7 = ",";
        }
        stringBuilder.append("-D oracle.hadoop.loader.loaderMap.columnNames='" + stringBuffer.toString() + " '" + SEP);
        LoadFile loadFile = (LoadFile)this._hProps.get(ImportKeys.LOAD_FILE);
        for (LoadField loadField : loadFile.getFields()) {
            Column column;
            column = loadField.getColumn();
            stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + loadField.getColumn().getName() + "\"'" + P_LM_FIELD_SUFFIX + loadField.getName().toUpperCase() + SEP);
            String string8 = column.getFormat();
            String string9 = "";
            if (string8 == null || string8.isEmpty()) continue;
            string9 = JavaFormat.convertToSimplifiedDateFormat((String)string8.toLowerCase());
            if (column.getType().equals("DATE")) {
                stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + column.getName() + "\"'" + P_LM_FIELD_SUFFIX_DATE_FORMAT + "'" + string9 + "'" + SEP);
                continue;
            }
            if (column.getType().equals("TIMESTAMP")) {
                stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + column.getName() + "\"'" + P_LM_FIELD_SUFFIX_DATE_FORMAT + "'" + string9 + "'" + SEP);
                continue;
            }
            if (!column.getType().equals("TIMESTAMP")) continue;
            stringBuilder.append("-D oracle.hadoop.loader.loaderMap.'\"" + column.getName() + "\"'" + P_LM_FIELD_SUFFIX_DATE_FORMAT + "'" + string9 + "'" + SEP);
        }
        this.doCredentials(stringBuilder);
        stringBuilder.append("-libjars ${OLH_LIB_JARS}\n");
        return stringBuilder.toString();
    }

    private void doCredentials(StringBuilder stringBuilder) {
        this._isWallet = (Boolean)this._hProps.get(HadoopKeys.IS_USE_WALLET);
        if (this._isWallet) {
            stringBuilder.append("-D oracle.hadoop.loader.connection.wallet_location=${WALLET_LOCATION} \\\n");
            stringBuilder.append("-D oracle.hadoop.loader.connection.tns_admin=${TNS_ADMIN} \\\n");
            stringBuilder.append("-D oracle.hadoop.loader.connection.tnsEntryName=" + (String)this._hProps.get(HadoopKeys.WALLET_CREDENTIAL) + SEP);
        } else {
            stringBuilder.append("-D oracle.hadoop.loader.connection.url=" + this._destConnUrl + SEP);
            stringBuilder.append("-D oracle.hadoop.loader.connection.user=" + this._destUser + SEP);
            this.setPasswordXml();
            stringBuilder.append("-conf " + this._xmlName + SEP);
        }
    }

    private void setPasswordXml() {
        String string = HadoopEncryption.getRandomUUID();
        String string2 = HadoopEncryption.encryptPassword(HadoopUtils.getOraclePass(this._hProps), string, HadoopEncryption.getOLHSalt(this._outputDir, this._outputFormat));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>" + this.getTerm());
        stringBuffer.append("  <configuration>" + this.getTerm());
        stringBuffer.append("    <property>" + this.getTerm());
        stringBuffer.append("      <name>oracle.hadoop.loader.connection.system.id</name>" + this.getTerm());
        stringBuffer.append("      <value>" + string + "</value>" + this.getTerm());
        stringBuffer.append("    </property>" + this.getTerm());
        stringBuffer.append("    <property>" + this.getTerm());
        stringBuffer.append("      <name>oracle.hadoop.loader.connection.encryptedPassword</name>" + this.getTerm());
        stringBuffer.append("      <value>" + string2 + "</value>" + this.getTerm());
        stringBuffer.append("    </property>" + this.getTerm());
        stringBuffer.append("  </configuration>" + this.getTerm());
        this._xml = stringBuffer.toString();
        this._xmlName = this._tempDir + this._tempName + "_conf.xml";
    }

    public void doWithRaptorTask() {
        IRaptorTaskRunMode iRaptorTaskRunMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
        String string = HadoopWizArb.getString("OLH_MAIN_TITLE");
        this._task = new RaptorTask<Void>(string, true, IRaptorTaskRunMode.MODAL_OPTIONAL){

            public Void doWork() {
                try {
                    if (OLHExec.this._script.isEmpty()) {
                        OLHExec.this.getScript();
                    }
                    OLHExec.this.executeAsScript(OLHExec.this._script);
                    OLHExec.this.log("*** SCRIPT ***\n" + OLHExec.this._script + "\n" + "\n" + OLHExec.this.getFormattedOutput(OLHExec.this._result));
                    String string = HadoopWizArb.format("OLH_EXEC_STEP_LOAD", OLHExec.this._destTableName, OLHExec.this._destConnDisplayName, OLHExec.this._dbo.getSchemaName() + "." + OLHExec.this._dbo.getObjectName());
                    OLHExec.this.log("\n" + HadoopWizArb.format("OLH_EXEC_STEP_END", ((OLHExec)OLHExec.this)._result.rc == 0 ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OSCH_EXEC_FAIL"), string));
                    ExitCode exitCode = ExitCode.EXIT_SUCCESS;
                    if (((OLHExec)OLHExec.this)._result.rc != 0) {
                        exitCode = ExitCode.EXIT_ERROR;
                        OLHExec.this.signalCancel();
                        OLHExec.this.setExitCodeHighest(exitCode);
                    }
                    OLHExec.this.deleteDeploy();
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                }
                this.finish();
                return null;
            }

            public boolean cancel() {
                OLHExec.this._cancel = true;
                return true;
            }

            public String getConnectionName() {
                return OLHExec.this._srcConnName;
            }

            public String getQuery() {
                return "";
            }

            private void finish() {
                String string = OLHExec.this.getFinalMessage();
                OLHExec.this.log(string);
                OLHExec.this.closeLog();
                try {
                    HadoopExec.openLogNode(OLHExec.this.getLogFile().toURI().toURL());
                }
                catch (Exception exception) {
                    Logger.warn(((Object)((Object)this)).getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                }
                if (!OLHExec.this._isExistingTable) {
                    this.getPostProcessCallback().run();
                }
                Logger.info(((Object)((Object)this)).getClass(), (String)string);
                this.showFinalMsg(string);
            }

            private ObjectActionController.ObjectActionPostProcess getPostProcessCallback() {
                ObjectAction objectAction = (ObjectAction)OLHExec.this._hProps.get(ImportKeys.OBJECTACTION);
                DBObject dBObject = (DBObject)OLHExec.this._hProps.get(ImportKeys.DBOBJECT);
                ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
                return objectActionPostProcess;
            }

            private void showFinalMsg(String string) {
                final String string2 = string == null || string.length() == 0 ? "" : string;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)DataImportArb.getString((String)"TASK_SHORT_NAME"), null);
                        }
                        catch (Exception exception) {
                            Logger.warn(this.getClass(), (String)exception.getStackTrace()[0].toString(), (Throwable)exception);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        this._task.setCancellable(true);
        this._task.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                OLHExec.this._task = null;
            }
        });
        RaptorTaskManager.getInstance().addTask(this._task);
    }

    public void cancelExport() {
    }

    private String getFinalMessage() {
        String string = HadoopWizArb.getString("OLH_SUCCESS");
        if (this._cancel) {
            string = HadoopWizArb.getString("OLH_CANCELLED");
        } else if (this.finalStatus == 1) {
            string = HadoopWizArb.getString("OLH_WARNING");
        } else if (this.finalStatus == 2) {
            string = HadoopWizArb.getString("OLH_ERROR");
        }
        return "\n" + string;
    }

    private boolean deleteDeploy() {
        boolean bl = true;
        if (this._hProps.getValueBoolean(HadoopKeys.DELETE_DEPLOY).booleanValue()) {
            String string = HadoopWizArb.getString("OLH_EXEC_STEP_DELETE_DEPLOY_PUT");
            this.log("\n" + HadoopWizArb.format("OLH_EXEC_STEP_START", string));
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            String string2 = !this._isWallet ? "rm " + this._xmlName + "\n" : "";
            string2 = string2 + "rm " + this._tempDir + this._tempName + ".deploy" + "\n";
            this.log(string2);
            ScriptOutput scriptOutput = HadoopUtils.executeCommand(this._session, string2);
            if (scriptOutput.rc != 0) {
                this.log(HadoopWizArb.format("OSCH_EXEC_REMOVE_FAILED", this.getFormattedOutput(scriptOutput)));
                exitCode = ExitCode.EXIT_WARNING;
                this.setExitCodeHighest(ExitCode.EXIT_WARNING);
                bl = true;
            }
            this.log("\n" + HadoopWizArb.format("OLH_EXEC_STEP_END", scriptOutput.rc == 0 ? HadoopWizArb.getString("OLH_EXEC_SUCCESS") : HadoopWizArb.getString("OLH_EXEC_FAIL"), string));
        }
        return bl;
    }

    private boolean executeAsScript(String string) {
        try {
            Long l;
            Object object;
            ExitCode exitCode = ExitCode.EXIT_SUCCESS;
            String string2 = (String)this._hProps.get(HadoopKeys.SSH_HOST);
            this.log("SSH HOST: " + string2);
            if (!this._isWallet) {
                try {
                    object = new ByteArrayInputStream(this._xml.getBytes("UTF-8"));
                    l = HadoopUtils.putFile(this._session, this._xmlName, (ByteArrayInputStream)object);
                    if (l < 1L) {
                        this.log(HadoopWizArb.format("OSCH_EXEC_PUT_FAILED", this._xmlName));
                        exitCode = ExitCode.EXIT_ERROR;
                        this.setExitCodeHighest(ExitCode.EXIT_ERROR);
                        return false;
                    }
                }
                catch (Exception exception) {
                    this.log(HadoopWizArb.format("OSCH_EXEC_PUT_FAILED", this._xmlName, exception.getMessage()));
                    exitCode = ExitCode.EXIT_ERROR;
                    this.setExitCodeHighest(ExitCode.EXIT_ERROR);
                    return false;
                }
            }
            object = "#!/bin/bash\nsource .sqldev_olh_env\nenv\nmkdir -p " + this._tempDir + "\n" + string;
            l = new JSchSessionLocation(this._session);
            this._result = HadoopUtils.copyAndExecuteScript((JSchSessionLocation)l, (String)object, this._tempName + ".deploy", this._tempDir + "/");
            return this._result.rc == 0;
        }
        catch (Exception exception) {
            this.log(HadoopWizArb.getString("OLH_EXEC_SCRIPT_FAIL") + " " + exception.getMessage());
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
    }

    private String getTerm() {
        return "\n";
    }
}

