/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.net.URL;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.FileElementFactory;
import oracle.dbtools.raptor.filenav.FileNavigatorWindow;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.ide.vcs.VCSEvent;
import oracle.ide.vcs.VCSListener;
import oracle.ide.vcs.VCSManager;
import oracle.ide.view.View;

public class FileNavigatorController
implements Controller {
    private Controller m_parent;
    private FileNavigatorWindow m_view;

    public static void refreshNodes(Set<URL> set, TreeExplorer treeExplorer) {
        URL uRL = null;
        TNode tNode = treeExplorer.getRoot();
        for (URL uRL2 : set) {
            if (uRL != null && URLFileSystem.isBaseURLFor(uRL, (URL)uRL2)) continue;
            uRL = null;
            TNode tNode2 = null;
            DirectoryFolder directoryFolder = FileElementFactory.getInstance().findClosestFolder(uRL2);
            if (directoryFolder != null) {
                uRL = directoryFolder.getURL();
                tNode2 = treeExplorer.searchTNodeBreadthFirst((Element)directoryFolder, tNode);
            }
            if (tNode2 == null) continue;
            FileNavigatorController.refresh(treeExplorer, tNode2);
        }
    }

    public static void refresh(TreeExplorer treeExplorer, TNode tNode) {
        Element element = tNode.getData();
        if (element instanceof DirectoryFolder) {
            ((DirectoryFolder)element).close();
        }
        treeExplorer.refresh(tNode);
    }

    FileNavigatorController(Controller controller, FileNavigatorWindow fileNavigatorWindow) {
        this.m_parent = controller;
        this.m_view = fileNavigatorWindow;
        VCSManager.getVCSManager().addVCSListener((VCSListener)new L(), (URLFilter)new Filter());
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == 51) {
            View view;
            TNode tNode = ExplorerContext.getSingleTNode((Context)context);
            if (tNode != null && (view = context.getView()) == this.m_view) {
                this.refresh(tNode);
            }
            bl = true;
        } else if (n == 20) {
            // empty if block
        }
        return bl || this.m_parent.handleEvent(ideAction, context);
    }

    private void refresh(TNode tNode) {
        TreeExplorer treeExplorer = this.m_view.getTreeExplorer();
        FileNavigatorController.refresh(treeExplorer, tNode);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n;
        View view = context.getView();
        if (view instanceof FileNavigatorWindow && (n = ideAction.getCommandId()) == 51) {
            ideAction.setEnabled(true);
            return true;
        }
        return this.m_parent.update(ideAction, context);
    }

    private static final class Filter
    implements URLFilter {
        private Filter() {
        }

        public boolean accept(URL uRL) {
            return "file".equals(uRL.getProtocol());
        }
    }

    private class L
    implements VCSListener {
        private L() {
        }

        public void notifyEvent(VCSEvent vCSEvent) {
            switch (vCSEvent.getEventType()) {
                case 1: 
                case 2: 
                case 4: {
                    TreeSet<URL> treeSet = new TreeSet<URL>(new Comparator<URL>(){

                        @Override
                        public int compare(URL uRL, URL uRL2) {
                            URLFileSystemHelper uRLFileSystemHelper = URLFileSystem.findHelper((URL)uRL);
                            assert (uRLFileSystemHelper == URLFileSystem.findHelper((URL)uRL2));
                            if (uRLFileSystemHelper.equals(uRL, uRL2)) {
                                return 0;
                            }
                            if (uRLFileSystemHelper.isBaseURLFor(uRL, uRL2)) {
                                return -1;
                            }
                            if (uRLFileSystemHelper.isBaseURLFor(uRL2, uRL)) {
                                return 1;
                            }
                            return uRLFileSystemHelper.getPath(uRL).compareTo(uRLFileSystemHelper.getPath(uRL2));
                        }
                    });
                    for (URL uRL : vCSEvent.getURLs()) {
                        if (URLFileSystem.isDirectory((URL)uRL)) {
                            treeSet.add(uRL);
                            continue;
                        }
                        URL uRL2 = URLFileSystem.getParent((URL)uRL);
                        if (uRL2 == null) continue;
                        treeSet.add(uRL2);
                    }
                    TreeExplorer treeExplorer = FileNavigatorController.this.m_view.getTreeExplorer();
                    FileNavigatorController.refreshNodes(treeSet, treeExplorer);
                    break;
                }
            }
        }
    }
}

