/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.filenav;

import java.lang.reflect.Constructor;
import java.net.URL;
import oracle.dbtools.raptor.filenav.DirectoryFolder;
import oracle.dbtools.raptor.filenav.DirectoryRoot;
import oracle.dbtools.raptor.filenav.FileNavigatorAddin;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.WeakCache;

public class FileElementFactory {
    private static final FileElementFactory INSTANCE = new FileElementFactory();
    private WeakCache<URL, DirectoryFolder> m_folders = new WeakCache();

    public static FileElementFactory getInstance() {
        return INSTANCE;
    }

    private FileElementFactory() {
    }

    public DirectoryFolder findFolder(URL uRL) {
        return (DirectoryFolder)((Object)this.m_folders.get((Object)uRL));
    }

    public DirectoryFolder findClosestFolder(URL uRL) {
        URL uRL2;
        DirectoryFolder directoryFolder = this.findFolder(uRL);
        if (directoryFolder == null && (uRL2 = URLFileSystem.getParent((URL)uRL)) != null) {
            directoryFolder = this.findClosestFolder(uRL2);
        }
        return directoryFolder;
    }

    private DirectoryFolder createFolder(URL uRL, URL uRL2, Class<? extends DirectoryFolder> clazz) {
        DirectoryFolder directoryFolder = null;
        if (clazz != null) {
            try {
                Constructor<? extends DirectoryFolder> constructor = clazz.getDeclaredConstructor(URL.class, URL.class);
                directoryFolder = constructor.newInstance(uRL, uRL2);
            }
            catch (Exception exception) {
                FileNavigatorAddin.LOGGER.severe(exception.getLocalizedMessage());
            }
        }
        if (directoryFolder == null) {
            directoryFolder = new DirectoryFolder(uRL, uRL2);
        }
        return directoryFolder;
    }

    public DirectoryFolder findOrCreateFolder(URL uRL, URL uRL2) {
        return this.findOrCreateFolder(uRL, uRL2, null);
    }

    public DirectoryFolder findOrCreateFolder(URL uRL, URL uRL2, Class<? extends DirectoryFolder> clazz) {
        DirectoryFolder directoryFolder = (DirectoryFolder)((Object)this.m_folders.get((Object)uRL));
        if (directoryFolder == null) {
            directoryFolder = this.createFolder(uRL, uRL2, clazz);
            this.m_folders.put((Object)uRL, (Object)directoryFolder);
        }
        return directoryFolder;
    }

    public DirectoryRoot findOrCreateRoot(URL uRL, String string) {
        DirectoryRoot directoryRoot = (DirectoryRoot)((Object)this.m_folders.get((Object)uRL));
        if (directoryRoot == null) {
            directoryRoot = new DirectoryRoot(uRL, string);
            this.m_folders.put((Object)uRL, (Object)directoryRoot);
        }
        return directoryRoot;
    }

    public Element createElement(URL uRL, URL uRL2) {
        Object object = null;
        if (URLFileSystem.isDirectory((URL)uRL)) {
            object = this.findOrCreateFolder(uRL, uRL2);
        } else {
            try {
                object = NodeFactory.findOrCreate((URL)uRL);
            }
            catch (Exception exception) {
                FileNavigatorAddin.LOGGER.severe(exception.getLocalizedMessage());
            }
        }
        return object;
    }

    public Element findElement(URL uRL) {
        return URLFileSystem.isDirectory((URL)uRL) ? this.findFolder(uRL) : NodeFactory.find((URL)uRL);
    }
}

