/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.options;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class UndoOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "UndoOptions";
    private static final int MINIMUM_EDITS = 1;
    private static final int MAXIMUM_EDITS = 40;
    private static final String EDIT_MERGE_COUNT = "editMergeCount";
    private static final String MERGE_TYPED_INSERT = "mergeTypedInsert";
    private static final String MERGE_TYPED_REPLACE = "mergeTypedReplace";
    private static final String MERGE_DELETE_NEXT = "mergeDeleteNext";
    private static final String MERGE_DELETE_PREVIOUS = "mergeDeletePrevious";
    private static final String ENABLE_NAVIGATION_UNDO = "enableNavigationUndo";
    private static final String NAVIGATION_MERGE_COUNT = "navigationMergeCount";

    public UndoOptions() {
        this(HashStructure.newInstance());
    }

    private UndoOptions(HashStructure hash) {
        super(hash);
    }

    public static UndoOptions getInstance(PropertyStorage prefs) {
        return new UndoOptions(UndoOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public int getEditMergeCount() {
        return this._hash.getInt(EDIT_MERGE_COUNT, 10);
    }

    public void setEditMergeCount(int editMergeCount) {
        this._hash.putInt(EDIT_MERGE_COUNT, Math.min(Math.max(editMergeCount, 1), 40));
    }

    public boolean getMergeTypedInsert() {
        return this._hash.getBoolean(MERGE_TYPED_INSERT, true);
    }

    public void setMergeTypedInsert(boolean mergeTypedInsert) {
        this._hash.putBoolean(MERGE_TYPED_INSERT, mergeTypedInsert);
    }

    public boolean getMergeTypedReplace() {
        return this._hash.getBoolean(MERGE_TYPED_REPLACE, true);
    }

    public void setMergeTypedReplace(boolean mergeTypedReplace) {
        this._hash.putBoolean(MERGE_TYPED_REPLACE, mergeTypedReplace);
    }

    public boolean getMergeDeleteNext() {
        return this._hash.getBoolean(MERGE_DELETE_NEXT, true);
    }

    public void setMergeDeleteNext(boolean mergeDeleteNext) {
        this._hash.putBoolean(MERGE_DELETE_NEXT, mergeDeleteNext);
    }

    public boolean getMergeDeletePrevious() {
        return this._hash.getBoolean(MERGE_DELETE_PREVIOUS, true);
    }

    public void setMergeDeletePrevious(boolean mergeDeletePrevious) {
        this._hash.putBoolean(MERGE_DELETE_PREVIOUS, mergeDeletePrevious);
    }

    public boolean getEnableNavigationUndo() {
        return this._hash.getBoolean(ENABLE_NAVIGATION_UNDO, false);
    }

    public void setEnableNavigationUndo(boolean enableNavigationUndo) {
        this._hash.putBoolean(ENABLE_NAVIGATION_UNDO, enableNavigationUndo);
    }

    public int getNavigationMergeCount() {
        return this._hash.getInt(NAVIGATION_MERGE_COUNT, 20);
    }

    public void setNavigationMergeCount(int navigationMergeCount) {
        this._hash.putInt(NAVIGATION_MERGE_COUNT, Math.min(Math.max(navigationMergeCount, 1), 40));
    }
}

