/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.keymap;

import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.ceditor.keymap.KeymapHelper;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public final class EditorFactory {
    public static BasicEditorPane createIdeEditorPane() {
        return EditorFactory.createIdeEditorPane(null, null);
    }

    public static BasicEditorPane createIdeEditorPane(BasicEditorPane editor) {
        return EditorFactory.createIdeEditorPane(null, editor);
    }

    public static BasicEditorPane createIdeEditorPane(KeyStrokeContext[] keystrokeContexts) {
        return EditorFactory.createIdeEditorPane(keystrokeContexts, null);
    }

    public static BasicEditorPane createIdeEditorPane(KeyStrokeContext[] keystrokeContexts, BasicEditorPane editor) {
        try {
            if (editor == null) {
                editor = new IdeEditorPane();
            }
            KeymapManager keymapManager = KeymapManager.getInstance();
            KeymapHelper ideHelper = keymapManager.createIdeKeymapHelper(keystrokeContexts);
            editor.installPlugin((EditorPlugin)ideHelper);
            return editor;
        }
        catch (RuntimeException e) {
            System.out.println("Unexpected exception: " + e.toString());
            e.printStackTrace();
            BasicEditorPane pane = new BasicEditorPane();
            return pane;
        }
    }

    public static BasicEditorPane createStandaloneEditorPane() {
        return EditorFactory.createStandaloneEditorPane(null, null);
    }

    public static BasicEditorPane createStandaloneEditorPane(BasicEditorPane editor) {
        return EditorFactory.createStandaloneEditorPane(null, editor);
    }

    public static BasicEditorPane createStandaloneEditorPane(KeyStrokeContext[] keystrokeContexts) {
        return EditorFactory.createStandaloneEditorPane(keystrokeContexts, null);
    }

    public static BasicEditorPane createStandaloneEditorPane(KeyStrokeContext[] keystrokeContexts, BasicEditorPane editor) {
        try {
            if (editor == null) {
                editor = new IdeEditorPane();
            }
            KeymapManager keymapManager = KeymapManager.getInstance();
            KeymapHelper standaloneHelper = keymapManager.createStandaloneKeymapHelper(keystrokeContexts);
            editor.installPlugin((EditorPlugin)standaloneHelper);
            return editor;
        }
        catch (RuntimeException e) {
            System.out.println("Unexpected exception: " + e.toString());
            e.printStackTrace();
            return new BasicEditorPane();
        }
    }

    public static void initialize() {
        KeymapManager.getInstance();
    }
}

