/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.insight;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.ceditor.insight.BasicInsight;
import oracle.ide.ceditor.insight.InsightBundle;
import oracle.ide.ceditor.insight.MultiProviderRef;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.popup.HtmlContentProvider;
import oracle.javatools.parser.java.v2.JavaConstants;

public class MultiProviderInsight
extends BasicInsight
implements JavaConstants {
    private List<MultiProviderRef> allProviderRefs;
    private List<MultiProviderRef> validProviderRefs;
    private int currentProviderIndex;
    private Set<Character> triggerCharacters = new HashSet<Character>();
    private Map<MultiProviderRef, InsightProvider> refToProviderMap = new HashMap<MultiProviderRef, InsightProvider>();

    protected MultiProviderInsight() {
    }

    public MultiProviderInsight(List<MultiProviderRef> providerRefs) {
        this.createProviders(providerRefs);
    }

    protected void createProviders(List<MultiProviderRef> providerRefs) {
        assert (providerRefs.size() > 0);
        this.allProviderRefs = new LinkedList<MultiProviderRef>(providerRefs);
        this.validProviderRefs = this.allProviderRefs;
        for (MultiProviderRef ref : providerRefs) {
            for (char c : ref.getTriggerCharacters()) {
                this.triggerCharacters.add(Character.valueOf(c));
            }
        }
        this.currentProviderIndex = 0;
    }

    public int getInsightType() {
        return 1;
    }

    @Override
    protected HtmlContentProvider getSelectedContentProvider() {
        HtmlContentProvider ret = super.getSelectedContentProvider();
        return ret;
    }

    public boolean isInsightTriggerChar(char typedChar) {
        for (char c : this.triggerCharacters) {
            if (typedChar != c) continue;
            return true;
        }
        return false;
    }

    public void install(BasicEditorPane editor) {
        super.install(editor);
        int type = this.getInsightType();
        String typeString = this.getTypeString(type);
        editor.putProperty(typeString, (Object)this);
    }

    public void deinstall(BasicEditorPane editor) {
        super.deinstall(editor);
        this.refToProviderMap.clear();
        this.allProviderRefs = null;
        this.validProviderRefs = null;
    }

    @Override
    protected ListInsightView getListInsightView() {
        return (ListInsightView)this.getInsightProvider().getInsightView();
    }

    protected InsightProvider getInsightProvider() {
        return this.createInsightProvider(this.validProviderRefs.get(this.currentProviderIndex));
    }

    protected InsightProvider createInsightProvider() {
        return this.getInsightProvider();
    }

    protected InsightProvider createInsightProvider(MultiProviderRef ref) {
        InsightProvider provider = this.refToProviderMap.get(ref);
        if (provider == null) {
            provider = ref.createInsightProvider(this);
            this.refToProviderMap.put(ref, provider);
        }
        return provider;
    }

    @Override
    public void showInsight(boolean wasAutoInvoked) {
        this.createValidProviderList();
        if (this.currentProviderIndex >= this.validProviderRefs.size()) {
            this.currentProviderIndex = 0;
        }
        if (this.validProviderRefs.size() > 0) {
            int startProvider = this.currentProviderIndex;
            int tryProvider = this.currentProviderIndex;
            do {
                this.currentProviderIndex = tryProvider++;
                super.showInsight(wasAutoInvoked);
                if (this.isActive() || this.wasCompletePerformed()) break;
                if (tryProvider < this.validProviderRefs.size()) continue;
                tryProvider = 0;
            } while (tryProvider != startProvider);
        }
    }

    @Override
    public void hideInsight() {
        super.hideInsight();
        this.currentProviderIndex = 0;
    }

    @Override
    protected JComponent createStatusComponent() {
        JComponent comp = super.createStatusComponent();
        this.updateStatus();
        return comp;
    }

    protected void updateStatus() {
        String status = "";
        if (this.validProviderRefs.size() > 1) {
            MultiProviderRef curRef;
            MultiProviderRef nextRef = this.currentProviderIndex == this.validProviderRefs.size() - 1 ? this.validProviderRefs.get(0) : this.validProviderRefs.get(this.currentProviderIndex + 1);
            IdeAction action = IdeAction.find((String)"completion-insight");
            KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
            KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
            KeyStrokeContext ksc = kscr.getContext("oracle/ide/ceditor/keymap/accelerators.xml");
            String acc = "Completion";
            if (ksc != null) {
                KeyStrokeMap ksm = kso.getLocalKeyMap(ksc);
                acc = KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)action.getCommandId());
            }
            if (nextRef != (curRef = this.validProviderRefs.get(this.currentProviderIndex))) {
                Object[] fields = new Object[]{curRef.getDisplayName(), acc, nextRef.getDisplayName()};
                status = MessageFormat.format(InsightBundle.get("POPUP_INSTRUCTION"), fields);
            } else {
                status = curRef.getDisplayName();
            }
        }
        this.getStatusLabel().setText(status);
    }

    protected boolean handleInsightCommand(BasicEditorPane editor) {
        if (this.validProviderRefs.size() < 1) {
            return false;
        }
        int tempCurrentProviderIndex = this.currentProviderIndex;
        super.hideInsight();
        this.currentProviderIndex = tempCurrentProviderIndex == this.validProviderRefs.size() - 1 ? 0 : tempCurrentProviderIndex + 1;
        this.updateStatus();
        this.showInsight();
        return true;
    }

    private void createValidProviderList() {
        this.validProviderRefs = new LinkedList<MultiProviderRef>();
        for (MultiProviderRef ref : this.allProviderRefs) {
            if (!ref.isSuitableForContext(this)) continue;
            this.validProviderRefs.add(ref);
        }
    }
}

