/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.CEditor;
import oracle.ide.ceditor.options.EditorOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.Selection;
import oracle.javatools.editor.TextRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public class SelectionSurroundPlugin
implements EditorPlugin {
    private final Listener listener = new Listener();
    private BasicEditorPane editor;
    private final char[][] surrounds = new char[][]{{'\'', '\''}, {'\"', '\"'}, {'[', ']'}, {'(', ')'}, {'{', '}'}};

    public void install(BasicEditorPane editor) {
        editor.addKeyListener((KeyListener)this.listener);
        this.editor = editor;
    }

    public void deinstall(BasicEditorPane editor) {
        editor.removeKeyListener((KeyListener)this.listener);
        editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected char[][] getSurrounds() {
        return this.surrounds;
    }

    private class Listener
    extends KeyAdapter {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyTyped(KeyEvent e) {
            Object surround;
            EditorOptions options = EditorOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            if (!options.getAutoSurroundSelection()) {
                return;
            }
            if (e.isAltDown() || e.isMetaDown() || e.isControlDown()) {
                return;
            }
            char keyChar = e.getKeyChar();
            char[] foundSurround = null;
            char[][] cArray = SelectionSurroundPlugin.this.getSurrounds();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                surround = cArray[i];
                if (keyChar != surround[0]) continue;
                foundSurround = surround;
                break;
            }
            if (foundSurround != null && SelectionSurroundPlugin.this.editor.hasSelection()) {
                if (!SelectionSurroundPlugin.this.editor.makeEditable()) {
                    return;
                }
                SelectionSurroundPlugin.this.editor.beginEdit(new EditDescriptor(CEditor.get("UNDO_AUTO_SURROUND_SELECTION")));
                try {
                    TextRange range = new TextRange(SelectionSurroundPlugin.this.editor.getTextBuffer(), SelectionSurroundPlugin.this.editor.getSelectionStart(), SelectionSurroundPlugin.this.editor.getSelectionEnd());
                    List sels = SelectionSurroundPlugin.this.editor.getMultiSelections();
                    ArrayList<TextRange> ranges = new ArrayList<TextRange>(sels.size() + 1);
                    ranges.add(range);
                    surround = sels.iterator();
                    while (surround.hasNext()) {
                        Selection sel = (Selection)surround.next();
                        ranges.add(new TextRange(SelectionSurroundPlugin.this.editor.getTextBuffer(), sel.getStart(), sel.getEnd()));
                    }
                    for (TextRange r : ranges) {
                        SelectionSurroundPlugin.this.editor.insertString(r.getEndOffset(), "" + foundSurround[1], null);
                        SelectionSurroundPlugin.this.editor.insertString(r.getStartOffset(), "" + foundSurround[0], null);
                    }
                    TextRange primaryRange = (TextRange)ranges.remove(0);
                    SelectionSurroundPlugin.this.editor.select(primaryRange.getStartOffset() + 1, primaryRange.getEndOffset() - 1);
                    primaryRange.dispose();
                    SelectionSurroundPlugin.this.editor.clearMultiSelections();
                    for (TextRange r : ranges) {
                        int start;
                        int end = start = r.getStartOffset() + 1;
                        if (r.getEndOffset() != r.getStartOffset()) {
                            end = r.getEndOffset() - 1;
                            end = Math.max(end, 0);
                        }
                        SelectionSurroundPlugin.this.editor.addMultiSelection(new Selection(start, end));
                        r.dispose();
                    }
                    e.consume();
                }
                catch (BadLocationException ex) {
                    Logger.getLogger("global").log(Level.SEVERE, ex.getLocalizedMessage(), ex);
                }
                finally {
                    SelectionSurroundPlugin.this.editor.endEdit();
                }
            }
        }
    }
}

