/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.DropHandlerPlugin;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.plugins.DragDropPlugin;

final class CodeEditorDragDropPlugin
extends DragDropPlugin
implements ActionListener {
    private int EXPANSION_DELAY = 500;
    private Timer _expansionTimer = new Timer(this.EXPANSION_DELAY, this);
    private int _expansionBlockID = -1;

    CodeEditorDragDropPlugin() {
    }

    protected void handleDragEvent(DropTargetDragEvent event) {
        this.maybeExpandFoldedBlock(event.getLocation());
        DropHandlerPlugin[] handlers = DropHandlerPlugin.getHandlers(this.editor);
        for (int i = 0; i < handlers.length; ++i) {
            DropHandlerPlugin handler = handlers[i];
            try {
                int acceptAction = handler.shouldAllowDrag(event);
                if (acceptAction == 0) continue;
                Point paintLocation = handler.getDropLocationToPaint(event);
                if (paintLocation != null) {
                    this.paintDropLocation(paintLocation);
                }
                event.acceptDrag(event.getDropAction());
                return;
            }
            catch (RuntimeException e) {
                ExceptionDialog.showExceptionDialog((Component)this.editor, (Throwable)e);
                return;
            }
        }
        super.handleDragEvent(event);
    }

    protected void handleDropEvent(DropTargetDropEvent event) {
        DropHandlerPlugin[] handlers = DropHandlerPlugin.getHandlers(this.editor);
        for (int i = 0; i < handlers.length; ++i) {
            DropHandlerPlugin handler = handlers[i];
            try {
                int acceptAction = handler.shouldAllowDrop(event);
                if (acceptAction == 0) continue;
                this.clearDropLocation();
                int dropAction = event.getDropAction();
                if (this.isDropActionSupported(dropAction)) {
                    event.acceptDrop(acceptAction);
                    boolean dropSuccess = handler.performDrop(event);
                    event.dropComplete(dropSuccess);
                } else {
                    event.rejectDrop();
                }
                return;
            }
            catch (RuntimeException e) {
                ExceptionDialog.showExceptionDialog((Component)this.editor, (Throwable)e);
                return;
            }
        }
        super.handleDropEvent(event);
    }

    protected void cancelDragEvent(DropTargetEvent event) {
        super.cancelDragEvent(event);
        DropHandlerPlugin[] handlers = DropHandlerPlugin.getHandlers(this.editor);
        for (int i = 0; i < handlers.length; ++i) {
            DropHandlerPlugin handler = handlers[i];
            handler.cancelDragEvent(event);
        }
    }

    private void maybeExpandFoldedBlock(Point point) {
        Object block = this.getBlockAtPoint(point);
        if (block == null) {
            this._expansionTimer.stop();
            this._expansionBlockID = -1;
            return;
        }
        int blockID = block.hashCode();
        if (this._expansionTimer.isRunning()) {
            if (blockID != this._expansionBlockID) {
                this._expansionBlockID = blockID;
                this._expansionTimer.restart();
            }
        } else {
            this._expansionBlockID = blockID;
            this._expansionTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBlockAtPoint(Point point) {
        CodeFoldingMargin codeFoldingMargin = (CodeFoldingMargin)this.editor.getProperty("code-folding-margin");
        if (codeFoldingMargin == null) {
            return null;
        }
        int offset = this.editor.viewToModel(point) - 1;
        try {
            int endOfLineX = this.editor.modelToView((int)offset).x;
            if (point.x > endOfLineX) {
                return null;
            }
        }
        catch (BadLocationException endOfLineX) {
            // empty catch block
        }
        CodeFoldingModel model = codeFoldingMargin.getModel();
        if (model == null) {
            return null;
        }
        Object block = null;
        try {
            model.readLock();
            block = codeFoldingMargin.getLargestCollapsedBlock(model, model.getRoot(), offset);
        }
        finally {
            model.readUnlock();
        }
        return block;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CodeFoldingMargin codeFoldingMargin;
        if (this.editor == null) {
            return;
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, (Component)this.editor);
        Object block = this.getBlockAtPoint(point);
        if (block != null && block.hashCode() == this._expansionBlockID && (codeFoldingMargin = (CodeFoldingMargin)this.editor.getProperty("code-folding-margin")) != null) {
            codeFoldingMargin.setExpansionState(block, true, true);
        }
    }
}

