/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ceditor.CodeDestination;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controls.ToggleAction;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.ide.hover.HoverProvider;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.ideimpl.peek.MultiCodePeek;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.UIConstants;

public final class CodeDestinationController {
    private final CodeEditor codeEditor;
    private GutterColumn column;
    private static ContextMenu contextMenu;
    private static final String HIERARCHY_NAVIGATION_COLUMN_NAME = "hierarchy-navigation-column";

    CodeDestinationController(CodeEditor codeEditor) {
        this.codeEditor = codeEditor;
        CodeEditorGutter gutter = codeEditor.getGutter();
        this.column = gutter.createGutterColumn(HIERARCHY_NAVIGATION_COLUMN_NAME, new GutterColumnL());
    }

    public void addDestination(int line, CodeDestination destination) {
        GutterMark[] gutterMarks = this.column.lookupGutterMarks(line);
        switch (gutterMarks.length) {
            case 0: {
                DestinationsPerLine destsPerLine = new DestinationsPerLine(line, destination);
                break;
            }
            case 1: {
                DestinationsPerLine destsPerLine = (DestinationsPerLine)gutterMarks[0].getUserData();
                destsPerLine.add(destination);
                break;
            }
        }
    }

    public void removeAllDestinations() {
        this.column.removeAllGutterMarks();
    }

    private static ContextMenu getGutterContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu(new MnemonicSolver());
            ContextMenuListenersHook hook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            contextMenu.addContextMenuListener((ContextMenuListener)new NavigationContextListener());
        }
        return contextMenu;
    }

    void showDestinationPopup() {
        CodeEditorGutter gutter = this.codeEditor.getGutter();
        int line = this.codeEditor.getCaretLine();
        GutterMark[] marks = this.column.lookupGutterMarks(line);
        if (marks != null && marks.length > 0) {
            DestinationsPerLine destsPerLine = (DestinationsPerLine)marks[0].getUserData();
            List dests = destsPerLine.getDestinations();
            if (dests.size() == 1) {
                ((CodeDestination)dests.get(0)).navigate();
            } else if (dests.size() > 1) {
                MouseEvent eventToUse = new MouseEvent((Component)((Object)gutter), 1, System.currentTimeMillis(), 0, 0, 0, 1, false, 1);
                gutter.showMarkDropdownMenu(CodeDestinationController.getGutterContextMenu(), eventToUse, marks[0], line);
            }
        }
    }

    void navigate(int line, CodeDestination.Direction direction) {
        GutterMark[] marks = this.column.lookupGutterMarks(line);
        if (marks != null && marks.length > 0) {
            DestinationsPerLine destsPerLine = (DestinationsPerLine)marks[0].getUserData();
            List dests = destsPerLine.getDestinations();
            for (CodeDestination dest : dests) {
                CodeDestination.Direction dir = dest.getDirection();
                if (direction != dir) continue;
                dest.navigate();
                break;
            }
        }
    }

    public static final class NavigationContextListener
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu popup) {
            GutterMark gutterMark;
            String columnName;
            Context context = popup.getContext();
            View view = context.getView();
            if (view instanceof CodeEditorGutterView && CodeEditorGutter.isMarkDroppingDown(context) && CodeDestinationController.HIERARCHY_NAVIGATION_COLUMN_NAME.equals(columnName = (gutterMark = CodeEditorGutter.getMarkForContext(context)).getGutterColumn().getColumnName())) {
                DestinationsPerLine destsPerLine = (DestinationsPerLine)gutterMark.getUserData();
                for (CodeDestination dest : destsPerLine.getDestinations()) {
                    ToggleAction gotoSourceAction = dest.createGotoSourceAction();
                    JMenuItem menuItem = popup.createMenuItem(gotoSourceAction);
                    popup.add((Component)menuItem);
                }
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class GutterColumnL
    implements GutterColumnListener<DestinationsPerLine> {
        private GutterColumnL() {
        }

        public void markMoved(GutterMark<DestinationsPerLine> gutterMark, int oldLine, int newLine) {
        }

        public void markRemoved(GutterMark<DestinationsPerLine> gutterMark, int deletedLine) {
        }

        public void markClicked(GutterMark<DestinationsPerLine> gutterMark, int clickedLine, MouseEvent event) {
            DestinationsPerLine destsPerLine = (DestinationsPerLine)gutterMark.getUserData();
            List dests = destsPerLine.getDestinations();
            if (dests.size() == 1) {
                CodeDestination dest = (CodeDestination)dests.get(0);
                dest.navigate();
            } else {
                ContextMenu contextMenu = CodeDestinationController.getGutterContextMenu();
                BasicEditorPane editor = CodeDestinationController.this.codeEditor.getFocusedEditorPane();
                CodeEditor.getCodeEditor(editor).getGutter().showMarkDropdownMenu(contextMenu, event, gutterMark, clickedLine);
            }
        }

        public String getMarkToolTip(GutterMark<DestinationsPerLine> gutterMark, MouseEvent event) {
            if (contextMenu != null && contextMenu.isShowing()) {
                return null;
            }
            DestinationsPerLine destsPerLine = (DestinationsPerLine)gutterMark.getUserData();
            List dests = destsPerLine.getDestinations();
            if (!dests.isEmpty() && ((CodeDestination)dests.get(0)).getLabel() != null) {
                return null;
            }
            StringBuilder buffer = new StringBuilder("<html>");
            boolean first = true;
            for (CodeDestination dest : destsPerLine.getDestinations()) {
                String tooltip = dest.getTooltip();
                if (!first) {
                    buffer.append("<br>");
                }
                buffer.append(tooltip);
                first = false;
            }
            return buffer.toString();
        }
    }

    private class DestinationsPerLine
    implements HoverProvider {
        private List<CodeDestination> dests = new ArrayList<CodeDestination>();
        private final GutterMark<DestinationsPerLine> gutterMark;

        private DestinationsPerLine(int line, CodeDestination dest) {
            int options = 1;
            this.gutterMark = CodeDestinationController.this.column.addGutterMark(line, dest.getIcon(), null, 3000, options);
            if (this.gutterMark != null) {
                this.gutterMark.setUserData((Object)this);
                this.dests.add(dest);
            }
        }

        private void add(CodeDestination dest) {
            this.dests.add(dest);
            boolean goesUp = false;
            boolean goesDown = false;
            for (CodeDestination d : this.dests) {
                switch (d.getDirection()) {
                    case DOWN: {
                        goesDown = true;
                        break;
                    }
                    case UP: {
                        goesUp = true;
                    }
                }
            }
            Icon icon = goesUp ? (goesDown ? OracleIcons.getIcon((String)"gutter/up_down.png") : OracleIcons.getIcon((String)"gutter/up.png")) : OracleIcons.getIcon((String)"gutter/down.png");
            this.gutterMark.setIcon(icon);
            if (this.gutterMark instanceof LineGutterPlugin.Column.Mark) {
                int options = 65537;
                LineGutterPlugin.Column.Mark mark = (LineGutterPlugin.Column.Mark)this.gutterMark;
                mark.setOptions(options);
            }
        }

        private List<CodeDestination> getDestinations() {
            return this.dests;
        }

        public Hover hover(JComponent c, Point p, List<HoverFlavor> flavors) {
            if (flavors.contains(HoverFlavor.getFlavor((String)"info"))) {
                if (this.dests.size() == 0) {
                    return null;
                }
                if (CodeDestinationController.getGutterContextMenu().isShowing()) {
                    return null;
                }
                ArrayList<MultiCodePeek.PeekItem> items = new ArrayList<MultiCodePeek.PeekItem>();
                for (CodeDestination dest : this.dests) {
                    if (dest.getLabel() == null || dest.getText() == null) continue;
                    MultiCodePeek.PeekItem item = new MultiCodePeek.PeekItem(dest.getText() == null ? "" : dest.getText(), dest.getTooltip(), null, (Object)dest, dest.getGoToUrl().getPath());
                    items.add(item);
                }
                if (items.isEmpty()) {
                    return null;
                }
                CodeEditorGutter gutter = CodeDestinationController.this.codeEditor.getGutter();
                final MultiCodePeek peek = new MultiCodePeek((JComponent)((Object)gutter), HoverFlavor.getFlavor((String)"info"), items);
                peek.getGhostPointingPalette().setLook(UIConstants.Look.DARK);
                peek.getGhostPointingPalette().setResizable(false);
                peek.setHideOnKeyPress(false);
                final ActionListener selectionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MultiCodePeek.PeekItem item = peek.getSelectedItem();
                        CodeDestination entry = (CodeDestination)item.getUserObject();
                        entry.navigate();
                    }
                };
                peek.addActionListener(selectionListener);
                peek.addHoverListener(new HoverListener(){

                    public void hoverChange(HoverEvent he) {
                        if (he.isHidden()) {
                            peek.removeActionListener(selectionListener);
                            peek.removeHoverListener((HoverListener)this);
                        }
                    }
                });
                return peek;
            }
            return null;
        }
    }
}

