/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseMetadataProvider;
import com.adbs.ast.BaseParser;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLFromQuery;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.metadata.BaseMetadataFieldsFetcher;
import com.adbs.metadata.BaseMetadataFieldsFetcherVariants;
import com.adbs.metadata.LoadMetadataHelpers;
import com.adbs.metadata.MetadataFieldsFetcherFromQuery;
import com.adbs.metadata.MetadataFieldsFetcherFromResultSet;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.DatasourceFieldRemovedEvent;
import com.adbs.querybuilder.DiagramObjectAddedEvent;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.O;
import com.adbs.syntax.OracleQueryPropertiesDialog;
import com.adbs.syntax.OracleSQLFromQueryExtender;
import com.adbs.syntax.OracleSQLFromSourceExtender;
import com.adbs.syntax.OracleSQLSelectStatementExtender;
import com.adbs.syntax.OracleSQLSubQueryExtender;
import com.adbs.syntax.OracleServerVersion;
import com.adbs.syntax.aA;
import com.adbs.syntax.x;
import com.adbs.utils.Str;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleSyntaxProvider
extends BaseSyntaxProvider {
    private OracleServerVersion k = OracleServerVersion.Oracle11;
    private static final long m = 1L;

    @Override
    public void getDefaultSchemaNames(BaseSQLContext a2, SQLIdentifiersCollection a3) throws QueryBuilderException {
        OracleSyntaxProvider a4;
        if (a4.isDetectServerVersion()) {
            a4.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getDefaultSchemaNamesOracle(a2, a3)) {
            super.getDefaultSchemaNames(a2, a3);
        }
    }

    public OracleServerVersion getServerVersion() {
        OracleSyntaxProvider a2;
        return a2.k;
    }

    @Override
    public boolean isSupportDatabases() {
        return false;
    }

    @Override
    public void getPrefixed1ParamAggregateNames(SQLQualifiedNameList a2) {
        OracleSyntaxProvider a3;
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        sQLQualifiedNameList.clear();
        sQLQualifiedNameList.addIdentifier(DatasourceFieldRemovedEvent.C("sJU"), false);
        if (a3.k.compareTo(OracleServerVersion.Oracle9) > 0) {
            a2.addIdentifier(DiagramObjectAddedEvent.C("\u007f\u0012P\u0011Y\u001eH"), false);
        }
        a2.addIdentifier(DatasourceFieldRemovedEvent.C("qSGRF"), false);
        a2.addIdentifier(DiagramObjectAddedEvent.C("q\u001cD"), false);
        a2.addIdentifier(DatasourceFieldRemovedEvent.C("\u007fU\\"), false);
        a2.addIdentifier(DiagramObjectAddedEvent.C(".H\u0019x\u0018J"), false);
        a2.addIdentifier(DatasourceFieldRemovedEvent.C("aI_"), false);
        a2.addIdentifier(DiagramObjectAddedEvent.C("+]\u000fU\u001cR\u001eY"), false);
    }

    @Override
    public boolean isSupportOracleJoins() {
        return true;
    }

    @Override
    public AstTokenIdentifier getEmptySchemaName(BaseSQLContext a2) {
        return new AstTokenIdentifier(a2, DatasourceFieldRemovedEvent.C("lg~~uq"), false);
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext a2, MetadataContainer a3, MetadataFilter a4, SQLQualifiedName a5) throws QueryBuilderException {
        OracleSyntaxProvider a6;
        if (a6.isDetectServerVersion()) {
            a6.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataRelationsOracle(a2, a3, a4, a5)) {
            super.loadMetadataRelations(a2, a3, a4, a5);
        }
    }

    @Override
    public boolean isDetectServerVersion() {
        OracleSyntaxProvider a2;
        return super.isDetectServerVersion();
    }

    @Override
    protected Class getParserClass() {
        return aA.class;
    }

    public void setServerVersion(OracleServerVersion a2) {
        OracleSyntaxProvider a3;
        if (a3.k != a2) {
            a3.k = a2;
            a3.sendNotifications();
        }
    }

    @Override
    public String getDescription() {
        return DiagramObjectAddedEvent.C("2N\u001c_\u0011Y");
    }

    @Override
    protected Class getScannerClass() {
        return O.class;
    }

    @Override
    public boolean isFromClauseMandatory() {
        return true;
    }

    @Override
    public boolean isSupportSchemas() {
        return true;
    }

    @Override
    public boolean isSupportRecursiveCTE() {
        return false;
    }

    @Override
    public void beginBuildWrapperForStoredProc(SQLBuilder a2, SQLBuilderSelectFormat a3) {
        SQLBuilder sQLBuilder = a2;
        sQLBuilder.writeKeyword(DatasourceFieldRemovedEvent.C("f]PPW"));
        sQLBuilder.writeSymbol(DiagramObjectAddedEvent.C("\u0014"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void setParserParams(BaseParser a2) {
        OracleSyntaxProvider a3;
        super.setParserParams(a2);
        switch (x.m[a3.k.ordinal()]) {
            case 1: {
                a2.serverVersion = 7;
                return;
            }
            case 2: {
                a2.serverVersion = 8;
                return;
            }
            case 3: {
                a2.serverVersion = 9;
                return;
            }
            case 4: {
                a2.serverVersion = 10;
                return;
            }
        }
        a2.serverVersion = 10;
    }

    public void getUnionOperatorList(List a2) {
        List list = a2;
        list.clear();
        list.add("Union");
        a2.add(DatasourceFieldRemovedEvent.C("gR[S\\\u001csP^"));
        a2.add(DiagramObjectAddedEvent.C("u\u0013H\u0018N\u000eY\u001eH"));
        a2.add(DatasourceFieldRemovedEvent.C("\u007fU\\IA"));
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList a2) {
        OracleSyntaxProvider a3;
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        super.getBuiltinFunctionNames(sQLQualifiedNameList);
        sQLQualifiedNameList.addBuiltin(DiagramObjectAddedEvent.C("}\u001fO"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("}qSA"));
        SQLQualifiedNameList sQLQualifiedNameList2 = a2;
        a2.addBuiltin(DiagramObjectAddedEvent.C("<o\u0014R"));
        sQLQualifiedNameList2.addBuiltin(DatasourceFieldRemovedEvent.C("}f]\\"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("})]\u0013\u000e"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("~[HsRV"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(">Y\u0014P"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("qSA"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(">S\u000et"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("wDB"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("z\u0011S\u0012N"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("p\\"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("p\u0012["));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("\u007fSV"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("r\u001cR+P"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("bSEY@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("n\u0018Q\u001cU\u0013X\u0018N"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("`SGRV"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(".U\u001aR"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("aU\\"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(".U\u0013t"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("oCnF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u001cR"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("hSRz"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u000fI\u0013_"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("k[XFTm~G_YYF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("\u007f\u0015N"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("\u007f]RQ]F"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("u\u0013U\t\u007f\u001cL"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("~SEY@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("1l\u001cX"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("~h@U_"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("r1o\"u\u0013S\t\u007f\u001cL"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("|pac~SEY@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("r1o.S\u000fH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("|pacgLBY@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("/Y\u001ay\u0005L\"n\u0018L\u0011]\u001eY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("`YUyJLmoG^aH@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("n\u0018L\u0011]\u001eY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("nb]V"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("n)N\u0014Q"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("aSGRVyJ"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(".I\u001fo\tN"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("fNSRAPSHW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u000fY\u001cH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("h@U_"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("i\rL\u0018N"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("`YUyJLmp[WW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("3p.c>T\u001cN\u000eY\tc9Y\u001eP\"p\u0018R"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("r~om\u007fZ]@OWHmuV"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("3p.c>T\u001cN\u000eY\tc3]\u0010Y"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("soqu{"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("u\u0013O\tN"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("pWRUHZ"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("/Y\u001ay\u0005L\"u\u0013O\tN"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("]VXmq]RFTA"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("\u007f\bN\u000fY\u0013H\"h\u0014Q\u0018O\t]\u0010L"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("xPh[QWf]RW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("y\u0005H\u000f]\u001eH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("tN]Qmhh"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("1]\u000eH\"x\u001cE"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("p]_SPfU_YAHSQB"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("0S\u0013H\u0015O\"~\u0018H\nY\u0018R"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("rWKmh[QW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("3Y\u0005H\"x\u001cE"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("|I_h]xau\\HWND]^"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("r\bQ)S$q4R\tY\u000fJ\u001cP"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("`SGRV"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("o\u0018O\u000eU\u0012R)U\u0010Y'S\u0013Y"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("aEAcwDFNS_Fcghq"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("o\u0004O9]\tY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("oKOfU_YAHSQB"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c>T\u001cN"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("h]cfU_YAHSQB"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c)U\u0010Y\u000eH\u001cQ\rc)f"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("fSmxau\\HWND]^"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c$q4R\tY\u000fJ\u001cP"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("fNGRQ"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h'c2Z\u001bO\u0018H"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("{@YSHWOF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("p\u0018]\u000eH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("}a\u007f{uaH@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("?U\u0013c)S\"r\bQ"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("\u007fSOF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("\u007f\u0015]\u000fh\u0012n\u0012K4X"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("qS_L]OW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("\u007f\u0012R\u000bY\u000fH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("vYQS_L]OW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("5Y\u0005h\u0012n\u001cK"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("|I_h]xau\\HWND]^"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("r\bQ)S$q4R\tY\u000fJ\u001cP"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("nSKfSzYJ"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("n\u001cK)S3t\u0018D"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("`SEuVh]\u007fZ]@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("/S\nu\u0019h\u0012r>T\u001cN"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("oqrmh]cfU_YAHSQB"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(")U\u0010Y\u000eH\u001cQ\rc)S\"o>r"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("h]cpU\\]@Emx]IPPW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c?U\u0013]\u000fE\"z\u0011S\u001cH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("fSm\u007fZ]@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c>p2~"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("fSmxSHW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c9o4R\tY\u000fJ\u001cP"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("h]c~sp"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c0I\u0011H\u0014c?E\tY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("h]c|\u007fZ]@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(")S\"r>p2~"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("fSmrGQPY@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c9o4R\tY\u000fJ\u001cP"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("h]caU\\[^Ym~KHW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(")S\"h\u0014Q\u0018O\t]\u0010L"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("fSmh[QWOF]_Lmhh"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("h\u0012c$q4R\tY\u000fJ\u001cP"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("i\\UaH@"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("~;U\u0011Y3]\u0010Y"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("y_LFEm~~sp"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("8Q\rH\u0004c>p2~"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("q]@X[RSP[HK"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("\u007f\u0012P\u0011Y\u001eH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("bSEY@qGPFUaYF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("-S\nY\u000fq\bP\tU.Y\tc?E\"\u007f\u001cN\u0019U\u0013]\u0011U\tE"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("ayf"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("o\u0004O\"\u007f\u0012R\u0013Y\u001eH\"~\u0004c-]\tT"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("\u007f^IAHWNmuV"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("\u007f\u0011I\u000eH\u0018N\"l\u000fS\u001f]\u001fU\u0011U\tE"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("qPGOFY@caYF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(";Y\u001cH\bN\u0018c4X"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("tYSHGNWcaYF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("z\u0018]\tI\u000fY\"j\u001cP\bY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("l@YVUQH[S\\"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("l\u000fY\u0019U\u001eH\u0014S\u0013c?S\bR\u0019O"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("bNWX[_FU]Rm\u007f]OF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("-N\u0018X\u0014_\tU\u0012R\"x\u0018H\u001cU\u0011O"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("l@YVUQH[S\\cbN]^S^[P[HK"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("-N\u0018X\u0014_\tU\u0012R\"o\u0018H"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("}BLWRV\u007fZU^Xjq~"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("x\u0018P\u0018H\u0018d0p"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("vYBHZ"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("y\u0005H\u000f]\u001eH"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("yJUAHAr]XW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("8D\tN\u001c_\tj\u001cP\bY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("u\\OWNF\u007fZU^Xjq~"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("u\u0013O\u0018N\td0p?Y\u001bS\u000fY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("lSHZ"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(".E\u000ec9^(n4{\u0018R"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("oKOmd\u007fps[U"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(".E\u000ec%q1{\u0018R"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("gLV]FYjq~"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("%q1}\u001a["));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("jq~\u007fSOF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("%q1\u007f9]\t]"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("d\u007fpqS^}FHd]^"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("%q1\u007f\u0012Q\u0010Y\u0013H"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("jq~\u007f]RQ]F"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("d0p9U\u001bZ"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("d\u007fpwPWQWRF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("d0p8D\u0014O\tO"));
        sQLQualifiedNameList2.addBuiltin(DatasourceFieldRemovedEvent.C("jq~z]NWOF"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("%q1l\u001cN\u000eY"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("d\u007fpb]F_Z"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("d0p-U"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("d\u007fpcIWNK"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("d0p/S\u0012H"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("jq~oWMGY\\_W"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("%q1o\u0018N\u0014]\u0011U\u0007Y"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("d\u007fpf]PPW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("%q1h\u000f]\u0013O\u001bS\u000fQ"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("xW_]XW"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("9I\u0010L"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("s@]mtSOZ"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("j.U\u0007Y"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("\u007f]]^YA_W"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("p\u0013r+p"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("rGP^uT"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("r+p"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("rdp\u0000"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("o\u0004O\"\u007f\u0012R\tY\u0005H"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("oKOm{guv"));
        a2.addBuiltin(DiagramObjectAddedEvent.C(".E\u000ec)E\rY4X"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("guV"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("(O\u0018N"));
        a2.addBuiltin(DatasourceFieldRemovedEvent.C("gOWNwRD"));
        a2.addBuiltin(DiagramObjectAddedEvent.C("j\u001cP\bY"));
    }

    @Override
    public Class getEditPropsFormClass(Object a2) {
        OracleSyntaxProvider a3;
        if (a2 instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (a2 instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        if (a2 instanceof UnionSubQuery) {
            return OracleQueryPropertiesDialog.class;
        }
        return super.getEditPropsFormClass(a2);
    }

    @Override
    public void get1ParamAggregateNames(SQLQualifiedNameList a2) {
        OracleSyntaxProvider a3;
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        sQLQualifiedNameList.clear();
        sQLQualifiedNameList.addIdentifier("Grouping", false);
        if (a3.k.compareTo(OracleServerVersion.Oracle8) > 0) {
            a2.addIdentifier(DatasourceFieldRemovedEvent.C("uN]IBU\\[muV"), false);
            a2.addIdentifier(DiagramObjectAddedEvent.C("0Y\u0019U\u001cR"), false);
        }
        if (a3.k.compareTo(OracleServerVersion.Oracle9) > 0) {
            a2.addIdentifier(DatasourceFieldRemovedEvent.C("oF]FOmq]XW"), false);
        }
        a2.addIdentifier(DiagramObjectAddedEvent.C(".H\u0019x\u0018J\"l\u0012L"), false);
        a2.addIdentifier(DatasourceFieldRemovedEvent.C("aHVxWJmoSQB"), false);
        if (a3.k.compareTo(OracleServerVersion.Oracle10) > 0) {
            a2.addIdentifier(DiagramObjectAddedEvent.C(".E\u000ec%Q\u0011}\u001a["), false);
        }
        a2.addIdentifier(DatasourceFieldRemovedEvent.C("d]@cbSB"), false);
        a2.addIdentifier(DiagramObjectAddedEvent.C("+]\u000fc.]\u0010L"), false);
        if (a3.k.compareTo(OracleServerVersion.Oracle10) > 0) {
            a2.addIdentifier(DatasourceFieldRemovedEvent.C("d_Ps[U"), false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doDetectServerVersion(BaseMetadataProvider a2) {
        OracleSyntaxProvider a3;
        BaseMetadataProvider baseMetadataProvider = a2;
        super.doDetectServerVersion(baseMetadataProvider);
        switch (LoadMetadataHelpers.calcServerVersionOracle(baseMetadataProvider)) {
            case 7: {
                a3.setServerVersion(OracleServerVersion.Oracle7);
                return;
            }
            case 8: {
                a3.setServerVersion(OracleServerVersion.Oracle8);
                return;
            }
            case 9: {
                a3.setServerVersion(OracleServerVersion.Oracle9);
                return;
            }
            case 10: {
                a3.setServerVersion(OracleServerVersion.Oracle10);
                return;
            }
            case 11: {
                a3.setServerVersion(OracleServerVersion.Oracle11);
                return;
            }
        }
        a3.setServerVersion(OracleServerVersion.Oracle11);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleSyntaxProvider() {
        OracleSyntaxProvider a2;
        try {
            OracleSyntaxProvider oracleSyntaxProvider = a2;
            a2.registerExtender(SQLFromQuery.class, OracleSQLFromQueryExtender.class);
            oracleSyntaxProvider.registerExtender(SQLFromSource.class, OracleSQLFromSourceExtender.class);
            oracleSyntaxProvider.registerExtender(SQLSubQuerySelectExpression.class, OracleSQLSubQueryExtender.class);
            a2.registerExtender(SQLSelectStatement.class, OracleSQLSelectStatementExtender.class);
            return;
        }
        catch (Exception exception) {
            Logger.getLogger(OracleSyntaxProvider.class.getName()).log(Level.SEVERE, null, exception);
            return;
        }
    }

    @Override
    public void setDetectServerVersion(boolean a2) {
        OracleSyntaxProvider a3;
        super.setDetectServerVersion(a2);
    }

    @Override
    public BaseSyntaxProvider clone() {
        OracleSyntaxProvider a2;
        ((OracleSyntaxProvider)super.clone()).k = a2.k;
        return (OracleSyntaxProvider)super.clone();
    }

    @Override
    public void loadFieldsForObjectFromServer(BaseSQLContext a2, MetadataObject a3) throws QueryBuilderException {
        OracleSyntaxProvider a4;
        assert (a2 != null);
        assert (((BaseSQLContext)a2).getMetadataProvider() != null);
        assert (((BaseSQLContext)a2).getMetadataProvider().canExecSQL());
        assert (a3 != null);
        if (a4.isDetectServerVersion()) {
            a4.doDetectServerVersion(((BaseSQLContext)a2).getMetadataProvider());
        }
        MetadataObject metadataObject = a3;
        String string = metadataObject.getName().getSimpleSQL(((BaseSQLContext)a2).getSQLBuilderExpressionForServerWithoutQuotes());
        String string2 = metadataObject.getSchema().getSimpleSQL(((BaseSQLContext)a2).getSQLBuilderExpressionForServerWithoutQuotes());
        if (((BaseSQLContext)a2).isTableExists(DiagramObjectAddedEvent.C("}1p\"h<~\"\u007f2p(q3o")) && ((BaseSQLContext)a2).isTableExists(DatasourceFieldRemovedEvent.C("sp~c{rvcqs~i\u007fra")) && ((BaseSQLContext)a2).isTableExists(DiagramObjectAddedEvent.C("}1p\"\u007f2r.h/}4r)o"))) {
            Disposable disposable = a2 = new MetadataFieldsFetcherFromQuery((BaseSQLContext)a2);
            Disposable disposable2 = a2;
            Disposable disposable3 = a2;
            Disposable disposable4 = a2;
            Disposable disposable5 = a2;
            Disposable disposable6 = a2;
            ((MetadataFieldsFetcherFromQuery)a2).setQuery(DatasourceFieldRemovedEvent.C("ay~yqh\u0012\u007f\u001c\u007f}pgq|c|}\u007fy\u001e\u001cq\u0012v}f}mhklw\u0010\u0012\u007f\u001c\u007fz}`c~y|{ft\u001e\u001cq\u0012v}f}ml`yquau}r\u001e\u001cq\u0012v}f}moq}~y\u001e\u001cq\u0012|i~ps~~y\u001e\u001cq\u0012v}f}mxwzsi~h\u001e\u001caip\u0012qs~i\u007frml}o{h{s|\u001cbw\u001e\u001cqs\u007f\u0012qs\u007fqwrfo\u0012\u007f}q\u007fy|ha\u001ctn}q\u0012}~pmhs~m\u007f}pgq|o\u0012\u007f\u001e\u001c\u001aowpw\u007ff\u001cqs~i\u007frmrsqw\u0010qs~i\u007frml}o{h{s|\u001ctn}q\u0012}~pmu|xm\u007f}pgq|o\u0012kzy`y\u0012\u0014{rvyjc}k|y`\u0010{rvyjc|}\u007fy\u001b\u001c\u000f\u001c\u001aowpw\u007ff\u001c}k|y`\u0010{rvyjc|}\u007fy\u0012z`s\u007f\u001csp~cqs|ofnsu|ha\u001cetwnw\u001c}k|y`\u001c\u000f\u001c\u0015") + string2 + DiagramObjectAddedEvent.C("Z\u001c<r9\u001c") + DatasourceFieldRemovedEvent.C("hs~~ymrsqw\u001c\u000f\u001c\u0015") + string + DiagramObjectAddedEvent.C("Z\u001c") + DatasourceFieldRemovedEvent.C("srv\u001cqs|ofnsu|hmhklw\u001c\u000f\u001c\u0015l\u0015\u0015\u001b\u001caip\u0010\u0012") + DiagramObjectAddedEvent.C("\u0014]o8p8\u007f)\u001c>s1i0r\"r<q8\u0010]\u007f2q0y3h.\u001c;n2q]}1p\"\u007f2p\"\u007f2q0y3h.\u001c") + DatasourceFieldRemovedEvent.C("etwnw\u001c}k|y`\u0001\u0015") + string2 + DiagramObjectAddedEvent.C("Z\u001c<r9\u001c") + DatasourceFieldRemovedEvent.C("hs~~ymrsqw\u0001\u0015") + string + DiagramObjectAddedEvent.C("\u001bT\u001c>s0\u001c") + DatasourceFieldRemovedEvent.C("etwnw\u001cq\u0012qs~i\u007frmrsqw\u001c\u000f\u001caip\u0012qs~i\u007frmrsqw\u0014\u0019\u0015\u0012") + DiagramObjectAddedEvent.C("}3x]\u007fS\u007f2p(q3c3}0y]\u0001]\u007f2qS\u007f2p(q3c3}0yU\u0017T\u001c") + DatasourceFieldRemovedEvent.C("srv\u001cq\u0012}k|y`\u001c\u000f\u001c\u0015") + string2 + DiagramObjectAddedEvent.C("Z\u001c") + DatasourceFieldRemovedEvent.C("}|x\u0012\u007f\u001chs~~ymrsqw\u001c\u000f\u001c\u0015") + string + DiagramObjectAddedEvent.C("Z\u001c") + DatasourceFieldRemovedEvent.C("s`xwn\u0012~k\u001caip\u0012qs~i\u007frml}o{h{s|\u0010qs~i\u007frmuv"));
            ((MetadataFieldsFetcherFromResultSet)disposable6).setNameFieldName(DiagramObjectAddedEvent.C("\u007f2p(q3c3}0y"));
            ((MetadataFieldsFetcherFromResultSet)disposable6).setServerTypeFieldName(DatasourceFieldRemovedEvent.C("v}f}mhklw"));
            ((MetadataFieldsFetcherFromResultSet)disposable5).setSizeFieldName(DiagramObjectAddedEvent.C("\u007f5}/c1y3{)t"));
            ((MetadataFieldsFetcherFromResultSet)disposable5).setPrecisionFieldName(DatasourceFieldRemovedEvent.C("xshscbnw\u007f{o{s|"));
            ((MetadataFieldsFetcherFromResultSet)disposable4).setScaleFieldName(DiagramObjectAddedEvent.C("9})}\"o>}1y"));
            ((MetadataFieldsFetcherFromResultSet)disposable4).setDefaultValueFieldName(DatasourceFieldRemovedEvent.C("xshscvyt}gpf"));
            ((MetadataFieldsFetcherFromResultSet)disposable3).setNullableFieldName(DiagramObjectAddedEvent.C("3i1p<~1y"));
            ((BaseMetadataFieldsFetcherVariants)disposable3).setNullableValue(DatasourceFieldRemovedEvent.C("k"));
            ((MetadataFieldsFetcherFromResultSet)disposable2).setPrimaryFieldName(DiagramObjectAddedEvent.C("-w"));
            ((BaseMetadataFieldsFetcherVariants)disposable2).setNonPrimaryValue(null);
            ((MetadataFieldsFetcherFromResultSet)disposable).setLongDescriptionFieldName(DatasourceFieldRemovedEvent.C("\u007f}q\u007fy|ha"));
            ((BaseMetadataFieldsFetcher)disposable).loadFields(a3.getFields());
        }
    }

    @Override
    public boolean isSupportCrossJoin() {
        OracleSyntaxProvider a2;
        return a2.k.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public String getQueryToLoadFieldsForObject(String a2, String a3) {
        String string = Str.IsNullOrEmpty(a2) ? DiagramObjectAddedEvent.C("\u0016") : a2;
        return new StringBuilder().insert(0, DatasourceFieldRemovedEvent.C("AY^YQH\u0012")).append(string).append(DiagramObjectAddedEvent.C("]Z\u000fS\u0010\u001c")).append(a3).append(DatasourceFieldRemovedEvent.C("\u001cS\u001cETWNW\u001c@SERGQ\u000e\f\u0012]\\X\u0012\f\u000e\u0002\u0002")).toString();
    }

    @Override
    public void getStarAggregateNames(SQLQualifiedNameList a2) {
        SQLQualifiedNameList sQLQualifiedNameList = a2;
        sQLQualifiedNameList.clear();
        sQLQualifiedNameList.addIdentifier(DiagramObjectAddedEvent.C("\u007f\u0012I\u0013H"), false);
    }

    @Override
    public boolean isSupportNullOrdering() {
        return true;
    }

    @Override
    public boolean isFixedSizeType(String a2) {
        return a2.compareToIgnoreCase(DatasourceFieldRemovedEvent.C("_Z]@")) != 0 && a2.compareToIgnoreCase(DiagramObjectAddedEvent.C("R\u001eT\u001cN")) != 0 && a2.compareToIgnoreCase(DatasourceFieldRemovedEvent.C("D]@_Z]@")) != 0 && a2.compareToIgnoreCase(DiagramObjectAddedEvent.C("\u0013J\u001cN\u001eT\u001cN")) != 0 && a2.compareToIgnoreCase(DatasourceFieldRemovedEvent.C("JSNQTSN\u0000")) != 0 && a2.compareToIgnoreCase(DiagramObjectAddedEvent.C("R\u000b]\u000f_\u0015]\u000f\u000e")) != 0 && a2.compareToIgnoreCase(DatasourceFieldRemovedEvent.C("@]E")) != 0;
    }

    @Override
    public String getSimpleEmptyFromSubquery() {
        return DiagramObjectAddedEvent.C("\u0014.y1y>h]r(p1\u001c;n2q]x(}1\u0015");
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext a2, MetadataContainer a3, MetadataFilter a4, SQLQualifiedName a5) throws QueryBuilderException {
        OracleSyntaxProvider a6;
        if (a6.isDetectServerVersion()) {
            a6.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.loadMetadataObjectsOracle(a2, a3, a4, a5)) {
            super.loadMetadataObjects(a2, a3, a4, a5);
        }
    }

    @Override
    public void endBuildWrapperForStoredProc(SQLBuilder a2, SQLBuilderSelectFormat a3) {
        a2.writeSymbol(DatasourceFieldRemovedEvent.C("\u001b"));
    }

    public void getComparisonOperators(List a2) {
        List list = a2;
        list.clear();
        list.add(DiagramObjectAddedEvent.C("\u0001"));
        a2.add(DatasourceFieldRemovedEvent.C("\u000e"));
        a2.add(DiagramObjectAddedEvent.C("A\u0001"));
        a2.add(DatasourceFieldRemovedEvent.C("\f"));
        a2.add(DiagramObjectAddedEvent.C("C\u0001"));
        a2.add(DatasourceFieldRemovedEvent.C("\u0000\f"));
        a2.add(DiagramObjectAddedEvent.C("\\\u0001"));
        a2.add(DatasourceFieldRemovedEvent.C("\u001d\f"));
        a2.add(DiagramObjectAddedEvent.C("\\\u0000"));
    }

    @Override
    public boolean isSupportSynonyms() {
        return true;
    }

    @Override
    public void getSchemaList(BaseSQLContext a2, SQLIdentifiersCollection a3, SQLQualifiedName a4) {
        OracleSyntaxProvider a5;
        if (a5.isDetectServerVersion()) {
            a5.doDetectServerVersion(a2.getMetadataProvider());
        }
        if (!LoadMetadataHelpers.getSchemaListOracle(a2, a3, a4)) {
            super.getSchemaList(a2, a3, a4);
        }
    }

    @Override
    public boolean isSupportANSIJoins() {
        OracleSyntaxProvider a2;
        return a2.k.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public boolean isSupportCTE() {
        OracleSyntaxProvider a2;
        return a2.k.compareTo(OracleServerVersion.Oracle9) >= 0;
    }

    @Override
    public SyntaxSupportsConectedServer isSupportConectedServer(BaseMetadataProvider a2) {
        assert (a2 != null);
        SyntaxSupportsConectedServer syntaxSupportsConectedServer = LoadMetadataHelpers.isConnectedServerIsOracle(a2);
        if (syntaxSupportsConectedServer == SyntaxSupportsConectedServer.Unknown) {
            OracleSyntaxProvider a3;
            return super.isSupportConectedServer(a2);
        }
        return syntaxSupportsConectedServer;
    }
}

