/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.thumbnail;

import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.layout.ViewId;
import oracle.ide.thumbnail.ThumbnailDockable;

public final class ThumbnailDockableFactory
implements DockableFactory {
    public static final String FAMILY = "UnifiedThumbnailDockable";
    private ThumbnailDockable _dockable;

    public void install() {
        DockStation dockStation = DockStation.getDockStation();
        dockStation.dock(this.getDockable(null), this.getDockingParam());
    }

    protected DockingParam getDockingParam() {
        Dockable other;
        ViewId viewId;
        DockStation ds = DockStation.getDockStation();
        DockingParam param = new DockingParam();
        param.setFloating(false);
        ExplorerManager mgr = ExplorerManager.getExplorerManager();
        if (mgr != null && (viewId = mgr.getDefaultViewId()) != null && (other = ds.findDockable(viewId)) != null) {
            param.setTabbedWith(other);
            return param;
        }
        param.setPosition(0);
        return param;
    }

    public Dockable getDockable(ViewId viewId) {
        if (this._dockable == null) {
            this._dockable = new ThumbnailDockable();
        }
        return this._dockable;
    }
}

