/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.report.ui.ChildNode;
import oracle.dbtools.raptor.report.ui.EditMode;
import oracle.dbtools.raptor.report.ui.ReportTreePanel;
import oracle.dbtools.raptor.report.ui.SQLNode;

public class ReportTreeContext {
    private ReportTreePanel treePanel;
    private SQLNode sqlNode;
    private String style;
    private String name;
    private EditMode mode;
    private boolean sqlVariantsEnabled;
    private DisplayModel model;
    private PropertyChangeSupport propertyChangeSupport;
    private ChildNode owningChildNode;
    public static final String NAME = "NAME";
    public static final String STYLE = "STYLE";
    public static final String MODE = "MODE";
    public static final String SQLVARIANTSENABLED = "SQLVARIANTSENABLED";

    public ReportTreeContext(ReportTreePanel reportTreePanel, String string, EditMode editMode, DisplayModel displayModel) {
        this.treePanel = reportTreePanel;
        this.name = string;
        this.mode = editMode;
        this.model = displayModel;
        if (displayModel != null) {
            this.style = displayModel.getStyle();
        }
        if (this.style == null || this.style.equals("")) {
            this.style = "Table";
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public ReportTreePanel treePanel() {
        return this.treePanel;
    }

    public void setSQLNode(SQLNode sQLNode) {
        this.sqlNode = sQLNode;
    }

    public SQLNode sqlNode() {
        return this.sqlNode;
    }

    public void setName(String string) {
        if (!this.stringEquals(this.name, string)) {
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(NAME, null, this.name);
        }
    }

    public String name() {
        return this.name;
    }

    public void setMode(EditMode editMode) {
        if (this.mode != editMode) {
            this.mode = editMode;
            this.propertyChangeSupport.firePropertyChange(MODE, null, (Object)this.mode);
        }
    }

    public EditMode mode() {
        return this.mode;
    }

    public void setSQLVariantsEnabled(boolean bl) {
        if (this.sqlVariantsEnabled != bl) {
            this.sqlVariantsEnabled = bl;
            this.propertyChangeSupport.firePropertyChange(SQLVARIANTSENABLED, null, (Object)this.mode);
        }
    }

    public boolean sqlVariantsEnabled() {
        return this.sqlVariantsEnabled;
    }

    public DisplayModel model() {
        return this.model;
    }

    public void setStyle(String string) {
        if (!this.stringEquals(this.style, string)) {
            this.style = string;
            this.propertyChangeSupport.firePropertyChange(STYLE, null, this.style);
        }
    }

    public String style() {
        return this.style;
    }

    public void setOwningChildNode(ChildNode childNode) {
        this.owningChildNode = childNode;
    }

    public ChildNode owningChildNode() {
        return this.owningChildNode;
    }

    public boolean isChild() {
        return this.owningChildNode != null;
    }

    private boolean stringEquals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }
}

