/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.Toolbar;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;

public class ReportSQLEditor
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private ReportTreeContext _reportContext;
    private BasicEditorPane _sql;
    private JButton _btnOpenFile;
    private JButton _btnClearAll;
    private Toolbar _toolbar;
    private static URL _lastUrl;

    public ReportSQLEditor(ReportTreeContext reportTreeContext, String string) {
        super(new GridBagLayout());
        this._reportContext = reportTreeContext;
        this.init(string);
    }

    private void init(String string) {
        JPanel jPanel = this.createToolbarPanel();
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane jScrollPane = this.createSQLEditorPanel(string);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 4, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel createToolbarPanel() {
        this._btnOpenFile = new JButton();
        this._btnOpenFile.addActionListener(this);
        this._btnOpenFile.setIcon(OracleIcons.getIcon((String)"open.png"));
        this._btnOpenFile.setToolTipText(ReportArb.getString("OPEN_FILE"));
        this._btnClearAll = new JButton();
        this._btnClearAll.addActionListener(this);
        this._btnClearAll.setIcon(OracleIcons.getIcon((String)"clear.png"));
        this._btnClearAll.setToolTipText(ReportArb.getString("CLEAR_ALL"));
        this._toolbar = new Toolbar();
        this._toolbar.setFloatable(false);
        this._toolbar.add((Component)this._btnOpenFile);
        this._toolbar.addSeparator();
        this._toolbar.add((Component)this._btnClearAll);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this._toolbar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private JScrollPane createSQLEditorPanel(String string) {
        this._sql = EditorFactory.createIdeEditorPane();
        this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sql.setEditable(true);
        this.refreshSQL(string);
        JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
        jScrollPane.setPreferredSize(this._sql.getPreferredSize());
        jScrollPane.setSize(jScrollPane.getPreferredSize());
        return jScrollPane;
    }

    public void refreshSQL(String string) {
        String string2 = string == null || string.isEmpty() ? "" : string;
        this._sql.setText(string2);
    }

    public String getSql() {
        String string = this._sql.getText().trim();
        if ((string.toLowerCase().indexOf("select") == 0 || string.toLowerCase().indexOf("with") == 0) && string.indexOf(";") == string.length() - 1) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._btnOpenFile) {
            this.getFileName(this._sql);
        } else if (actionEvent.getSource() == this._btnClearAll) {
            this._sql.setText("");
        }
    }

    private void getFileName(BasicEditorPane basicEditorPane) {
        Object object;
        Object object2;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.setDefaultTitle(ReportArb.getString("CHOOSE_FILE"));
        uRLFileChooser.clearChooseableURLFilters();
        DefaultURLFilter defaultURLFilter = new DefaultURLFilter(ReportArb.getString("FILE_FILTER_ALL"), "");
        uRLFileChooser.setURLFilter((URLFilter)defaultURLFilter);
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("FILE_FILTER_TEXT_NAME"), ReportArb.getString("FILE_FILTER_TEXT_EXT")));
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(ReportArb.getString("FILE_FILTER_SQL_NAME"), ReportArb.getString("FILE_FILTER_SQL_EXT")));
        if (_lastUrl == null) {
            try {
                object2 = System.getProperty("user.home");
                object = new File((String)object2);
                uRLFileChooser.setSelectedURL(((File)object).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            uRLFileChooser.setSelectedURL(_lastUrl);
        }
        if (uRLFileChooser.showOpenDialog((Component)this) == 0 && ((File)(object2 = new File((_lastUrl = uRLFileChooser.getSelectedURL()).getFile()))).isFile()) {
            try {
                object = new FileInputStream((File)object2);
                int n = ((FileInputStream)object).available();
                byte[] byArray = new byte[n];
                ((FileInputStream)object).read(byArray);
                String string = new String(byArray);
                basicEditorPane.setText(string);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }
}

