/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.report.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import oracle.dbtools.raptor.controls.display.DisplayConstants;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.report.ui.EditMode;
import oracle.dbtools.raptor.report.ui.ReportArb;
import oracle.dbtools.raptor.report.ui.ReportSQLEditor;
import oracle.dbtools.raptor.report.ui.ReportTreeContext;
import oracle.ide.util.ResourceUtils;

public class ReportNamePanel
extends JPanel {
    public static final String NAME = "NAME";
    public static final String STYLE = "STYLE";
    private static final long serialVersionUID = 1L;
    private JTextField _tip;
    private JTextArea _desc;
    private JTextField _name;
    private JComboBox _style;
    private ReportSQLEditor sqlEditor;
    private JPanel sqlEditorPanel;
    private Component glue;

    public ReportNamePanel(ReportTreeContext reportTreeContext, PropertyChangeListener propertyChangeListener) {
        this.init(reportTreeContext, propertyChangeListener);
    }

    private void init(final ReportTreeContext reportTreeContext, final PropertyChangeListener propertyChangeListener) {
        Object object2;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 300));
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._name, (String)ReportArb.getString(NAME));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._desc, (String)ReportArb.getString("DESCRIPTION"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._tip, (String)ReportArb.getString("TOOLTIP"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._style, (String)ReportArb.getString(STYLE));
        this._name = new JTextField();
        this._name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        propertyChangeListener.propertyChange(new PropertyChangeEvent(ReportNamePanel.this._name, ReportNamePanel.NAME, null, ReportNamePanel.this._name.getText()));
                    }
                });
            }
        });
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(10, 6, 0, 6), 0, 0));
        this.add((Component)this._name, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 23, 2, new Insets(10, 0, 0, 8), 0, 0));
        this._style = new JComboBox();
        ArrayList arrayList = DisplayRegistry.getNLSStyles();
        for (Object object2 : arrayList) {
            this._style.addItem(object2);
        }
        this._style.setSelectedItem(DisplayConstants.REPORT_STYLES.TABLE.getNLSName());
        this._style.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                propertyChangeListener.propertyChange(new PropertyChangeEvent(ReportNamePanel.this._style, ReportNamePanel.STYLE, null, ReportNamePanel.this._style.getSelectedItem()));
            }
        });
        this.add((Component)jLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 6, 0, 6), 0, 0));
        this.add((Component)this._style, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 8), 0, 0));
        Object object3 = reportTreeContext.mode();
        if (object3 != EditMode.EDIT) {
            reportTreeContext.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("MODE")) {
                        ReportNamePanel.this.setSQLUI(reportTreeContext.mode());
                    }
                }
            });
        }
        this._desc = new JTextArea();
        this._desc.setRows(5);
        this._desc.setLineWrap(true);
        this._desc.setWrapStyleWord(true);
        this._desc.setPreferredSize(new Dimension(200, 300));
        object2 = new JScrollPane(this._desc, 22, 31);
        this.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 6, 0, 6), 0, 0));
        this.add((Component)object2, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 8), 0, 0));
        this._tip = new JTextField();
        this.add((Component)jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 6, 0, 6), 0, 0));
        this.add((Component)this._tip, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 8), 0, 0));
        if (object3 != EditMode.EDIT) {
            this.sqlEditor = new ReportSQLEditor(reportTreeContext, "");
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(new LineBorder(Color.LIGHT_GRAY));
            jPanel.add((Component)this.sqlEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.sqlEditorPanel = new JPanel(new GridBagLayout());
            this.sqlEditorPanel.add((Component)new JLabel(ReportArb.getString("SQL_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.sqlEditorPanel.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.sqlEditorPanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(10, 6, 0, 8), 0, 0));
        }
        this.glue = Box.createGlue();
        this.add(this.glue, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(10, 6, 0, 8), 0, 0));
        this.setSQLUI((EditMode)((Object)object3));
    }

    public String getStyle() {
        int n = this._style.getSelectedIndex();
        return DisplayRegistry.getStyleType((int)n);
    }

    public String getNLSStyle() {
        return (String)this._style.getSelectedItem();
    }

    @Override
    public String getName() {
        return this._name.getText();
    }

    public String getDesc() {
        return this._desc.getText();
    }

    public String getTip() {
        return this._tip.getText();
    }

    public void setInfo(String string, String string2, String string3, String string4) {
        if (string == null) {
            this._name.setText("");
        } else {
            this._name.setText(string);
        }
        this._desc.setText(string2);
        this._tip.setText(string3);
        if (string4 == null || string4.isEmpty()) {
            this._style.setSelectedItem(DisplayConstants.REPORT_STYLES.TABLE.getNLSName());
        } else {
            String string5 = DisplayRegistry.getNLSStyle((String)string4);
            this._style.setSelectedItem(string5);
        }
    }

    public String getSQL() {
        return this.sqlEditor.getSql();
    }

    public void setSQL(String string) {
        this.sqlEditor.refreshSQL(string);
    }

    private void setSQLUI(EditMode editMode) {
        if (this.sqlEditorPanel != null) {
            this.sqlEditorPanel.setVisible(editMode == EditMode.NEW);
        }
        this.glue.setVisible(editMode != EditMode.NEW);
        this.revalidate();
    }
}

