/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.util;

import java.text.ParsePosition;
import java.util.Locale;
import oracle.core.ojdl.util.CLFTimestampFormat;
import oracle.core.ojdl.util.ISO8601TimestampFormat;
import oracle.core.ojdl.util.SimpleTimestampFormat;

public abstract class TimestampFormat {
    public static final long ERROR = Long.MIN_VALUE;
    public static final String ISO8601 = "ISO8601";
    public static final String CLF = "CLF";
    public static final String CLF_WITH_BRACKETS = "CLF_WITH_BRACKETS";

    public static TimestampFormat getInstance() {
        return new SimpleTimestampFormat();
    }

    public static TimestampFormat getInstance(String format) {
        return TimestampFormat.getInstance(format, Locale.getDefault());
    }

    public static TimestampFormat getInstance(String format, Locale locale) {
        if (format.equals(ISO8601)) {
            return new ISO8601TimestampFormat();
        }
        if (format.equals(CLF)) {
            return new CLFTimestampFormat(false, locale);
        }
        if (format.equals(CLF_WITH_BRACKETS)) {
            return new CLFTimestampFormat(true, locale);
        }
        return new SimpleTimestampFormat(format, locale);
    }

    public static TimestampFormat getInstance(String format, String locale) {
        return TimestampFormat.getInstance(format, TimestampFormat.toLocale(locale));
    }

    public abstract long parse(String var1, ParsePosition var2);

    public long parse(String str) {
        return this.parse(str, new ParsePosition(0));
    }

    public long parse(char[] chars, ParsePosition pos) {
        return this.parse(new String(chars), pos);
    }

    public static Locale toLocale(String name) {
        if (name == null) {
            return Locale.getDefault();
        }
        String[] str = new String[]{"", "", ""};
        int pos = 0;
        for (int i = 0; i < 3; ++i) {
            int next = name.indexOf(95, pos);
            if (next < 0) {
                str[i] = name.substring(pos);
                break;
            }
            str[i] = name.substring(pos, next);
            pos = next + 1;
        }
        return new Locale(str[0], str[1], str[2]);
    }
}

