/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging.context;

import oracle.core.ojdl.logging.context.LoggingContext;
import oracle.core.ojdl.logging.context.LoggingContextManager;
import oracle.core.ojdl.logging.context.LoggingContextProvider;
import oracle.core.ojdl.logging.impl.DMSLoggingContext;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;

public class DMSLoggingContextProvider
implements LoggingContextProvider {
    private static boolean s_isTracingEnabled = false;

    public DMSLoggingContextProvider() {
        LoggingContextManager.setLoggingContextProvider("oracle.dms.context", LoggingContextManager.s_noOpProvider);
    }

    @Override
    public LoggingContext getLoggingContext() {
        ExecutionContext ctx = ExecutionContext.get((boolean)false);
        if (ctx != null) {
            return new DMSLoggingContext(ctx);
        }
        return LoggingContextManager.s_noOpContext;
    }

    @Override
    public boolean isContextLevelEnabled() {
        return DMSContextManager.getLogLevelCount() > 0 || s_isTracingEnabled;
    }

    public static void setTracingEnabled(boolean enabled) {
        s_isTracingEnabled = enabled;
    }
}

