/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.ODL11Formatter;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.XMLFormatter;
import oracle.core.ojdl.logging.HandlerFactory;
import oracle.core.ojdl.logging.HandlerFactoryException;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.core.ojdl.logging.QuickTraceCacheByRefHandler;
import oracle.core.ojdl.logging.QuickTraceCacheByValHandler;
import oracle.core.ojdl.logging.QuickTraceHandler;
import oracle.core.ojdl.logging.QuickTraceJFRHandler;
import oracle.core.ojdl.messages.Msgs;
import oracle.core.ojdl.util.TimestampFormat;
import oracle.dms.instrument.Noun;

public class QuickTraceHandlerFactory
implements HandlerFactory {
    private Properties m_properties;
    private HashMap m_nameMap;
    private static Vector<QuickTraceHandler> handlers_s = new Vector();
    private Noun nounRoot_;
    private static final String JFR_STR = "JFR";
    private static final String OBJREF_STR = "objRef";
    private static final String OBJVAL_STR = "objVal";
    static final String ROOTNAME = "/oracle/odl/quicktrace";
    private static final String PATH = "path";
    private static final String FORMAT = "format";
    private static final String MAXFILESZ = "maxFileSize";
    private static final String MAXLOGSZ = "maxLogSize";
    private static final String BASETIME = "baseRotationTime";
    private static final String FREQUENCY = "rotationFrequency";
    private static final String RETENTION = "retentionPeriod";
    private static final String ENCODING = "encoding";
    private static final String SUPPLATTRS = "supplementalAttributes";
    private static final String USESCM = "useSourceClassandMethod";
    private static final String USEDEFATTRS = "useDefaultAttributes";
    private static final String INCMSGARGS = "includeMessageArguments";
    private static final String DELETEFILES = "deleteFiles";
    private static final String KEEPOPEN = "keepOpen";
    private static final String LOCALE = "locale";
    private static final String AUTOFLUSH = "autoFlushLevel";
    private static final String USETHRNAME = "useThreadName";
    private static final String USEREALTHRID = "useRealThreadID";
    private static final String ADDJVMNUM = "addJvmNumber";
    private static final String APPCTX = "applicationContextProvider";
    private static final String USRCTX = "userContextProvider";
    private static final String LOCKMODE = "lockMode";
    private static final String LOCKTIMEOUT = "lockTimeOut";
    private static final String BUFFERSIZE = "bufferSize";
    private static final String MODE = "mode";
    private static final String MAXFIELDLENGTH = "maxFieldLength";
    private static final String USELOGGINGCONTEXT = "useLoggingContext";
    private static final String ENABLEDMSMETRICS = "enableDMSMetrics";
    private static final String ENABLEUSERBUFFER = "enableUserBuffer";
    private static final String FLUSHONDUMP = "flushOnDump";
    private static final String RESERVEBUFFERIDS = "reserveBufferUserIDs";
    private static final List<String> s_allProperties = Collections.unmodifiableList(Arrays.asList("path".toLowerCase(), "format".toLowerCase(), "maxFileSize".toLowerCase(), "maxLogSize".toLowerCase(), "baseRotationTime".toLowerCase(), "rotationFrequency".toLowerCase(), "retentionPeriod".toLowerCase(), "encoding".toLowerCase(), "supplementalAttributes".toLowerCase(), "useSourceClassandMethod".toLowerCase(), "useDefaultAttributes".toLowerCase(), "includeMessageArguments".toLowerCase(), "deleteFiles".toLowerCase(), "keepOpen".toLowerCase(), "locale".toLowerCase(), "autoFlushLevel".toLowerCase(), "useThreadName".toLowerCase(), "useRealThreadID".toLowerCase(), "addJvmNumber".toLowerCase(), "applicationContextProvider".toLowerCase(), "userContextProvider".toLowerCase(), "lockMode".toLowerCase(), "lockTimeOut".toLowerCase(), "bufferSize".toLowerCase(), "mode".toLowerCase(), "maxFieldLength".toLowerCase(), "useLoggingContext".toLowerCase(), "enableDMSMetrics".toLowerCase(), "enableUserBuffer".toLowerCase(), "flushOnDump".toLowerCase(), "reserveBufferUserIDs".toLowerCase()));

    @Override
    public Handler create(Properties properties) throws HandlerFactoryException {
        return this.configure(null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler configure(QuickTraceHandler h, Properties properties) throws HandlerFactoryException {
        QuickTraceHandlerFactory quickTraceHandlerFactory = this;
        synchronized (quickTraceHandlerFactory) {
            if (this.nounRoot_ == null) {
                try {
                    this.nounRoot_ = Noun.get((String)ROOTNAME);
                }
                catch (Exception ex) {
                    this.nounRoot_ = Noun.create((String)ROOTNAME);
                }
                if (this.nounRoot_ == null) {
                    this.nounRoot_ = Noun.create((String)ROOTNAME);
                }
            }
        }
        this.m_properties = properties;
        this.m_nameMap = new HashMap(properties.size());
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String lname = name.toLowerCase();
            if (!QuickTraceHandlerFactory.isValidPropertyName(lname)) {
                throw new HandlerFactoryException(Msgs.get("ODL-52030", name));
            }
            this.m_nameMap.put(lname, name);
        }
        String path = this.getProperty(PATH);
        String format = this.getProperty(FORMAT, "ODL-Text");
        if (!(format.equalsIgnoreCase("ODL-Text") || format.equalsIgnoreCase("ODL-XML") || format.equalsIgnoreCase("ODL10-XML"))) {
            throw new HandlerFactoryException(Msgs.get("ODL-52032", format, "'ODL-Text', 'ODL-XML'"));
        }
        long fileSize = this.getLongProperty(MAXFILESZ, Long.MAX_VALUE);
        if (fileSize <= 0L) {
            throw new HandlerFactoryException(this.invPropVal(MAXFILESZ));
        }
        long logSize = this.getLongProperty(MAXLOGSZ, Long.MAX_VALUE);
        if (logSize <= 0L) {
            throw new HandlerFactoryException(this.invPropVal(MAXLOGSZ));
        }
        if (logSize < fileSize) {
            throw new HandlerFactoryException(Msgs.get("ODL-52034", MAXLOGSZ, MAXFILESZ));
        }
        long bufferSize = this.getLongProperty(BUFFERSIZE, 0x500000L);
        if (bufferSize <= 0L) {
            throw new HandlerFactoryException(this.invPropVal(MAXLOGSZ));
        }
        int fieldLength = this.getIntegerProperty(MAXFIELDLENGTH, 240);
        boolean enableUserBuffer = "true".equalsIgnoreCase(this.getProperty(ENABLEUSERBUFFER, "false"));
        boolean flushOnDump = "true".equalsIgnoreCase(this.getProperty(FLUSHONDUMP, "true"));
        String supplAttrs = this.getProperty(SUPPLATTRS);
        String reserveBufferIDs = this.getProperty(RESERVEBUFFERIDS);
        String useDefAttr = this.getProperty(USEDEFATTRS);
        String incMsgArgs = this.getProperty(INCMSGARGS);
        String appCtx = this.getProperty(APPCTX);
        String usrCtx = this.getProperty(USRCTX);
        String localeStr = this.getProperty(LOCALE);
        String useThrName = this.getProperty(USETHRNAME, "false");
        String useRealThrId = this.getProperty(USEREALTHRID, "false");
        boolean enableDMSMetrics = "true".equalsIgnoreCase(this.getProperty(ENABLEDMSMETRICS, "true"));
        QuickTraceHandler.Mode mode = this.parseMode();
        Locale locale = localeStr != null ? TimestampFormat.toLocale(localeStr) : null;
        String useSCM = this.getProperty(USESCM, "false");
        Level useSCMLevel = null;
        if (useSCM != null) {
            if (useSCM.equalsIgnoreCase("true")) {
                useSCMLevel = Level.OFF;
            } else if (useSCM.equalsIgnoreCase("false")) {
                useSCMLevel = Level.ALL;
            } else {
                try {
                    useSCMLevel = this.parseLevel(useSCM);
                }
                catch (IllegalArgumentException e) {
                    throw new HandlerFactoryException(this.invPropVal(USESCM));
                }
            }
        }
        boolean addJvmNum = "true".equalsIgnoreCase(this.getProperty(ADDJVMNUM));
        boolean useLoggingContext = "true".equalsIgnoreCase(this.getProperty(USELOGGINGCONTEXT, "false"));
        try {
            String defaultFilename;
            LogFormatter logFormatter;
            if (format.equals("ODL-XML")) {
                logFormatter = new ODL11Formatter();
                defaultFilename = "log.xml";
            } else if (format.equals("ODL10-XML")) {
                logFormatter = new XMLFormatter();
                defaultFilename = "log.xml";
            } else {
                logFormatter = new ODLTextFormatter();
                defaultFilename = "diagnostic.log";
            }
            if (path != null) {
                path = this.getEffectivePath(path, defaultFilename, addJvmNum);
            }
            boolean isUseThreadName = false;
            if (useThrName != null) {
                isUseThreadName = useThrName.equalsIgnoreCase("true");
            }
            boolean isUseReadThreadId = false;
            if (useRealThrId != null) {
                isUseReadThreadId = useRealThrId.equalsIgnoreCase("true");
            }
            if (h == null) {
                QuickTraceHandlerFactory quickTraceHandlerFactory2 = this;
                synchronized (quickTraceHandlerFactory2) {
                    switch (mode) {
                        case JFR: {
                            h = new QuickTraceJFRHandler(logFormatter, bufferSize, fieldLength, path, useLoggingContext, mode, enableDMSMetrics, this.nounRoot_, enableUserBuffer, flushOnDump);
                            break;
                        }
                        case OBJVAL: {
                            h = new QuickTraceCacheByValHandler(logFormatter, bufferSize, fieldLength, useLoggingContext, mode, enableDMSMetrics, this.nounRoot_, enableUserBuffer, flushOnDump);
                            break;
                        }
                        default: {
                            h = new QuickTraceCacheByRefHandler(logFormatter, bufferSize, fieldLength, useLoggingContext, mode, enableDMSMetrics, isUseThreadName | isUseReadThreadId, this.nounRoot_, enableUserBuffer, flushOnDump);
                        }
                    }
                }
                if (useThrName != null) {
                    h.setUseThreadName(useThrName.equalsIgnoreCase("true"));
                }
                if (useRealThrId != null) {
                    h.setUseRealThreadId(useRealThrId.equalsIgnoreCase("true"));
                }
                if (useDefAttr != null) {
                    h.setUseDefaultAttributes(useDefAttr.equalsIgnoreCase("true"));
                } else if (format.equalsIgnoreCase("ODL-Text")) {
                    h.setUseDefaultAttributes(false);
                }
                if (supplAttrs != null) {
                    String[] list = QuickTraceJFRHandler.parseAttrList(supplAttrs);
                    h.setSupplementalAttributes(list);
                }
                if (appCtx != null) {
                    h.setApplicationContextProvider(appCtx);
                }
                if (locale != null) {
                    h.setLocale(locale);
                }
                h.initHandler();
                QuickTraceHandlerFactory.addHandler(h);
            } else {
                h.setFieldLength(fieldLength);
                if (useThrName != null || useRealThrId != null) {
                    if (h instanceof QuickTraceCacheByRefHandler) {
                        QuickTraceCacheByRefHandler rh = (QuickTraceCacheByRefHandler)h;
                        rh.reenableThreadNames(isUseThreadName, isUseReadThreadId);
                    }
                    if (useThrName != null) {
                        h.setUseThreadName(isUseThreadName);
                    }
                    if (useRealThrId != null) {
                        h.setUseRealThreadId(isUseReadThreadId);
                    }
                }
                h.setUseLoggingContext(useLoggingContext);
            }
            if (incMsgArgs != null) {
                h.setIncludeMessageArguments(incMsgArgs.equalsIgnoreCase("true"));
            }
            if (useSCMLevel != null) {
                h.setUseSourceClassAndMethod(useSCMLevel);
            }
            if (reserveBufferIDs != null) {
                String[] ids = ODLHandler.parseAttrList(reserveBufferIDs);
                h.setReserveBufferIDs(ids);
            }
            if (usrCtx != null) {
                h.setUserContextProvider(usrCtx);
                h.setUserContext(usrCtx);
            }
        }
        catch (Exception e) {
            throw new HandlerFactoryException(Msgs.get("ODL-52035", e), e);
        }
        return h;
    }

    public static boolean isValidPropertyName(String name) {
        return s_allProperties.contains(name) || name.startsWith("metadata:") || name.startsWith("logreader:") || name.startsWith("logviewer:");
    }

    private String getEffectivePath(String path, String defaultFilename, boolean addJvmNumber) {
        File f = new File(path);
        String epath = defaultFilename != null && (f.isDirectory() || !f.exists() && (path.length() <= 4 || path.charAt(path.length() - 4) != '.')) ? new File(f, defaultFilename).getAbsolutePath() : path;
        String jvmNum = System.getProperty("oracle.process.index");
        if (addJvmNumber && jvmNum != null) {
            epath = epath.length() > 4 && epath.charAt(epath.length() - 4) == '.' ? epath.substring(0, epath.length() - 4) + "-jvm" + jvmNum + epath.substring(epath.length() - 4) : epath + "-jvm" + jvmNum;
        }
        return epath;
    }

    static boolean is64BitVM() {
        boolean status = false;
        try {
            String vmBit = System.getProperty("os.arch");
            if (vmBit != null && vmBit.indexOf("64") != -1) {
                status = true;
            }
        }
        catch (Exception ex) {
            status = false;
        }
        return status;
    }

    private long getLongProperty(String name, long defVal) throws HandlerFactoryException {
        String value = this.getProperty(name);
        if (value == null) {
            return defVal;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new HandlerFactoryException(this.invPropVal(name));
        }
    }

    private int getIntegerProperty(String name, int defVal) throws HandlerFactoryException {
        String value = this.getProperty(name);
        if (value == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new HandlerFactoryException(this.invPropVal(name));
        }
    }

    private String getProperty(String name) {
        String pname = (String)this.m_nameMap.get(name.toLowerCase());
        if (pname != null) {
            return this.m_properties.getProperty(pname);
        }
        return null;
    }

    private String getProperty(String name, String defVal) {
        String value = this.getProperty(name);
        return value == null ? defVal : value;
    }

    private Level parseLevel(String levelName) {
        try {
            return ODLLevel.parse(levelName);
        }
        catch (IllegalArgumentException e1) {
            return ODLLevel.parse(levelName.toUpperCase());
        }
    }

    private String invPropVal(String name) {
        return Msgs.get("ODL-52033", name, this.getProperty(name));
    }

    public static Vector<QuickTraceHandler> getCreatedHandlers() {
        return handlers_s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addHandler(QuickTraceHandler h) {
        Vector<QuickTraceHandler> vector = handlers_s;
        synchronized (vector) {
            handlers_s.add(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeHandler(QuickTraceHandler h) {
        Vector<QuickTraceHandler> vector = handlers_s;
        synchronized (vector) {
            handlers_s.remove(h);
            h.destroyDMSSensors();
        }
    }

    private QuickTraceHandler.Mode parseMode() {
        QuickTraceHandler.Mode mode = null;
        String prop = this.getProperty(MODE);
        mode = JFR_STR.equalsIgnoreCase(prop) ? QuickTraceHandler.Mode.JFR : (OBJREF_STR.equalsIgnoreCase(prop) ? QuickTraceHandler.Mode.OBJREF : (OBJVAL_STR.equalsIgnoreCase(prop) ? QuickTraceHandler.Mode.OBJVAL : QuickTraceHandler.Mode.OBJREF));
        return mode;
    }

    public static String parseMode(QuickTraceHandler.Mode mode) {
        String result = null;
        if (mode != null) {
            switch (mode) {
                case JFR: {
                    result = JFR_STR;
                    break;
                }
                case OBJREF: {
                    result = OBJREF_STR;
                    break;
                }
                case OBJVAL: {
                    result = OBJVAL_STR;
                    break;
                }
            }
        }
        return result;
    }
}

