/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.tracing;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import oracle.core.ojdl.logging.ODLLevel;

public class TraceInfo
implements Serializable {
    private String m_internalId;
    private String m_traceId;
    private String m_attrName;
    private String m_attrValue;
    private Level m_level;
    private long m_expirationTime;
    private long m_startTime;
    private long m_stopTime;
    private String m_desc;
    private static long s_id = 0L;
    private static CompositeType s_compositeType;
    private static final String TYPE_NAME;
    private static final String[] ITEM_NAMES;
    private static final long serialVersionUID = 20110215L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceInfo() {
        Class<TraceInfo> clazz = TraceInfo.class;
        synchronized (TraceInfo.class) {
            this.m_internalId = Long.toString(++s_id);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getInternalId() {
        return this.m_internalId;
    }

    public String getTraceId() {
        return this.m_traceId;
    }

    public void setTraceId(String traceId) {
        this.m_traceId = traceId;
    }

    public Level getLevel() {
        return this.m_level;
    }

    public void setLevel(Level level) {
        this.m_level = level;
    }

    public String getAttrName() {
        return this.m_attrName;
    }

    public void setAttrName(String attrName) {
        this.m_attrName = attrName;
    }

    public String getAttrValue() {
        return this.m_attrValue;
    }

    public void setAttrValue(String attrValue) {
        this.m_attrValue = attrValue;
    }

    public String getDesc() {
        return this.m_desc;
    }

    public void setDesc(String desc) {
        this.m_desc = desc;
    }

    public long getExpirationTime() {
        return this.m_expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.m_expirationTime = expirationTime;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(long startTime) {
        this.m_startTime = startTime;
    }

    public long getStopTime() {
        return this.m_stopTime;
    }

    public void setStopTime(long stopTime) {
        this.m_stopTime = stopTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TraceInfo from(CompositeData cd) throws OpenDataException {
        CompositeType ct = cd.getCompositeType();
        if (!(TraceInfo.class.getName().equals(ct.getTypeName()) && TraceInfo.hasAttr(ct, "internalId") && TraceInfo.hasAttr(ct, "traceId") && TraceInfo.hasAttr(ct, "attrName") && TraceInfo.hasAttr(ct, "attrValue") && TraceInfo.hasAttr(ct, "level") && TraceInfo.hasAttr(ct, "expirationTime") && TraceInfo.hasAttr(ct, "desc"))) {
            throw new IllegalArgumentException("Invalid argument CompositeType");
        }
        TraceInfo ti = new TraceInfo();
        ti.m_internalId = (String)cd.get("internalId");
        ti.setTraceId((String)cd.get("traceId"));
        String level = null;
        Object o = cd.get("level");
        if (o instanceof CompositeData) {
            CompositeData lcd = (CompositeData)o;
            CompositeType lct = lcd.getCompositeType();
            if (!Level.class.getName().equals(lct.getTypeName()) || !lct.containsKey("name")) throw new IllegalArgumentException("Invalid CompositeType for attribute 'level'");
            level = (String)lcd.get("name");
        } else {
            level = (String)o;
        }
        ti.setLevel(ODLLevel.parse(level));
        ti.setAttrName((String)cd.get("attrName"));
        ti.setAttrValue((String)cd.get("attrValue"));
        ti.setExpirationTime((Long)cd.get("expirationTime"));
        ti.setDesc((String)cd.get("desc"));
        o = cd.get("startTime");
        if (o != null) {
            ti.setStartTime((Long)o);
        }
        if ((o = cd.get("stopTime")) == null) return ti;
        ti.setStopTime((Long)o);
        return ti;
    }

    public CompositeData toCompositeData(CompositeType ct) throws OpenDataException {
        if (ct == null) {
            ct = TraceInfo.toCompositeType();
        } else if (!TraceInfo.toCompositeType().equals(ct)) {
            throw new IllegalArgumentException("Invalid argument CompositeType");
        }
        return new CompositeDataSupport(ct, ITEM_NAMES, new Object[]{this.getInternalId(), this.getTraceId(), this.getAttrName(), this.getAttrValue(), this.getLevel().toString(), this.getExpirationTime(), this.getStartTime(), this.getStopTime(), this.getDesc()});
    }

    public static CompositeType toCompositeType() {
        return s_compositeType;
    }

    private static boolean hasAttr(CompositeType ct, String name) {
        return ct.containsKey(name);
    }

    static {
        TYPE_NAME = TraceInfo.class.getName();
        ITEM_NAMES = new String[]{"internalId", "traceId", "attrName", "attrValue", "level", "expirationTime", "startTime", "stopTime", "desc"};
        try {
            s_compositeType = new CompositeType(TYPE_NAME, TYPE_NAME, ITEM_NAMES, ITEM_NAMES, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING});
        }
        catch (OpenDataException e) {
            Logger.getLogger("oracle.odl.tracing").log(Level.FINE, "Unable to initialize CompositeType: " + e, e);
        }
    }
}

