/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DateModifier;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationAnchor;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationUnit;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.DurationValue;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ModifierType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.OffsetAnchor;

public class OffsetModifier
extends DateModifier
implements Comparable<OffsetModifier>,
ClauseElement {
    protected final OffsetAnchor anchor;
    protected final DurationValue value;

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public OffsetModifier(OffsetAnchor offsetAnchor, DurationValue durationValue) {
        this.anchor = offsetAnchor;
        this.value = durationValue;
    }

    public OffsetModifier(OffsetAnchor offsetAnchor, DurationUnit durationUnit, Integer n) {
        this.anchor = offsetAnchor;
        this.value = new DurationValue(durationUnit, n);
    }

    @Override
    public ModifierType getModifierType() {
        return ModifierType.OFFSET;
    }

    public OffsetAnchor getOffsetAnchor() {
        return this.anchor;
    }

    @Override
    public DurationAnchor getDurationAnchor() {
        return this.getOffsetAnchor();
    }

    public DurationValue getDurationValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        OffsetModifier offsetModifier = (OffsetModifier)object;
        return OffsetModifier.areEqual(this.anchor, offsetModifier.anchor) && OffsetModifier.areEqual(this.value, offsetModifier.value);
    }

    @Override
    public int compareTo(OffsetModifier offsetModifier) {
        int n = 0;
        if (this != offsetModifier) {
            if (this.anchor != offsetModifier.anchor) {
                n = this.anchor == null && offsetModifier.anchor != null ? -1 : (this.anchor != null && offsetModifier.anchor == null ? 1 : this.anchor.compareTo(offsetModifier.anchor));
            }
            if (n == 0 && this.value != offsetModifier.value) {
                n = this.value == null && offsetModifier.value != null ? -1 : (this.value != null && offsetModifier.value == null ? 1 : this.value.compareTo(offsetModifier.value));
            }
        }
        return n;
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.anchor == null ? 0 : this.anchor.hashCode());
        n = n * 31 + (this.value == null ? 0 : this.value.hashCode());
        return n;
    }

    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder) {
        if (this.anchor != null && this.value != null) {
            this.anchor.buildClause(stringBuilder);
            stringBuilder.append(this.getModifierType());
            stringBuilder.append(":");
            this.value.buildClause(stringBuilder);
        }
        return stringBuilder;
    }
}

