/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.NaryClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;

public class ListClauseModel<E>
extends NaryClauseModel<E> {
    protected List<E> values = new ArrayList();

    public ListClauseModel(Class<E> clazz, ClauseType clauseType, RepeatIntervalModel repeatIntervalModel) {
        this(clazz, clauseType, repeatIntervalModel, null);
    }

    public ListClauseModel(Class<E> clazz, ClauseType clauseType, RepeatIntervalModel repeatIntervalModel, E[] EArray) {
        super(clazz, clauseType, repeatIntervalModel, EArray);
        this.reset();
    }

    @Override
    protected Collection<E> getValues() {
        return this.values;
    }

    protected void reset() {
        this.values.clear();
        if (this.defaultValue != null) {
            for (Object object : this.defaultValue) {
                this.values.add(object);
            }
        }
    }

    @Override
    public boolean add(E e) {
        boolean bl = false;
        if (e != null) {
            int n = this.values.size();
            if (n == 0 || !ListClauseModel.areEqual(this.values.get(n - 1), e)) {
                bl = this.values.add(e);
            }
            if (bl) {
                int n2 = n;
                this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.CREATE, n2, null, e));
            }
        }
        return bl;
    }

    public boolean add(int n, E e) {
        boolean bl = false;
        if (e != null) {
            int n2 = this.values.size();
            if (n2 == 0 || n >= n2 || !ListClauseModel.areEqual(this.values.get(n), e)) {
                try {
                    this.values.add(n, e);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return false;
                }
            }
            if (bl) {
                this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.CREATE, n, null, e));
            }
        }
        return bl;
    }

    @Override
    public boolean remove(E e) {
        int n;
        boolean bl = false;
        if (e != null && (n = this.values.lastIndexOf(e)) != -1) {
            bl = this.remove(n);
        }
        return bl;
    }

    @Override
    public boolean remove(int n) {
        E e = this.values.remove(n);
        if (e != null) {
            this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.DELETE, n, e, null));
            return true;
        }
        return false;
    }

    @Override
    public E[] getAll() {
        return this.values.toArray(this.newArray(this.values.size()));
    }

    public int lastIndexOf(E e) {
        return this.values.lastIndexOf(e);
    }

    @Override
    public boolean contains(E e) {
        return this.values.contains(e);
    }

    public int count(E e) {
        int n = 0;
        if (e != null) {
            for (E e2 : this.values) {
                if (!ListClauseModel.areEqual(e2, e)) continue;
                ++n;
            }
        }
        return n;
    }

    @Override
    public void clear() {
        E[] EArray = this.getAll();
        this.reset();
        this.fireRepeatIntervalModelEvent(new RepeatIntervalModelEvent(this, RepeatIntervalModelEvent.EventType.CLEAR, EArray, this.getAll()));
    }

    @Override
    public boolean isClear() {
        if (this.defaultValue != null) {
            if (this.defaultValue.length == this.values.size()) {
                for (Object object : this.defaultValue) {
                    if (this.contains(object)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size();
    }
}

