/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.model;

import java.text.DecimalFormat;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseElement;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Month;

public class Date
implements Comparable<Date>,
ClauseElement {
    protected final Integer day;
    protected final Month month;
    protected final Integer year;

    private static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public Date(Integer n, Month month) {
        this(n, month, null);
    }

    public Date(Integer n, Month month, Integer n2) {
        this.day = n;
        this.month = month;
        this.year = n2;
    }

    @Override
    public int compareTo(Date date) {
        int n = 0;
        if (this != date) {
            if (this.year != date.year) {
                if (this.year == null && date.year != null) {
                    return -1;
                }
                if (this.year != null && date.year == null) {
                    return 1;
                }
                n = this.year.compareTo(date.year);
            }
            if (n == 0 && this.month != date.month) {
                n = this.month == null && date.month != null ? -1 : (this.month != null && date.month == null ? 1 : this.month.compareTo(date.month));
            }
            if (n == 0 && this.day != date.day) {
                n = this.day == null && date.day != null ? -1 : (this.day != null && date.day == null ? 1 : this.day.compareTo(date.day));
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Date date = (Date)object;
        return Date.areEqual(this.year, date.year) && Date.areEqual(this.month, date.month) && Date.areEqual(this.day, date.day);
    }

    public int hashCode() {
        int n = 7;
        n = n * 31 + (this.year == null ? 0 : this.year.hashCode());
        n = n * 31 + (this.month == null ? 0 : this.month.hashCode());
        n = n * 31 + (this.day == null ? 0 : this.day.hashCode());
        return n;
    }

    public Integer getDay() {
        return this.day;
    }

    public Month getMonth() {
        return this.month;
    }

    public Integer getYear() {
        return this.year;
    }

    @Override
    public StringBuilder buildClause(StringBuilder stringBuilder) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0000");
        if (this.month != null && this.day != null) {
            if (this.year != null) {
                stringBuilder.append(decimalFormat2.format(this.year));
            }
            stringBuilder.append(decimalFormat.format(this.month.ordinal() + 1));
            stringBuilder.append(decimalFormat.format(this.day));
        }
        return stringBuilder;
    }
}

