/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.panels.common.repeatinterval.clause;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.AbstractRepeatIntervalClause;
import oracle.dbtools.scheduler.panels.common.repeatinterval.clause.ClauseSyntaxHandler;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.ClausePanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.component.PropertyBasedPanel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.ClauseType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.Frequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.FrequencyType;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.PreDefinedFrequency;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModel;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelEvent;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.RepeatIntervalModelListener;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.UnaryClauseModel;

public class FreqClause
extends AbstractRepeatIntervalClause<Frequency, UnaryClauseModel<Frequency>> {
    public FreqClause(RepeatIntervalModel repeatIntervalModel) {
        this(Frequency.class, repeatIntervalModel);
    }

    protected FreqClause(UnaryClauseModel<Frequency> unaryClauseModel) {
        super(unaryClauseModel);
    }

    protected FreqClause(Class<Frequency> clazz, RepeatIntervalModel repeatIntervalModel) {
        this(new UnaryClauseModel<Frequency>(clazz, ClauseType.FREQ, repeatIntervalModel));
    }

    public JPanel getPreDefinedPanel(Properties properties) {
        return new PreDefinedPanel(properties);
    }

    public JPanel getPreDefinedSimplePanel(Properties properties) {
        return new PreDefinedSimplePanel(properties);
    }

    public JPanel getPreDefinedPanel() {
        return this.getPreDefinedPanel(null);
    }

    public JPanel getPreDefinedSimplePanel() {
        return this.getPreDefinedSimplePanel(null);
    }

    @Override
    public JPanel getPanel() {
        return this.getPanel(null);
    }

    @Override
    public JPanel getPanel(Properties properties) {
        return new PreDefinedPanel(properties);
    }

    @Override
    public ClauseSyntaxHandler getSyntaxHandler() {
        return new SyntaxHandler();
    }

    protected class SyntaxHandler
    extends AbstractRepeatIntervalClause.AbstractSyntaxHandler {
        protected SyntaxHandler() {
        }

        protected Frequency parseFrequency(String string) {
            return PreDefinedFrequency.valueOf(string.toUpperCase());
        }

        @Override
        public void initialise(String string) {
            if (string != null) {
                Frequency frequency = this.parseFrequency(string);
                ((UnaryClauseModel)FreqClause.this.clauseModel).set(frequency);
            }
        }
    }

    protected class PreDefinedSimplePanel
    extends PreDefinedPanel {
        protected boolean singular;

        public PreDefinedSimplePanel(Properties properties) {
            super(properties);
            this.singular = false;
            this.preDefinedFreqComboBox.setMinimumSize(this.preDefinedFreqComboBox.getPreferredSize());
            this.singular = true;
            this.preDefinedFreqComboBox.repaint();
            ((UnaryClauseModel)FreqClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        @Override
        protected void preDefinedFreqComboBox_setSelectedItem(Object object) {
            if (object instanceof PreDefinedFrequency) {
                int n = ((PreDefinedFrequency)object).ordinal();
                if (n < this.frequencies.length) {
                    super.preDefinedFreqComboBox_setSelectedItem(this.frequencies[n]);
                } else {
                    super.preDefinedFreqComboBox_setSelectedItem(null);
                }
            } else {
                super.preDefinedFreqComboBox_setSelectedItem(object);
            }
        }

        @Override
        public PreDefinedFrequency getSelectedClauseElement() {
            Object object = this.preDefinedFreqModel.getSelectedItem();
            if (object instanceof FrequencyUnit) {
                return ((FrequencyUnit)object).getFrequency();
            }
            if (object instanceof PreDefinedFrequency) {
                return (PreDefinedFrequency)object;
            }
            return null;
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case INTERVAL: {
                        Integer n;
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object = repeatIntervalModelEvent.getNewValue();
                        PreDefinedSimplePanel.this.singular = object == null ? false : (n = (Integer)object) == 1;
                        PreDefinedSimplePanel.this.preDefinedFreqComboBox.repaint();
                    }
                }
            }
        }

        protected class FrequencyUnit
        implements Frequency,
        Comparable<FrequencyUnit> {
            protected PreDefinedFrequency frequency;

            public FrequencyUnit(PreDefinedFrequency preDefinedFrequency) {
                this.frequency = preDefinedFrequency;
            }

            public PreDefinedFrequency getFrequency() {
                return this.frequency;
            }

            public String toString() {
                return this.frequency.getUnit(PreDefinedSimplePanel.this.singular);
            }

            @Override
            public int compareTo(FrequencyUnit frequencyUnit) {
                int n = 0;
                if (this != frequencyUnit && this.frequency != frequencyUnit.frequency) {
                    n = this.frequency == null && frequencyUnit.frequency != null ? -1 : (this.frequency != null && frequencyUnit.frequency == null ? 1 : this.frequency.compareTo(frequencyUnit.frequency));
                }
                return n;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object == this) {
                    return true;
                }
                if (object.getClass() != this.getClass()) {
                    return false;
                }
                FrequencyUnit frequencyUnit = (FrequencyUnit)object;
                return AbstractRepeatIntervalClause.areEqual(this.frequency, frequencyUnit.frequency);
            }

            public int hashCode() {
                int n = 7;
                n = n * 31 + (this.frequency == null ? 0 : this.frequency.hashCode());
                return n;
            }

            @Override
            public FrequencyType getFrequencyType() {
                return this.frequency.getFrequencyType();
            }
        }
    }

    protected class PreDefinedPanel
    extends PropertyBasedPanel
    implements ClausePanel<Frequency> {
        protected transient GridBagLayout gridBagLayout1;
        protected transient ButtonGroup freqGroup;
        protected transient JComboBox preDefinedFreqComboBox;
        protected transient ComboBoxModel preDefinedFreqModel;
        protected Frequency[] frequencies;

        public PreDefinedPanel(Properties properties) {
            super(properties);
            this.gridBagLayout1 = new GridBagLayout();
            this.freqGroup = new ButtonGroup();
            this.preDefinedFreqComboBox = new JComboBox();
            this.initFrequencies();
            try {
                this.jbInit();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            ((UnaryClauseModel)FreqClause.this.clauseModel).addRepeatIntervalModelListener(new RepeatIntervalChangeListener());
        }

        protected void jbInit() throws Exception {
            this.setLayout(this.gridBagLayout1);
            this.preDefinedFreqModel = new DefaultComboBoxModel<Frequency>(this.frequencies);
            this.preDefinedFreqComboBox.setModel(this.preDefinedFreqModel);
            this.preDefinedFreqModel.setSelectedItem(null);
            this.preDefinedFreqComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PreDefinedPanel.this.preDefinedFreqComboBox_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.preDefinedFreqComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        }

        @Override
        public PreDefinedFrequency getSelectedClauseElement() {
            return (PreDefinedFrequency)this.preDefinedFreqModel.getSelectedItem();
        }

        @Override
        public ClauseModel<Frequency> getClauseModel() {
            return FreqClause.this.clauseModel;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.preDefinedFreqComboBox.setEnabled(bl);
        }

        protected void preDefinedFreqComboBox_actionPerformed(ActionEvent actionEvent) {
            PreDefinedFrequency preDefinedFrequency = this.getSelectedClauseElement();
            if (preDefinedFrequency != null) {
                ((UnaryClauseModel)FreqClause.this.clauseModel).set(this.getSelectedClauseElement());
            }
        }

        protected void preDefinedFreqComboBox_setSelectedItem(Object object) {
            this.preDefinedFreqModel.setSelectedItem(object);
        }

        protected void initFrequencies() {
            this.frequencies = PreDefinedFrequency.values();
        }

        protected class RepeatIntervalChangeListener
        implements RepeatIntervalModelListener {
            protected RepeatIntervalChangeListener() {
            }

            @Override
            public void repeatIntervalChanged(RepeatIntervalModelEvent repeatIntervalModelEvent) {
                switch (repeatIntervalModelEvent.getClauseType()) {
                    case FREQ: {
                        if (repeatIntervalModelEvent.getEventType() == RepeatIntervalModelEvent.EventType.PROPERTY_CHANGE) break;
                        Object object = repeatIntervalModelEvent.getNewValue();
                        if (object instanceof PreDefinedFrequency) {
                            PreDefinedPanel.this.preDefinedFreqComboBox_setSelectedItem(object);
                            break;
                        }
                        if (object != null && object instanceof PreDefinedFrequency) break;
                        PreDefinedPanel.this.preDefinedFreqComboBox_setSelectedItem(null);
                    }
                }
            }
        }
    }
}

