/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.graphical.controller;

import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.scheduler.editors.graphical.AbstractGraphicalEditor;
import oracle.dbtools.scheduler.editors.graphical.controller.GraphicalEditorController;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineEdge;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineGraph;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineNode;
import oracle.dbtools.scheduler.editors.graphical.model.GraphEngineObject;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public abstract class GraphicalEditorAbstractIdeController
implements Controller {
    protected GraphicalEditorController getGraphicalEditorController(Context context) {
        GraphicalEditorController graphicalEditorController = null;
        if (context != null && context.getView() instanceof AbstractGraphicalEditor) {
            AbstractGraphicalEditor abstractGraphicalEditor = (AbstractGraphicalEditor)context.getView();
            graphicalEditorController = abstractGraphicalEditor.getGraphicalEditorController();
        }
        return graphicalEditorController;
    }

    protected GraphEngineObject getGraphEngineObject(Context context) {
        GraphEngineObject graphEngineObject = null;
        if (context != null) {
            GraphicalEditorController graphicalEditorController = this.getGraphicalEditorController(context);
            Object[] objectArray = graphicalEditorController.getSelectedCells();
            Object object = null;
            if (objectArray == null || objectArray.length == 0) {
                graphEngineObject = graphicalEditorController.getModel().getGraph();
            } else if (objectArray != null && objectArray.length == 1) {
                object = objectArray[0];
                graphEngineObject = graphicalEditorController.getModelObject(object);
            }
        }
        return graphEngineObject;
    }

    protected GraphEngineNode getGraphEngineSrcObject(Context context) {
        GraphEngineNode graphEngineNode = null;
        GraphEngineObject graphEngineObject = this.getGraphEngineObject(context);
        if (graphEngineObject instanceof GraphEngineEdge) {
            GraphEngineEdge graphEngineEdge = (GraphEngineEdge)graphEngineObject;
            graphEngineNode = graphEngineEdge.getSource();
        }
        return graphEngineNode;
    }

    protected GraphEngineNode getGraphEngineTgtObject(Context context) {
        GraphEngineNode graphEngineNode = null;
        GraphEngineObject graphEngineObject = this.getGraphEngineObject(context);
        if (graphEngineObject instanceof GraphEngineEdge) {
            GraphEngineEdge graphEngineEdge = (GraphEngineEdge)graphEngineObject;
            graphEngineNode = graphEngineEdge.getTarget();
        }
        return graphEngineNode;
    }

    protected GraphEngineGraph getGraphEngineGraph(Context context) {
        GraphEngineGraph graphEngineGraph = null;
        GraphicalEditorController graphicalEditorController = this.getGraphicalEditorController(context);
        if (graphicalEditorController != null) {
            graphEngineGraph = graphicalEditorController.getModel().getGraph();
        }
        return graphEngineGraph;
    }

    protected DBObject getDBObject(Context context) {
        DBObject dBObject = null;
        GraphEngineObject graphEngineObject = this.getGraphEngineObject(context);
        if (graphEngineObject != null) {
            Element element = graphEngineObject.getElement();
            if (element == null) {
                GraphicalEditorController graphicalEditorController = this.getGraphicalEditorController(context);
                graphicalEditorController.getModel().getConnectionName();
                element = graphicalEditorController.getDatabaseNode(graphEngineObject);
            }
            dBObject = element instanceof IViewerNode ? ((IViewerNode)element).getDBObject() : new DBObject(element);
        } else if (context != null && context.getNode() != null) {
            Node node = context.getNode();
            dBObject = node instanceof IViewerNode ? ((IViewerNode)node).getDBObject() : new DBObject((Element)context.getNode());
        }
        return dBObject;
    }

    public boolean isGraphicalEditor(Context context) {
        return context == null ? false : context.getView() instanceof AbstractGraphicalEditor;
    }
}

