/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;
import oracle.dbtools.scheduler.editors.chain.ChainGraphModel;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.ui.search.SearchMatcher;

public class ChainRuleCellEditor
implements ICellEditor {
    public static final int COL_OWNER = 0;
    public static final int COL_CHAIN_NAME = 1;
    public static final int COL_RULE_OWNER = 2;
    public static final int COL_RULE_NAME = 3;
    public static final int COL_CONDITION = 4;
    public static final int COL_ACTION = 5;
    public static final int COL_COMMENTS = 6;
    JComponent renderer = null;

    public JComponent getComponent(JTable jTable, Object object, int n, int n2) {
        this.renderer = null;
        System.out.println("ChainRuleCellEditor(" + n + ", " + n2 + ")");
        boolean bl = n == 4 || n == 5 || n == 6;
        switch (n) {
            case 4: {
                FieldInsightProvider fieldInsightProvider = new FieldInsightProvider(){
                    private Logger logger = Logger.getLogger(this.getClass().getName());
                    private DefaultListCellRenderer _renderer;

                    public void completeInsight(Document document, int n, Object object) {
                        try {
                            String string = document.getText(0, n);
                            if (string.length() > 0 && string.lastIndexOf(" ") > 0) {
                                if (Character.isWhitespace(string.charAt(string.length() - 1))) {
                                    document.insertString(n, (String)object, null);
                                } else if (n - 1 > -1) {
                                    document.remove(string.lastIndexOf(" ") + 1, document.getLength() - string.lastIndexOf(" ") - 1);
                                    document.insertString(string.lastIndexOf(" ") + 1, (String)object, null);
                                }
                            } else {
                                document.remove(0, document.getLength());
                                document.insertString(0, (String)object, null);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            this.logger.log(Level.WARNING, "", badLocationException);
                        }
                    }

                    public ListCellRenderer getCellRenderer() {
                        if (this._renderer == null) {
                            this._renderer = new DefaultListCellRenderer();
                        }
                        return this._renderer;
                    }

                    public Object[] getInsightData(Document document, int n) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        try {
                            String string = document.getText(0, n);
                            List<String> list = Arrays.asList(ChainGraphModel.getReservedWords());
                            if (list != null) {
                                for (String string2 : list) {
                                    SearchMatcher searchMatcher;
                                    if (string.length() == 0 || Character.isWhitespace(string.charAt(string.length() - 1))) {
                                        SearchMatcher searchMatcher2 = SearchMatcher.getPrefixMatcher((CharSequence)string, (boolean)true, (boolean)true);
                                        if (searchMatcher2.matches((CharSequence)string2)) {
                                            arrayList.add(0, string2);
                                            continue;
                                        }
                                        arrayList.add(string2);
                                        continue;
                                    }
                                    int n2 = 0;
                                    if (string.lastIndexOf(" ") > 0 && string.lastIndexOf(" ") < string.length()) {
                                        n2 = string.lastIndexOf(" ");
                                    }
                                    if (!(searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string.substring(n2 + 1, string.length()), (boolean)true)).matches((CharSequence)string2)) continue;
                                    arrayList.add(string2);
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            this.logger.log(Level.WARNING, "", badLocationException);
                        }
                        return arrayList.toArray();
                    }

                    public boolean handlesInsight(Document document, int n) {
                        return true;
                    }

                    public boolean isAutoPopupChar(char c) {
                        return true;
                    }
                };
                CompletionTextField completionTextField = new CompletionTextField();
                completionTextField.setText(object == null ? "NULL" : object.toString());
                completionTextField.setEditable(true);
                completionTextField.getPopupHandler().registerInsightProvider(fieldInsightProvider);
                this.renderer = completionTextField;
                break;
            }
            case 5: 
            case 6: {
                this.renderer = new JTextField(object == null ? "NULL" : object.toString());
                ((JTextField)this.renderer).setEditable(bl);
                break;
            }
            default: {
                this.renderer = new JTextField(object == null ? "NULL" : object.toString());
                ((JTextField)this.renderer).setEditable(bl);
            }
        }
        return this.renderer;
    }

    public Object getValue() {
        if (this.renderer instanceof JTextField) {
            return ((JTextField)this.renderer).getText();
        }
        if (this.renderer instanceof JComboBox) {
            Object object = ((JComboBox)this.renderer).getSelectedItem();
            if (object != null && object.equals("NULL")) {
                object = null;
            }
            return object;
        }
        if (this.renderer instanceof JSpinner) {
            return ((JSpinner)this.renderer).getValue();
        }
        return null;
    }

    protected static JComponent getBoolean(Object object, boolean bl) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{Boolean.TRUE, Boolean.FALSE});
        if (object != null) {
            if (object instanceof Boolean) {
                jComboBox.setSelectedItem(object);
            } else {
                jComboBox.setSelectedItem(Boolean.valueOf(object.toString().toUpperCase()));
            }
        }
        jComboBox.setEditable(bl);
        return jComboBox;
    }
}

