/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.scheduler.editors.chain.ChainNodeData;
import oracle.dbtools.scheduler.editors.chain.IJGraphNode;

public class ChainNode
implements IJGraphNode {
    private LinkedList<ChainNode> children;
    private int level;
    private List<IJGraphNode> parent;
    private ChainNodeData data;

    public ChainNode(int n, List<IJGraphNode> list, ChainNodeData chainNodeData) {
        this.level = n;
        this.parent = list;
        this.data = chainNodeData;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public ChainNodeData getData() {
        return this.data;
    }

    @Override
    public List<IJGraphNode> getParent() {
        return this.parent;
    }

    @Override
    public String getComment() {
        return this.data.getRuleComments();
    }

    @Override
    public String getNodeName() {
        return this.data.getName();
    }

    @Override
    public String getNodeType() {
        return "Chain";
    }

    @Override
    public String getPublishedName() {
        return "Step";
    }

    @Override
    public String getRelationCondition() {
        return this.data.getRuleCondition();
    }

    @Override
    public String getRelationName() {
        return this.data.getRuleName();
    }

    @Override
    public String getToolTipText() {
        return "STEP NAME: " + this.data.getType() + "\n STEP TYPE: " + this.data.getType() + "\n STEP PROGRAM: " + this.data.getProgram();
    }

    @Override
    public Rectangle getSize() {
        return new Rectangle(40, 20);
    }

    @Override
    public boolean isEndRelation() {
        return this.data.getName() == "END";
    }

    @Override
    public boolean isIsolatedNode() {
        return false;
    }

    @Override
    public Rectangle getCoordinateIncrements() {
        return new Rectangle(100, 50);
    }
}

