/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scheduler.editors.chain;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.display.EditableGridInfo;
import oracle.dbtools.raptor.controls.grid.EditableGridController;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridCellUpdateInfo;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.RaptorQueryUtils;
import oracle.dbtools.scheduler.SchedulerArb;
import oracle.dbtools.scheduler.editors.chain.ChainEditor;
import oracle.dbtools.scheduler.editors.chain.ChainGraphModel;
import oracle.dbtools.scheduler.editors.chain.ChainMxKeyboardHandler;
import oracle.dbtools.scheduler.editors.chain.ChainNodeDeleteAction;
import oracle.dbtools.scheduler.editors.chain.ChainRuleCreateAction;
import oracle.dbtools.scheduler.editors.chain.ChainStepCreateAction;
import oracle.dbtools.scheduler.editors.chain.IJGraphModel;
import oracle.dbtools.scheduler.editors.chain.IJGraphViewer;
import oracle.dbtools.scheduler.editors.chain.Messages;
import oracle.dbtools.scheduler.editors.chain.RuleData;
import oracle.dbtools.scheduler.editors.chain.StepData;
import oracle.dbtools.scheduler.generator.DBMSSchedulerCodeGenerator;
import oracle.dbtools.scheduler.panels.common.repeatinterval.model.QualifiedIdentifier;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.view.View;
import oracle.javatools.db.DBException;

public class ChainGraphViewer
implements IJGraphViewer {
    public static final String CHAIN_EDITOR_IS_EDITABLE = "CHAIN_EDITOR_IS_EDITABLE";
    public static final Float CHAIN_EDITOR_MENU_SECTION_ID = Float.valueOf(11.0f);
    public static final Float CHAIN_EDITOR_TOOLBAR_SECTION_ID = Float.valueOf(10.0f);
    private String[] STEP_PROPERTIES = new String[]{"owner", "name", "step_type", "program_owner", "program_name", "event_schedule_name", "chain_name", "skip", "pause", "restart_on_recovery", "restart_on_failure"};
    static final String[] RULE_PROPERTIES = new String[]{"owner", "chain_name", "rule_owner", "rule_name", "condition", "action", "comments"};
    static IDEContextMenuListener contextMenuListener = new IDEContextMenuListener();
    private final BeginNode beginNode = new BeginNode();
    private static final String CELL_TOOL_TIP;
    private static final String ADD_END_RULE;
    private static final String DELETE;
    private static final String DETAILS;
    public static final String CREATE_START_RULE;
    public static final String CHAIN_EDIT_HELP;
    private static final URL stepURL;
    private static final URL stepProgramURL;
    private static final URL stepChainURL;
    private static final URL stepEventScheduleURL;
    private static final URL startURL;
    private static final URL endURL;
    private static final String defaultStepStyle;
    private static final String defaultProgramStepStyle;
    private static final String defaultChainStepStyle;
    private static final String defaultEventScheduleStepStyle;
    private static final String defaultStartStyle;
    private static final String defaultEndStyle;
    private String defaultEdgeStyle = "noLabel=1";
    private String stepStyleForSelection = mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";fontColor=green;fillColor=white;gradientColor=white;strokeColor=white;verticalAlign=bottom;verticalLabelPosition=bottom;fontSize=13;spacingTop=10;perimeterSpacing=10;" + mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_IMAGE_ALIGN + "=" + "center" + ";" + mxConstants.STYLE_IMAGE + "=";
    private String edgeStyleForSelection = "strokeColor=green;noLabel=1";
    private mxGraph graph;
    private mxGraphComponent graphComponent;
    private mxHierarchicalLayout jGraphXLayout;
    private mxEventSource.mxIEventListener eventListener;
    private ChainGraphModel model;
    private Map<StepData, Object> guiFromNodeMap;
    private Map<Object, StepData> nodefromGuiMap;
    private Map<Object, RuleData> ruleFromGuiMap;
    private Map<String, EndNode> endStepMap;
    private JSplitPane mainPanel;
    private JPanel editPanel;
    private JToolBar editToolBar = null;
    private Action dropAction = new DropAction();
    private EditableResultSetTable editableTable;
    private EditableResultSetTable editableTable1;
    private JScrollPane editableTableScroll;
    private String connName;
    private DBObject object;
    private int xIncr;
    private int yIncr;
    private int Xstart;
    private int Ystart;
    private int Xsize;
    private int Ysize;
    private double dividerLocationDouble = 0.5;
    private View parentView;
    private ChainEditor mainEditorInstance;

    public ChainGraphViewer(ChainGraphModel chainGraphModel, DBObject dBObject, View view, ChainEditor chainEditor) {
        mxConstants.DEFAULT_HOTSPOT = 0.5;
        mxConstants.MIN_HOTSPOT_SIZE = 16;
        this.graph = new mxGraph(){

            public String getToolTipForCell(Object object) {
                return CELL_TOOL_TIP;
            }
        };
        this.jGraphXLayout = new mxHierarchicalLayout(this.graph, 7);
        this.mainEditorInstance = chainEditor;
        this.graph.setAllowDanglingEdges(false);
        this.graph.setCellsLocked(false);
        this.graph.setCellsSelectable(true);
        this.graph.setCellsMovable(false);
        this.graph.setCellsEditable(false);
        this.graphComponent = new mxGraphComponent(this.graph);
        new ChainMxKeyboardHandler(this, this.graphComponent);
        this.graphComponent.getViewport().setOpaque(false);
        this.graphComponent.setBackground(Color.WHITE);
        this.graphComponent.setToolTips(true);
        this.model = chainGraphModel;
        this.parentView = view;
        this.connName = dBObject.getConnectionName();
        this.object = dBObject;
        this.editableTableScroll = new JScrollPane();
        this.mainPanel = new JSplitPane(0);
        this.graphComponent.setHorizontalScrollBarPolicy(30);
        this.graphComponent.setVerticalScrollBarPolicy(20);
        this.mainPanel.setTopComponent((Component)this.graphComponent);
        this.mainPanel.setOneTouchExpandable(true);
        this.mainPanel.setResizeWeight(0.5);
        this.addMouseClickHandler();
    }

    @Override
    public JComponent getGui() {
        this.graphComponent.setDragEnabled(false);
        return this.mainPanel;
    }

    public boolean setTopology(int n, int n2) {
        Map<String, StepData> map = this.model.getStepDataMap();
        if (map.isEmpty()) {
            return false;
        }
        this.xIncr = n;
        this.yIncr = n2;
        this.Xstart = 60;
        this.Ystart = 40;
        this.Xsize = 32;
        this.Ysize = 32;
        return this.setTopology();
    }

    @Override
    public boolean setTopology(DBObject dBObject) {
        this.object = dBObject;
        this.connName = dBObject.getConnectionName();
        Map<String, StepData> map = this.model.getStepDataMap();
        if (map.isEmpty()) {
            return false;
        }
        this.xIncr = 64;
        this.yIncr = 64;
        this.Xstart = 60;
        this.Ystart = 40;
        this.Xsize = 32;
        this.Ysize = 32;
        return this.setTopology();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTopology() {
        this.removeCells();
        this.removeListeners();
        this.clearTables();
        if (this.guiFromNodeMap != null) {
            this.guiFromNodeMap.clear();
        } else {
            this.guiFromNodeMap = new HashMap<StepData, Object>();
        }
        if (this.nodefromGuiMap != null) {
            this.nodefromGuiMap.clear();
        } else {
            this.nodefromGuiMap = new HashMap<Object, StepData>();
        }
        if (this.ruleFromGuiMap != null) {
            this.ruleFromGuiMap.clear();
        } else {
            this.ruleFromGuiMap = new HashMap<Object, RuleData>();
        }
        if (this.endStepMap != null) {
            this.endStepMap.clear();
        } else {
            this.endStepMap = new HashMap<String, EndNode>();
        }
        this.graph.getModel().beginUpdate();
        Object object = this.graph.getDefaultParent();
        this.createBeginNode(object, 32, 128, 32, 32);
        Map<String, StepData> map = this.model.getStepDataMap();
        List<RuleData> list = this.model.getRuleDataList();
        int n = 10;
        int n2 = 10;
        try {
            List<StepData> list2;
            for (String object2 : map.keySet()) {
                list2 = map.get(object2);
                this.insertNode(object, (StepData)((Object)list2), n += 32, n2 += 32, this.Xsize, this.Ysize);
            }
            for (RuleData ruleData : list) {
                if (ruleData == null) continue;
                list2 = this.model.getStepForRule(ruleData);
                if (list2.size() == 0) {
                    Object object2 = ruleData.getRuleAction();
                    StepData stepData = this.endStepMap.get(object2 = ((String)object2).trim());
                    if (stepData == null) {
                        stepData = new EndNode((String)object2);
                        this.endStepMap.put((String)object2, (EndNode)stepData);
                        this.insertEndNode(object, stepData, n += 32, n2 += 32, this.Xsize, this.Ysize);
                    }
                    list2 = new Vector<StepData>();
                    list2.add(stepData);
                }
                for (StepData stepData : list2) {
                    if (ruleData.isStartRule()) {
                        if (stepData == null) continue;
                        this.createEdge(object, this.beginNode, ruleData, stepData);
                        continue;
                    }
                    List<String> list3 = ruleData.getRuleConditionList();
                    for (String string : list3) {
                        StepData stepData2 = map.get(string);
                        if (stepData2 == null) continue;
                        this.createEdge(object, stepData2, ruleData, stepData);
                    }
                }
            }
        }
        finally {
            this.graph.getModel().endUpdate();
        }
        this.layout();
        this.addListeners();
        return true;
    }

    private void addListeners() {
        this.eventListener = new mxEventSource.mxIEventListener(){

            public void invoke(Object object, mxEventObject mxEventObject2) {
                if (!new Boolean(mxEventObject2.getProperties().get("source").toString()).booleanValue()) {
                    mxCell mxCell2 = (mxCell)mxEventObject2.getProperties().get("edge");
                    mxICell mxICell2 = mxCell2.getSource();
                    mxICell mxICell3 = mxCell2.getTarget();
                    StepData stepData = (StepData)ChainGraphViewer.this.nodefromGuiMap.get(mxICell2);
                    String string = "";
                    boolean bl = false;
                    if (stepData instanceof BeginNode) {
                        bl = true;
                    }
                    if (stepData instanceof EndNode) {
                        ChainGraphViewer.this.mainEditorInstance.updateContent(true);
                        return;
                    }
                    string = mxICell2.getValue().toString();
                    StepData stepData2 = (StepData)ChainGraphViewer.this.nodefromGuiMap.get(mxICell3);
                    String string2 = "";
                    boolean bl2 = false;
                    if (stepData2 instanceof BeginNode) {
                        ChainGraphViewer.this.mainEditorInstance.updateContent(true);
                        return;
                    }
                    if (stepData2 instanceof EndNode) {
                        bl2 = true;
                    }
                    string2 = mxICell3.getValue().toString();
                    String string3 = ChainGraphViewer.this.object.getObjectName();
                    ChainRuleCreateAction chainRuleCreateAction = new ChainRuleCreateAction();
                    chainRuleCreateAction.setDBObject(ChainGraphViewer.this.object);
                    chainRuleCreateAction.setChainName(string3);
                    chainRuleCreateAction.setSourceStep(string);
                    chainRuleCreateAction.setTargetStep(string2);
                    chainRuleCreateAction.setIsStartRule(bl);
                    chainRuleCreateAction.setIsEndRule(bl2);
                    chainRuleCreateAction.launch();
                    ChainGraphViewer.this.mainEditorInstance.updateContent(true);
                }
                System.out.println(mxEventObject2.getProperties());
            }
        };
        this.graph.addListener("cellConnected", this.eventListener);
    }

    private void removeListeners() {
        if (this.eventListener != null) {
            this.graph.removeListener(this.eventListener);
        }
    }

    private void removeCells() {
        Object[] objectArray = this.graph.getChildCells(this.graph.getDefaultParent());
        this.graph.removeCells(objectArray);
    }

    private void clearTables() {
        if (this.editableTable != null) {
            this.editableTable.closeModel();
        }
        this.mainPanel.remove(this.editableTableScroll);
    }

    private void addMouseClickHandler() {
        this.graphComponent.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public boolean checkPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Object object = ChainGraphViewer.this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                    ChainEditorAreaMenu chainEditorAreaMenu = new ChainEditorAreaMenu(object);
                    chainEditorAreaMenu.show((Component)ChainGraphViewer.this.graphComponent, mouseEvent.getX(), mouseEvent.getY());
                    return true;
                }
                return false;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.checkPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                block3: {
                    Object object;
                    block4: {
                        block5: {
                            if (this.checkPopup(mouseEvent)) break block3;
                            object = ChainGraphViewer.this.graphComponent.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                            if (object == null || mouseEvent.getButton() != 1 || mouseEvent.getClickCount() != 2) break block4;
                            if (!ChainGraphViewer.this.graph.getModel().isVertex(object)) break block5;
                            ChainGraphViewer.this.createStepTable((StepData)ChainGraphViewer.this.nodefromGuiMap.get(object), object);
                            break block3;
                        }
                        if (!ChainGraphViewer.this.graph.getModel().isEdge(object)) break block3;
                        ChainGraphViewer.this.createRuleTable((RuleData)ChainGraphViewer.this.ruleFromGuiMap.get(object), object);
                        break block3;
                    }
                    if (object == null && mouseEvent.getButton() == 1) {
                        ChainGraphViewer.this.clearTables();
                        Object[] objectArray = ChainGraphViewer.this.graphComponent.getCells(ChainGraphViewer.this.graphComponent.getViewportBorderBounds());
                        for (Object object2 : Arrays.asList(objectArray)) {
                            if (ChainGraphViewer.this.graph.getModel().isVertex(object2)) {
                                StepData stepData = (StepData)ChainGraphViewer.this.nodefromGuiMap.get(object2);
                                String string = ChainGraphViewer.this.getNodeStyle(stepData);
                                ChainGraphViewer.this.graph.getModel().setStyle(object2, string);
                            }
                            if (!ChainGraphViewer.this.graph.getModel().isEdge(object2)) continue;
                            ChainGraphViewer.this.graph.getModel().setStyle(object2, ChainGraphViewer.this.defaultEdgeStyle);
                        }
                    }
                }
            }
        });
    }

    protected String getNodeStyle(StepData stepData) {
        String string = defaultStepStyle;
        if (stepData instanceof BeginNode) {
            string = defaultStartStyle;
        } else if (stepData instanceof EndNode) {
            string = defaultEndStyle;
        } else if (stepData.getType().equals("PROGRAM")) {
            string = defaultProgramStepStyle;
        } else if (stepData.getType().equals("SUBCHAIN")) {
            string = defaultChainStepStyle;
        } else if (stepData.getType().equals("EVENT_SCHEDULE")) {
            string = defaultEventScheduleStepStyle;
        }
        return string;
    }

    protected String getSelectedNodeStyle(StepData stepData) {
        String string = this.stepStyleForSelection;
        if (stepData instanceof BeginNode) {
            string = string + startURL.toString();
        } else if (stepData instanceof EndNode) {
            string = string + endURL.toString();
        } else if (stepData.getType().equals("PROGRAM")) {
            string = string + stepProgramURL.toString();
        } else if (stepData.getType().equals("SUBCHAIN")) {
            string = string + stepChainURL.toString();
        } else if (stepData.getType().equals("EVENT_SCHEDULE")) {
            string = string + stepEventScheduleURL.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createRuleTable(RuleData ruleData, Object object) {
        String string;
        StepData stepData;
        Object[] objectArray;
        final Toolbar toolbar = new Toolbar();
        this.editableTable = new EditableResultSetTable(new IActionUpdater(){

            public void updateActions() {
                View.updateToolbarActions((Toolbar)toolbar);
            }
        });
        EditableGridController editableGridController = this.editableTable.getController();
        editableGridController.setView(this.parentView);
        if (toolbar.getActions() == null || toolbar.getActions().length < 3) {
            editableGridController.addToToolbar(editableGridController.getRefreshAction(), toolbar);
            editableGridController.addToToolbar(editableGridController.getRollbackAction(), toolbar);
            editableGridController.addToToolbar(editableGridController.getCommitAction(), toolbar);
            View.updateToolbarActions((Toolbar)toolbar);
        }
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new BorderLayout());
        this.editableTable.setView(this.parentView);
        this.editableTable.setInsertAllowed(false);
        this.editableTable.setDeleteAllowed(false);
        this.editableTable.setFilterFieldAllowed(false);
        this.editableTable.setEditable(true);
        this.editableTable.setRefreshAllowed(true);
        this.editableTable.canSortColumns(false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER_NAME", this.object.getSchemaName());
        hashMap.put("CHAIN_NAME", this.object.getObjectName());
        hashMap.put("RULE_NAME", ruleData.getRuleName());
        hashMap.put("NO_DATA_INTEGRITY_COLS", "NO_DATA_INTEGRITY_COLS");
        this.editableTable.setQuery(this.connName, this.createSqlForRule(), null, hashMap, null, null, null);
        this.editableTable.registerGridUpdater((IRaptorGridUpdater)new ChainGraphRuleRaptorGridUpdater(this.object.getSchemaName(), this.object.getObjectName(), ruleData.getRuleName(), this.editableTable.getController().getCommitAction(), this.editableTable.getController().getRollbackAction()));
        TableModel tableModel = this.editableTable.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            objectArray = (Object[])tableModel;
            Vector<Column> vector = new Vector<Column>();
            Column object2 = new Column();
            object2.setName("NAME");
            object2.setEditable(false);
            vector.add(object2);
            Column column = new Column();
            column.setName("VALUE");
            column.setEditable(true);
            column.setCellRenderer("oracle.dbtools.scheduler.editors.chain.ChainRuleCellRenderer");
            column.setCellEditor("oracle.dbtools.scheduler.editors.chain.ChainRuleCellEditor");
            column.setClassLoader(this.getClass().getClassLoader());
            vector.add(column);
            Column column2 = new Column();
            column2.setName("POPUP_TEXT");
            column2.setHidden(true);
            vector.add(column2);
            stepData = new Query();
            stepData.setCols(vector);
            stepData.setSql(this.createSqlForRule());
            string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            string = new Bind("CHAIN_NAME", null, null, this.object.getObjectName(), null);
            arrayList.add(string);
            string = new Bind("RULE_NAME", null, null, ruleData.getRuleName(), null);
            arrayList.add(string);
            stepData.setBinds(arrayList);
            stepData.setSkipCols(new ArrayList());
            objectArray.setTableName(new QualifiedIdentifier(this.object.getSchemaName()).getId() + "." + new QualifiedIdentifier(this.object.getObjectName()).getId() + "." + new QualifiedIdentifier(ruleData.getRuleName()).getId());
            objectArray.setQueryObject((Query)stepData);
        }
        try {
            this.editableTable.open(new RaptorEditableGridTaskWrapper(Messages.getString("ChainGraphViewer.1"), IRaptorTaskRunMode.IDE_STATUSBAR, false, null, null, null, null));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.editableTableScroll.setViewportView((Component)this.editableTable);
        this.editPanel.add((Component)toolbar, "North");
        this.editPanel.add((Component)this.editableTableScroll, "Center");
        this.mainPanel.setBottomComponent(this.editPanel);
        this.graph.getModel().beginUpdate();
        try {
            objectArray = this.graphComponent.getCells(this.graphComponent.getViewportBorderBounds());
            for (Object e : Arrays.asList(objectArray)) {
                if (this.graph.getModel().isVertex(e)) {
                    stepData = this.nodefromGuiMap.get(e);
                    string = this.getNodeStyle(stepData);
                    this.graph.getModel().setStyle(e, string);
                }
                if (!this.graph.getModel().isEdge(e)) continue;
                this.graph.getModel().setStyle(e, this.defaultEdgeStyle);
            }
            this.graph.getModel().setStyle(object, this.edgeStyleForSelection);
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    private String createSqlForRule() {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string = this.object.getDBVersion();
        String string2 = dBMSSchedulerCodeGenerator.generate(string, "SELECT_RULE", null);
        return RaptorQueryUtils.promoteToDba((String)string2, (Connection)this.object.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createStepTable(StepData stepData, Object object) {
        String string;
        StepData stepData2;
        Object[] objectArray;
        if (stepData == null || stepData instanceof BeginNode || stepData instanceof EndNode) {
            return;
        }
        final Toolbar toolbar = new Toolbar();
        this.editableTable = new EditableResultSetTable(new IActionUpdater(){

            public void updateActions() {
                View.updateToolbarActions((Toolbar)toolbar);
            }
        });
        EditableGridController editableGridController = this.editableTable.getController();
        editableGridController.setView(this.parentView);
        if (toolbar.getActions() == null || toolbar.getActions().length < 3) {
            editableGridController.addToToolbar(editableGridController.getRefreshAction(), toolbar);
            editableGridController.addToToolbar(editableGridController.getRollbackAction(), toolbar);
            editableGridController.addToToolbar(editableGridController.getCommitAction(), toolbar);
            View.updateToolbarActions((Toolbar)toolbar);
        }
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new BorderLayout());
        this.editableTable.setView(this.parentView);
        this.editableTable.setInsertAllowed(false);
        this.editableTable.setDeleteAllowed(false);
        this.editableTable.setFilterFieldAllowed(false);
        this.editableTable.setEditable(true);
        this.editableTable.setRefreshAllowed(true);
        this.editableTable.canSortColumns(false);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("OWNER_NAME", this.object.getSchemaName());
        hashMap.put("CHAIN_NAME", this.object.getObjectName());
        hashMap.put("STEP_NAME", stepData.getName());
        hashMap.put("NO_DATA_INTEGRITY_COLS", "NO_DATA_INTEGRITY_COLS");
        this.editableTable.setQuery(this.connName, this.createSqlForStep(), null, hashMap, null, Arrays.asList("NAME"), Arrays.asList("VALUE"));
        this.editableTable.registerGridUpdater((IRaptorGridUpdater)new ChainGraphStepRaptorGridUpdater(this.object.getSchemaName(), this.object.getObjectName(), stepData.getName(), this.editableTable.getController().getCommitAction(), this.editableTable.getController().getRollbackAction()));
        TableModel tableModel = this.editableTable.getModel();
        if (tableModel instanceof EditableResultSetTableModel) {
            objectArray = (Object[])tableModel;
            Vector<Column> vector = new Vector<Column>();
            Column object2 = new Column();
            object2.setName("NAME");
            object2.setEditable(false);
            vector.add(object2);
            Column column = new Column();
            column.setName("VALUE");
            column.setEditable(true);
            column.setCellRenderer("oracle.dbtools.scheduler.editors.chain.ChainStepCellRenderer");
            column.setCellEditor("oracle.dbtools.scheduler.editors.chain.ChainStepCellEditor");
            column.setClassLoader(this.getClass().getClassLoader());
            vector.add(column);
            Column column2 = new Column();
            column2.setName("POPUP_TEXT");
            column2.setHidden(true);
            vector.add(column2);
            stepData2 = new Query();
            stepData2.setCols(vector);
            stepData2.setSql(this.createSqlForStep());
            string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            string = new Bind("CHAIN_NAME", null, null, this.object.getObjectName(), null);
            arrayList.add(string);
            string = new Bind("STEP_NAME", null, null, stepData.getName(), null);
            arrayList.add(string);
            stepData2.setBinds(arrayList);
            stepData2.setSkipCols(new ArrayList());
            objectArray.setTableName(new QualifiedIdentifier(this.object.getSchemaName()).getId() + "." + new QualifiedIdentifier(this.object.getObjectName()).getId() + "." + new QualifiedIdentifier(stepData.getName()).getId());
            objectArray.setQueryObject((Query)stepData2);
        }
        try {
            this.editableTable.open(new RaptorEditableGridTaskWrapper(Messages.getString("ChainGraphViewer.2"), IRaptorTaskRunMode.IDE_STATUSBAR, false, null, null, null, null));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        this.editableTableScroll.setViewportView((Component)this.editableTable);
        this.editPanel.add((Component)toolbar, "North");
        this.editPanel.add((Component)this.editableTableScroll, "Center");
        this.mainPanel.setBottomComponent(this.editPanel);
        this.mainPanel.setDividerLocation(this.dividerLocationDouble);
        this.graph.getModel().beginUpdate();
        try {
            objectArray = this.graphComponent.getCells(this.graphComponent.getViewportBorderBounds());
            for (Object e : Arrays.asList(objectArray)) {
                if (this.graph.getModel().isVertex(e)) {
                    stepData2 = this.nodefromGuiMap.get(e);
                    string = this.getNodeStyle(stepData2);
                    this.graph.getModel().setStyle(e, string);
                }
                if (!this.graph.getModel().isEdge(e)) continue;
                this.graph.getModel().setStyle(e, this.defaultEdgeStyle);
            }
            this.graph.getModel().setStyle(object, this.getSelectedNodeStyle(stepData));
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    private String createSqlForStep() {
        DBMSSchedulerCodeGenerator dBMSSchedulerCodeGenerator = DBMSSchedulerCodeGenerator.getInstance();
        String string = this.object.getDBVersion();
        String string2 = dBMSSchedulerCodeGenerator.generate(string, "SELECT_STEP", null);
        return RaptorQueryUtils.promoteToDba((String)string2, (Connection)this.object.getConnection());
    }

    private void insertNode(Object object, StepData stepData, int n, int n2, int n3, int n4) {
        Object object2 = this.graph.insertVertex(object, null, (Object)stepData.getName(), (double)n, (double)n2, (double)n3, (double)n4, this.getNodeStyle(stepData));
        this.guiFromNodeMap.put(stepData, object2);
        this.nodefromGuiMap.put(object2, stepData);
    }

    private void insertEndNode(Object object, StepData stepData, int n, int n2, int n3, int n4) {
        Object object2 = this.graph.insertVertex(object, null, (Object)stepData.getName(), (double)n, (double)n2, (double)n3, (double)n4, defaultEndStyle);
        this.guiFromNodeMap.put(stepData, object2);
        this.nodefromGuiMap.put(object2, stepData);
    }

    private void createEdge(Object object, StepData stepData, RuleData ruleData, StepData stepData2) {
        Object object2 = this.guiFromNodeMap.get(stepData2);
        Object object3 = this.guiFromNodeMap.get(stepData);
        Object object4 = this.graph.insertEdge(object, null, (Object)ruleData, object3, object2, this.defaultEdgeStyle);
        this.nodefromGuiMap.put(object4, stepData2);
        this.ruleFromGuiMap.put(object4, ruleData);
    }

    private void createBeginNode(Object object, int n, int n2, int n3, int n4) {
        Object object2 = this.graph.insertVertex(object, null, (Object)"BEGIN", (double)n, (double)n2, (double)n3, (double)n4, defaultStartStyle);
        this.guiFromNodeMap.put(this.beginNode, object2);
        this.nodefromGuiMap.put(object2, this.beginNode);
    }

    public void layout() {
        try {
            this.jGraphXLayout.setInterHierarchySpacing(40.0);
            this.jGraphXLayout.setInterRankCellSpacing(35.0);
            this.jGraphXLayout.execute(this.graph.getDefaultParent(), this.findTreeRoots(this.graph.getDefaultParent(), false, false));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public List<Object> findTreeRoots(Object object, boolean bl, boolean bl2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object != null) {
            int n = this.graph.getModel().getChildCount(object);
            Object object2 = null;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3;
                Object object3 = this.graph.getModel().getChildAt(object, i);
                if (!this.graph.getModel().isVertex(object3) || !this.graph.isCellVisible(object3)) continue;
                Object[] objectArray = this.graph.getConnections(object3, bl ? object : null);
                int n4 = 0;
                int n5 = 0;
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    Object object4 = this.graph.getView().getVisibleTerminal(objectArray[n3], true);
                    if (object4 == object3) {
                        ++n4;
                        continue;
                    }
                    ++n5;
                }
                if (bl2 && n4 == 0 || !bl2 && n5 == 0) {
                    arrayList.add(object3);
                }
                int n6 = n3 = bl2 ? n5 - n4 : n4 - n5;
                if (n3 <= n2) continue;
                n2 = n3;
                object2 = object3;
            }
            if (arrayList.isEmpty() && object2 != null) {
                arrayList.add(object2);
            }
        }
        return arrayList;
    }

    @Override
    public mxGraph getGraph() {
        return this.graph;
    }

    @Override
    public IJGraphModel getGraphModel() {
        return this.model;
    }

    public StepData getNodefromGuiMap(Object object) {
        StepData stepData = null;
        if (this.nodefromGuiMap != null) {
            stepData = this.nodefromGuiMap.get(object);
        }
        return stepData;
    }

    public RuleData getRuleFromGuiMap(Object object) {
        RuleData ruleData = null;
        if (this.ruleFromGuiMap != null) {
            ruleData = this.ruleFromGuiMap.get(object);
        }
        return ruleData;
    }

    public Action getDropAction() {
        return this.dropAction;
    }

    public boolean isEditable() {
        return this.mainEditorInstance.isEditable();
    }

    @Override
    public void clear() {
        this.removeCells();
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    static /* synthetic */ String[] access$1300(ChainGraphViewer chainGraphViewer) {
        return chainGraphViewer.STEP_PROPERTIES;
    }

    static {
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)contextMenuListener);
        CELL_TOOL_TIP = Messages.getString("ChainGraphViewer.7");
        ADD_END_RULE = Messages.getString("ChainGraphViewer.6");
        DELETE = Messages.getString("ChainGraphViewer.0");
        DETAILS = Messages.getString("ChainGraphViewer.3");
        CREATE_START_RULE = Messages.getString("ChainGraphViewer.4");
        CHAIN_EDIT_HELP = Messages.getString("ChainGraphViewer.5");
        stepURL = ChainGraphViewer.class.getResource("/oracle/dbtools/scheduler/images/chain_step_lg.png");
        stepProgramURL = ChainGraphViewer.class.getResource("/oracle/dbtools/scheduler/images/program_lg.png");
        stepChainURL = ChainGraphViewer.class.getResource("/oracle/dbtools/scheduler/images/sched_chain_lg.png");
        stepEventScheduleURL = ChainGraphViewer.class.getResource("/oracle/dbtools/scheduler/images/schedule_lg.png");
        startURL = ChainGraphViewer.class.getResource("/oracle/dbtools/scheduler/images/chain_start_lg.png");
        endURL = ChainGraphViewer.class.getResource("/oracle/dbtools/scheduler/images/chain_end_lg.png");
        defaultStepStyle = mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";fillColor=white;gradientColor=white;strokeColor=white;verticalAlign=bottom;verticalLabelPosition=bottom;fontSize=13;spacingTop=10;perimeterSpacing=10;" + mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_IMAGE_ALIGN + "=" + "center" + ";" + mxConstants.STYLE_IMAGE + "=" + stepURL.toString();
        defaultProgramStepStyle = mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";fillColor=white;gradientColor=white;strokeColor=white;verticalAlign=bottom;verticalLabelPosition=bottom;fontSize=13;spacingTop=10;perimeterSpacing=10;" + mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_IMAGE_ALIGN + "=" + "center" + ";" + mxConstants.STYLE_IMAGE + "=" + stepProgramURL.toString();
        defaultChainStepStyle = mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";fillColor=white;gradientColor=white;strokeColor=white;verticalAlign=bottom;verticalLabelPosition=bottom;fontSize=13;spacingTop=10;perimeterSpacing=10;" + mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_IMAGE_ALIGN + "=" + "center" + ";" + mxConstants.STYLE_IMAGE + "=" + stepChainURL.toString();
        defaultEventScheduleStepStyle = mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";fillColor=white;gradientColor=white;strokeColor=white;verticalAlign=bottom;verticalLabelPosition=bottom;fontSize=13;spacingTop=10;perimeterSpacing=10;" + mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_IMAGE_ALIGN + "=" + "center" + ";" + mxConstants.STYLE_IMAGE + "=" + stepEventScheduleURL.toString();
        defaultStartStyle = mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";fillColor=white;gradientColor=white;strokeColor=white;verticalAlign=bottom;verticalLabelPosition=bottom;fontSize=13;spacingTop=10;perimeterSpacing=10;" + mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_IMAGE_ALIGN + "=" + "center" + ";" + mxConstants.STYLE_IMAGE + "=" + startURL.toString();
        defaultEndStyle = mxConstants.STYLE_SHAPE + "=" + mxConstants.STYLE_IMAGE + ";fillColor=white;gradientColor=white;strokeColor=white;verticalAlign=bottom;verticalLabelPosition=bottom;fontSize=13;spacingTop=10;perimeterSpacing=10;" + mxConstants.STYLE_VERTICAL_LABEL_POSITION + "=" + "bottom" + ";" + mxConstants.STYLE_IMAGE_ALIGN + "=" + "center" + ";" + mxConstants.STYLE_IMAGE + "=" + endURL.toString();
    }

    private class DropAction
    extends AbstractAction {
        public DropAction() {
            super(StringUtils.stripMnemonic((String)DELETE));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            if (ChainGraphViewer.this.graph != null && (objectArray = ChainGraphViewer.this.graph.getSelectionCells()) != null && objectArray.length == 1) {
                Object object = objectArray[0];
                String string = ChainGraphViewer.this.object.getObjectName();
                ChainNodeDeleteAction chainNodeDeleteAction = new ChainNodeDeleteAction();
                chainNodeDeleteAction.setDBObject(ChainGraphViewer.this.object);
                chainNodeDeleteAction.setChainName(string);
                if (ChainGraphViewer.this.graph.getModel().isVertex(object)) {
                    chainNodeDeleteAction.setIsRule(false);
                    chainNodeDeleteAction.setObjectName(((StepData)ChainGraphViewer.this.nodefromGuiMap.get(object)).getName());
                } else if (ChainGraphViewer.this.graph.getModel().isEdge(object)) {
                    chainNodeDeleteAction.setIsRule(true);
                    chainNodeDeleteAction.setObjectName(((RuleData)ChainGraphViewer.this.ruleFromGuiMap.get(object)).getRuleName());
                }
                chainNodeDeleteAction.launch();
                ChainGraphViewer.this.mainEditorInstance.updateContent(true);
            }
        }
    }

    private class ChainGraphRuleRaptorGridUpdater
    implements IRaptorGridUpdater {
        String owner;
        String chain_name;
        String rule_name;
        IdeAction commitAction;
        IdeAction rollbackAction;

        public ChainGraphRuleRaptorGridUpdater(String string, String string2, String string3, IdeAction ideAction, IdeAction ideAction2) {
            this.owner = string;
            this.chain_name = string2;
            this.rule_name = string3;
            this.commitAction = ideAction;
            this.rollbackAction = ideAction2;
        }

        public int insertRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        /*
         * Exception decompiling
         */
        public int updateRows(String var1_1, List<RaptorGridRowModel> var2_2, IRaptorTaskProgressUpdater var3_3, List<String> var4_4) throws SQLException, DBException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
            return null;
        }

        public void setGridInfo(EditableGridInfo editableGridInfo) {
        }
    }

    private class ChainGraphStepRaptorGridUpdater
    implements IRaptorGridUpdater {
        String owner;
        String chain_name;
        String step_name;
        IdeAction commitAction;
        IdeAction rollbackAction;

        public ChainGraphStepRaptorGridUpdater(String string, String string2, String string3, IdeAction ideAction, IdeAction ideAction2) {
            this.owner = string;
            this.chain_name = string2;
            this.step_name = string3;
            this.commitAction = ideAction;
            this.rollbackAction = ideAction2;
        }

        public int insertRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        public int deleteRows(String string, List<RaptorGridRowModel> list, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, List<String> list2) throws SQLException, DBException, ExecutionException {
            return 0;
        }

        /*
         * Exception decompiling
         */
        public int updateRows(String var1_1, List<RaptorGridRowModel> var2_2, IRaptorTaskProgressUpdater var3_3, List<String> var4_4) throws SQLException, DBException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public GridCellUpdateInfo cellUpdated(String string, RaptorGridRowModel raptorGridRowModel, int n, int n2, Object object) {
            return null;
        }

        public void setGridInfo(EditableGridInfo editableGridInfo) {
        }
    }

    private static class ChainGraphActionUpdater
    implements IActionUpdater {
        EditableResultSetTable editableTable = null;
        IdeAction refreshAction;
        IdeAction commitAction;
        IdeAction rollbackAction;

        public ChainGraphActionUpdater(IdeAction ideAction, IdeAction ideAction2, IdeAction ideAction3) {
            this.refreshAction = ideAction;
            this.commitAction = ideAction2;
            this.rollbackAction = ideAction3;
        }

        public void updateActions() {
            this.refreshAction.setEnabled(true);
            this.commitAction.setEnabled(this.editableTable == null ? false : this.editableTable.isChanged());
            this.rollbackAction.setEnabled(this.editableTable == null ? false : this.editableTable.isChanged());
        }

        public void setEditableTable(EditableResultSetTable editableResultSetTable) {
            this.editableTable = editableResultSetTable;
        }
    }

    private static class IDEContextMenuListener
    implements ContextMenuListener {
        private IDEContextMenuListener() {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Object object = contextMenu.getContext().getProperty("Context.VIEW");
            if (object != null && object instanceof ChainEditor) {
                Float f = CHAIN_EDITOR_TOOLBAR_SECTION_ID;
                ChainEditor chainEditor = (ChainEditor)((Object)object);
                ChainGraphViewer chainGraphViewer = chainEditor.getChainGraphViewer();
                if (chainGraphViewer != null) {
                    Object object2;
                    Toolbar toolbar;
                    try {
                        toolbar = chainEditor.getToolbar();
                        if (toolbar != null && toolbar.getActions() != null && toolbar.getActions().length > 0) {
                            object2 = toolbar.getActions();
                            for (int i = ((Action[])object2).length - 1; i >= 0; --i) {
                                Object object3 = object2[i];
                                JMenuItem jMenuItem = new JMenuItem((Action)object3);
                                jMenuItem.putClientProperty("menu-section-id", f);
                                contextMenu.add((Component)jMenuItem);
                            }
                            contextMenu.addSeparator();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        f = CHAIN_EDITOR_MENU_SECTION_ID;
                        toolbar = null;
                        ChainGraphViewer chainGraphViewer2 = chainGraphViewer;
                        chainGraphViewer2.getClass();
                        object2 = chainGraphViewer2.new ChainEditorAreaMenu(toolbar);
                        Vector<Action> vector = new Vector<Action>();
                        for (Component component : ((Container)object2).getComponents()) {
                            if (component instanceof JMenuItem) {
                                Action action = ((JMenuItem)component).getAction();
                                vector.add(action);
                                continue;
                            }
                            if (!(component instanceof JSeparator)) continue;
                            vector.add(null);
                        }
                        if (vector.size() > 0) {
                            boolean bl = false;
                            for (Action action : vector) {
                                boolean bl2;
                                Component component;
                                if (action == null) {
                                    if (!bl2) continue;
                                    contextMenu.addSeparator();
                                    f = Float.valueOf(f.floatValue() + 1.0f);
                                    bl2 = false;
                                    continue;
                                }
                                component = new JMenuItem(action);
                                ((JComponent)component).putClientProperty("menu-section-id", f);
                                contextMenu.add(component);
                                bl2 = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class BeginNode
    extends StepData {
        public BeginNode() {
            super("BEGIN", "", "", "BEGIN", "", "", "", "FALSE", "FALSE", "");
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class EndNode
    extends StepData {
        public EndNode(String string) {
            super(string == null ? "END 0" : string, "", "", "END", "", "", "", "FALSE", "FALSE", "");
        }

        public String toString() {
            return this.getName();
        }
    }

    public class ChainEditorAreaMenu
    extends JPopupMenu {
        public ChainEditorAreaMenu(final Object object) {
            this.add((Action)((ChainGraphViewer)ChainGraphViewer.this).mainEditorInstance._editAction);
            if (ChainGraphViewer.this.mainEditorInstance.isEditable()) {
                this.addSeparator();
                if (object == null) {
                    AbstractAction abstractAction = new AbstractAction(StringUtils.stripMnemonic((String)SchedulerArb.getString("CHAIN_CREATE_CHAIN_STEP")), new ImageIcon(ChainGraphViewer.class.getResource(SchedulerArb.getString("CHAIN_CREATE_CHAIN_STEP_ICON")))){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = ChainGraphViewer.this.object.getObjectName();
                            ChainStepCreateAction chainStepCreateAction = new ChainStepCreateAction();
                            chainStepCreateAction.setDBObject(ChainGraphViewer.this.object);
                            chainStepCreateAction.setChainName(string);
                            chainStepCreateAction.setStepType("PROGRAM");
                            chainStepCreateAction.launch();
                            ChainGraphViewer.this.mainEditorInstance.updateContent(true);
                        }
                    };
                    JMenuItem jMenuItem = new JMenuItem(abstractAction);
                    this.add(jMenuItem);
                    jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)SchedulerArb.getString("CHAIN_CREATE_CHAIN_STEP")));
                    abstractAction = new AbstractAction(StringUtils.stripMnemonic((String)CREATE_START_RULE), new ImageIcon(ChainGraphViewer.class.getResource(SchedulerArb.getString("CHAIN_ADD_RULE_ICON")))){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = ChainGraphViewer.this.object.getObjectName();
                            ChainStepCreateAction chainStepCreateAction = new ChainStepCreateAction();
                            chainStepCreateAction.setDBObject(ChainGraphViewer.this.object);
                            chainStepCreateAction.setChainName(string);
                            ChainRuleCreateAction chainRuleCreateAction = new ChainRuleCreateAction();
                            chainRuleCreateAction.setDBObject(ChainGraphViewer.this.object);
                            chainRuleCreateAction.setChainName(string);
                            chainRuleCreateAction.setSourceStep(null);
                            chainRuleCreateAction.setTargetStep(null);
                            chainRuleCreateAction.setIsStartRule(false);
                            chainRuleCreateAction.setIsEndRule(false);
                            chainRuleCreateAction.launch();
                            ChainGraphViewer.this.mainEditorInstance.updateContent(true);
                        }
                    };
                    jMenuItem = new JMenuItem(abstractAction);
                    this.add(jMenuItem);
                    jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)CREATE_START_RULE));
                } else {
                    JMenuItem jMenuItem;
                    AbstractAction abstractAction;
                    if (ChainGraphViewer.this.graph.getModel().isVertex(object)) {
                        abstractAction = new AbstractAction(StringUtils.stripMnemonic((String)ADD_END_RULE)){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                String string = ChainGraphViewer.this.object.getObjectName();
                                ChainRuleCreateAction chainRuleCreateAction = new ChainRuleCreateAction();
                                chainRuleCreateAction.setDBObject(ChainGraphViewer.this.object);
                                chainRuleCreateAction.setChainName(string);
                                chainRuleCreateAction.setIsEndRule(true);
                                Object object2 = ChainGraphViewer.this.graph.getModel().getValue(object);
                                chainRuleCreateAction.setSourceStep(ChainGraphViewer.this.graph.getModel().getValue(object).toString());
                                chainRuleCreateAction.setTargetStep("END");
                                chainRuleCreateAction.launch();
                                ChainGraphViewer.this.mainEditorInstance.updateContent(true);
                            }
                        };
                        jMenuItem = new JMenuItem(abstractAction);
                        this.add(jMenuItem);
                        jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)ADD_END_RULE));
                    }
                    abstractAction = new AbstractAction(StringUtils.stripMnemonic((String)DELETE)){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = ChainGraphViewer.this.object.getObjectName();
                            ChainNodeDeleteAction chainNodeDeleteAction = new ChainNodeDeleteAction();
                            chainNodeDeleteAction.setDBObject(ChainGraphViewer.this.object);
                            chainNodeDeleteAction.setChainName(string);
                            if (ChainGraphViewer.this.graph.getModel().isVertex(object)) {
                                chainNodeDeleteAction.setIsRule(false);
                                chainNodeDeleteAction.setObjectName(((StepData)ChainGraphViewer.this.nodefromGuiMap.get(object)).getName());
                            } else if (ChainGraphViewer.this.graph.getModel().isEdge(object)) {
                                chainNodeDeleteAction.setIsRule(true);
                                chainNodeDeleteAction.setObjectName(((RuleData)ChainGraphViewer.this.ruleFromGuiMap.get(object)).getRuleName());
                            }
                            chainNodeDeleteAction.launch();
                            ChainGraphViewer.this.mainEditorInstance.updateContent(true);
                        }
                    };
                    jMenuItem = new JMenuItem(abstractAction);
                    this.add(jMenuItem);
                    jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)DELETE));
                    abstractAction = new AbstractAction(StringUtils.stripMnemonic((String)DETAILS)){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (ChainGraphViewer.this.graph.getModel().isVertex(object)) {
                                ChainGraphViewer.this.createStepTable((StepData)ChainGraphViewer.this.nodefromGuiMap.get(object), object);
                            } else if (ChainGraphViewer.this.graph.getModel().isEdge(object)) {
                                ChainGraphViewer.this.createRuleTable((RuleData)ChainGraphViewer.this.ruleFromGuiMap.get(object), object);
                            }
                        }
                    };
                    jMenuItem = new JMenuItem(abstractAction);
                    this.add(jMenuItem);
                    jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)DETAILS));
                }
            }
        }
    }
}

