/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import oracle.bali.xml.grammar.GrammarException;
import oracle.jdeveloper.xml.dtd.grammar.GrammarFactory;

final class NumberSimpleType
extends GrammarFactory.AbstractBuiltInSimpleType {
    NumberSimpleType() {
        super("unsignedInt");
    }

    public void validateValue(String value) throws GrammarException {
        if (value.length() == 0) {
            throw new GrammarException("Invalid number value");
        }
        if (value.charAt(0) == '-' || value.charAt(0) == '+') {
            throw new GrammarException("Number value can not be signed");
        }
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new GrammarException("Invalid number value");
        }
    }
}

