/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util.xpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.util.xpath.XPathEvaluator;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XPathUtils {
    private static final Logger _LOGGER = Logger.getLogger(XPathUtils.class.getName());

    public static Collection<Node> findNodes(String xPathString, Node contextNode, Node ancestorNode, XPathEvaluator xPathEvaluator) {
        ArrayList<Node> selectedNodesCollection = new ArrayList<Node>();
        Object selectedNodes = null;
        try {
            selectedNodes = xPathEvaluator.evaluateXPath(xPathString, contextNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            _LOGGER.log(Level.WARNING, "Unexpected Exception encountered - XPathUtils.findNodes() " + xPathString, e);
        }
        if (selectedNodes != null && selectedNodes instanceof NodeList && ((NodeList)selectedNodes).getLength() > 0) {
            NodeList matchedNodes = (NodeList)selectedNodes;
            for (int i = 0; i < matchedNodes.getLength(); ++i) {
                Node matchedNode = matchedNodes.item(i);
                if (ancestorNode != null) {
                    if (!DomUtils.isDescendant(matchedNode, ancestorNode)) continue;
                    selectedNodesCollection.add(matchedNode);
                    continue;
                }
                selectedNodesCollection.add(matchedNode);
            }
        }
        return selectedNodesCollection;
    }

    public static Node findNode(String xPathString, Node contextNode, XPathEvaluator xPathEvaluator) {
        Object fieldNode = null;
        if (contextNode == null || xPathString == null) {
            _LOGGER.log(Level.WARNING, "XPathUtils.findNode() called with null context node and/or xPathString");
            return null;
        }
        try {
            fieldNode = xPathEvaluator.evaluateXPath(xPathString, contextNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            _LOGGER.log(Level.WARNING, "Unexpected Exception encountered - XPathUtils.findNode() : " + xPathString, e);
        }
        return (Node)fieldNode;
    }

    public static String getTextNodeValue(Node contextNode, String xPathExpression, XPathEvaluator xPathEvaluator) {
        Node fieldNode = XPathUtils.findNode(xPathExpression, contextNode, xPathEvaluator);
        if (fieldNode != null) {
            return DomUtils.getTextNodeValue(fieldNode);
        }
        return null;
    }

    public static boolean nodesHaveEqualValues(Node node1, Collection<String> xPathExpr1, Node node2, Collection<String> xPathExpr2, XPathEvaluator xPathEvaluator) {
        Collection<String> nodeValueCollection1 = XPathUtils.getNodeValues(node1, xPathExpr1, xPathEvaluator);
        Collection<String> nodeValueCollection2 = XPathUtils.getNodeValues(node2, xPathExpr2, xPathEvaluator);
        if (nodeValueCollection1.size() == 0 || nodeValueCollection2.size() == 0) {
            return false;
        }
        Iterator<String> nodeValue2Iter = nodeValueCollection2.iterator();
        for (String nodeValue1 : nodeValueCollection1) {
            String nodeValue2;
            if (!nodeValue2Iter.hasNext() || nodeValue1.equals(nodeValue2 = nodeValue2Iter.next())) continue;
            return false;
        }
        return true;
    }

    public static Collection<String> getNodeValues(Node contextNode, Collection<String> xpathExprCollection, XPathEvaluator xPathEvaluator) {
        ArrayList<String> valueCollection = new ArrayList<String>();
        boolean keyNum = false;
        for (String fieldExpr : xpathExprCollection) {
            if (fieldExpr == null) continue;
            String nodeValue = XPathUtils.getTextNodeValue(contextNode, fieldExpr, xPathEvaluator);
            if (nodeValue == null) break;
            valueCollection.add(nodeValue);
        }
        return valueCollection;
    }

    public static List<Node> getValueNodes(Node contextNode, Collection<String> xpathExprCollection, XPathEvaluator xPathEvaluator) {
        ArrayList<Node> valueNodeList = new ArrayList<Node>();
        for (String fieldExpr : xpathExprCollection) {
            if (fieldExpr == null) continue;
            Node valueNode = XPathUtils.findNode(fieldExpr, contextNode, xPathEvaluator);
            valueNodeList.add(valueNode);
        }
        return valueNodeList;
    }

    public static String getCanonicalXPathForNode(Node node, XPathEvaluator xPathEvaluator) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 9: {
                    return "/";
                }
                case 1: {
                    int index = XPathUtils.getChildIndex(node);
                    String ns = node.getNamespaceURI();
                    String xpath = "/";
                    if (ns != null) {
                        xpath = xpath + XPathUtils.getPrefix(ns, xPathEvaluator) + ":";
                    }
                    xpath = xpath + node.getLocalName() + "[" + index + "]";
                    if (node.getParentNode() != null && node.getParentNode() != node.getOwnerDocument()) {
                        xpath = XPathUtils.getCanonicalXPathForNode(node.getParentNode(), xPathEvaluator) + xpath;
                    }
                    return xpath;
                }
                case 2: {
                    return XPathUtils.getCanonicalXPathForNode(((Attr)node).getOwnerElement(), xPathEvaluator) + "/@" + node.getLocalName();
                }
                case 3: 
                case 4: {
                    return XPathUtils.getCanonicalXPathForNode(node.getParentNode(), xPathEvaluator) + "/text()";
                }
                case 8: {
                    int index = XPathUtils.getChildIndex(node);
                    String xpath = "/comment()[" + index + "]";
                    Node parent = node.getParentNode();
                    if (parent.getNodeType() != 9) {
                        xpath = XPathUtils.getCanonicalXPathForNode(parent, xPathEvaluator) + xpath;
                    }
                    return xpath;
                }
                case 7: {
                    int index = XPathUtils.getChildIndex(node);
                    String xpath = "/processing-instruction()[" + index + "]";
                    Node parent = node.getParentNode();
                    if (parent.getNodeType() != 9) {
                        xpath = XPathUtils.getCanonicalXPathForNode(parent, xPathEvaluator) + xpath;
                    }
                    return xpath;
                }
            }
        }
        return null;
    }

    public static String getPrefix(String namespace, XPathEvaluator xPathEvaluator) {
        String prefix = xPathEvaluator.getXPathNamespaceContext().getPrefix(namespace);
        if (prefix == null) {
            int index = 1;
            while (prefix == null) {
                String tmp = "ns" + index;
                if (!xPathEvaluator.getXPathNamespaceContext().containsPrefix(tmp)) {
                    prefix = tmp;
                    xPathEvaluator.getXPathNamespaceContext().addNamespacePrefix(prefix, namespace);
                }
                ++index;
            }
        }
        return prefix;
    }

    public static int getChildIndex(Node node) {
        int index = 1;
        short nodeType = node.getNodeType();
        Node parentNode = node.getParentNode();
        if (parentNode != null) {
            for (Node currSibling = parentNode.getFirstChild(); currSibling != node; currSibling = currSibling.getNextSibling()) {
                short currSibType = currSibling.getNodeType();
                if (nodeType != currSibType) continue;
                if (nodeType == 1) {
                    QualifiedName siblingQN;
                    QualifiedName nodeQN = DomUtils.getQualifiedName(node);
                    if (!nodeQN.equals(siblingQN = DomUtils.getQualifiedName(currSibling))) continue;
                    ++index;
                    continue;
                }
                ++index;
            }
        }
        return index;
    }
}

