/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.Expression;
import oracle.bali.xml.metadata.el.Function;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.Coercions;

final class ASTFunctionInvocation
extends ASTOperand {
    private final String _prefix;
    private final String _name;
    private final Function _function;
    private final Expression[] _operands;

    public ASTFunctionInvocation(String prefix, String name, Function function, Expression[] operands) {
        this._prefix = prefix;
        this._name = name;
        this._function = function;
        this._operands = operands;
    }

    public Object getValue(VariableResolver vResolver) throws ELException {
        Class[] argTypes = this._function.getArgumentTypes();
        Object[] args = new Object[argTypes.length];
        for (int i = 0; i < this._operands.length; ++i) {
            args[i] = Coercions.toObject(vResolver, this._operands[i], argTypes[i]);
        }
        return this._function.evaluate(vResolver, args);
    }

    public Class getType(VariableResolver resolver) throws ELException {
        return this._function.getReturnType();
    }

    protected void toString(StringBuffer buffer) {
        if (this._prefix != null && this._prefix.length() > 0) {
            buffer.append(this._prefix);
            buffer.append(':');
        }
        buffer.append(this._name);
        buffer.append('(');
        for (int i = 0; i < this._operands.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this._operands[i].toString());
        }
        buffer.append(')');
    }

    public boolean isConstant() {
        return this._function.isMacro();
    }
}

