/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.LayeredMetadataProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;

public abstract class XmlMetadataProvider
extends LayeredMetadataProvider {
    public XmlMetadataProvider() {
        this(null);
    }

    public XmlMetadataProvider(MetadataProvider base) {
        super(base);
    }

    public final Map getNamespaceMetadata(String namespace) {
        XmlKey key = ImmutableXmlKey.createNamespaceKey(namespace).intern();
        return this.getMetadata(key);
    }

    public final Map getElementMetadata(String namespace, String elementName) {
        XmlKey key = ImmutableXmlKey.createElementKey(namespace, elementName).intern();
        return this.getMetadata(key);
    }

    public final Map getElementMetadata(List elementQNamePath) {
        XmlKey key = ImmutableXmlKey.createElementKey(elementQNamePath).intern();
        return this.getMetadata(key);
    }

    public final Map getAttributeMetadata(String namespace, String attributeName) {
        XmlKey key = ImmutableXmlKey.createAttributeKey(namespace, attributeName).intern();
        return this.getMetadata(key);
    }

    public final Map getAttributeMetadata(String namespace, String elementName, String attributeName) {
        XmlKey key = ImmutableXmlKey.createAttributeKey(QualifiedName.getQualifiedName(namespace, elementName), attributeName).intern();
        return this.getMetadata(key);
    }

    public final Map getAttributeMetadata(List elementQNamePath, String attributeName) {
        XmlKey key = ImmutableXmlKey.createAttributeKey(elementQNamePath, attributeName).intern();
        return this.getMetadata(key);
    }

    public final Object getNamespaceMetadataItem(String namespace, QualifiedName itemKey) {
        return XmlMetadataProvider.getNamespaceMetadataItem(this, namespace, itemKey);
    }

    public static Object getNamespaceMetadataItem(MetadataProvider provider, String namespace, QualifiedName itemKey) {
        XmlKey key = ImmutableXmlKey.createNamespaceKey(namespace).intern();
        return provider.getMetadataItem(key, itemKey);
    }

    public final Object getElementMetadataItem(String namespace, String elementName, QualifiedName itemKey) {
        XmlKey key = ImmutableXmlKey.createElementKey(namespace, elementName).intern();
        return this.getMetadataItem(key, itemKey);
    }

    public final Object getElementMetadataItem(List elementQNamePath, QualifiedName itemKey) {
        XmlKey key = ImmutableXmlKey.createElementKey(elementQNamePath).intern();
        return this.getMetadataItem(key, itemKey);
    }

    public final Object getAttributeMetadataItem(String namespace, String attributeName, QualifiedName itemKey) {
        XmlKey key = ImmutableXmlKey.createAttributeKey(namespace, attributeName).intern();
        return this.getMetadataItem(key, itemKey);
    }

    public final Object getAttributeMetadataItem(String namespace, String elementName, String attributeName, QualifiedName itemKey) {
        XmlKey key = ImmutableXmlKey.createAttributeKey(QualifiedName.getQualifiedName(namespace, elementName), attributeName).intern();
        return this.getMetadataItem(key, itemKey);
    }

    public final Object getAttributeMetadataItem(List elementQNamePath, String attributeName, QualifiedName itemKey) {
        XmlKey key = ImmutableXmlKey.createAttributeKey(elementQNamePath, attributeName).intern();
        return this.getMetadataItem(key, itemKey);
    }
}

