/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;

public class MetadataValueConverter {
    private final GrammarResolver _metadataLanguageGrammarResolver;
    private final Map _typesForConversion;

    public MetadataValueConverter() {
        this(MetadataSchemaRegistry.getInstance().getMetadataGrammarResolver());
    }

    public MetadataValueConverter(GrammarResolver metadataLanguageGrammarResolver) {
        if (metadataLanguageGrammarResolver == null) {
            throw new IllegalArgumentException("metadataLanguageGrammarResolver must not be null");
        }
        this._metadataLanguageGrammarResolver = metadataLanguageGrammarResolver;
        this._typesForConversion = new HashMap();
    }

    public Class getExpectedMetadataType(Object itemKey) {
        SimpleType type;
        if (itemKey instanceof QualifiedName && (type = this._getTypeForConversion((QualifiedName)itemKey)) != null) {
            try {
                return JavaTypeManager.getInstance().getJavaClass(type);
            }
            catch (GrammarException e) {
                Logger.getLogger("oracle.bali.xml.metadata").log(Level.WARNING, "getExpectedMetadataType for " + type + " failed.", e);
            }
        }
        return null;
    }

    public String getDefaultMetadataValue(Object itemKey) {
        ElementDef mdItem;
        QualifiedName qName;
        Grammar g;
        if (itemKey instanceof QualifiedName && (g = this._metadataLanguageGrammarResolver.getGrammarForNamespace((qName = (QualifiedName)itemKey).getNamespace())) != null && (mdItem = g.getElementDefByName(qName.getName())) != null) {
            return mdItem.getDefaultValue();
        }
        return null;
    }

    public Object coerceMetadataValue(Object value, Object itemKey) throws MetadataException {
        if (value instanceof String && itemKey instanceof QualifiedName) {
            String metadataValue = (String)value;
            QualifiedName qname = (QualifiedName)itemKey;
            SimpleType type = this._getTypeForConversion(qname);
            if (type != null) {
                try {
                    return type.convertToJavaType(metadataValue);
                }
                catch (GrammarException e) {
                    String message = "Couldn't coerceMetadataValue " + metadataValue + " to " + type;
                    throw new MetadataException(message, e);
                }
            }
        }
        return value;
    }

    private SimpleType _getTypeForConversion(QualifiedName itemKey) {
        Grammar g;
        SimpleType typeForConversion = (SimpleType)this._typesForConversion.get(itemKey);
        if (typeForConversion == null && (g = this._metadataLanguageGrammarResolver.getGrammarForNamespace(itemKey.getNamespace())) != null) {
            SimpleType st;
            ElementDef ed = g.getElementDefByName(itemKey.getName());
            SimpleType simpleType = st = ed == null ? null : TypeUtils.getSimpleTypeAncestor(ed.getType());
            if (st != null) {
                if (st.getVariety() == 2) {
                    List unionMembers = st.getUnionMemberTypes();
                    Iterator iter = unionMembers.iterator();
                    while (iter.hasNext() && typeForConversion == null) {
                        SimpleType memberType = (SimpleType)iter.next();
                        if ("http://xmlns.oracle.com/bali/xml/metadata".equals(memberType.getTargetNamespace()) && "expressionType".equals(memberType.getName())) continue;
                        typeForConversion = memberType;
                    }
                }
                if (typeForConversion == null) {
                    typeForConversion = st;
                }
                this._typesForConversion.put(itemKey, typeForConversion);
            }
        }
        return typeForConversion;
    }
}

