/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    private static final QualifiedName _TYPE_ID = QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema", "ID");
    private static final QualifiedName _TYPE_IDREF = QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema", "IDREF");
    private static final QualifiedName _TYPE_IDREFS = QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema", "IDREFS");
    private static final String _KEY_SIMPLETYPE_VALIDATION_NAME = "SIMPLETYPE_VALIDATION_NAME";
    private static final String _KEY_SIMPLETYPE_VALIDATION_TYPE = "SIMPLETYPE_VALIDATION_TYPE";
    private static final String _KEY_SIMPLETYPE_VALIDATION_FACETS = "SIMPLETYPE_VALIDATION_FACETS";
    private static final String _KEY_SIMPLETYPE_VALIDATION_UNION_TYPES = "SIMPLETYPE_VALIDATION_UNION_TYPES";
    private static final String _KEY_SIMPLETYPE_TYPE_ANONYMOUS = "SIMPLETYPE_TYPE_ANONYMOUS";
    private static final String _KEY_SIMPLETYPE_TYPE_NAME = "SIMPLETYPE_TYPE_NAME";
    private static final String _KEY_SIMPLETYPE_TYPE_BASE = "SIMPLETYPE_TYPE_BASE";
    private static final String _KEY_SIMPLETYPE_TYPE_PRIMITIVE = "SIMPLETYPE_TYPE_PRIMITIVE";
    private static final String _KEY_SIMPLETYPE_FACET_LENGTH = "SIMPLETYPE_FACET_LENGTH";
    private static final String _KEY_SIMPLETYPE_FACET_MINLENGTH = "SIMPLETYPE_FACET_MINLENGTH";
    private static final String _KEY_SIMPLETYPE_FACET_MAXLENGTH = "SIMPLETYPE_FACET_MAXLENGTH";
    private static final String _KEY_SIMPLETYPE_FACET_PATTERN = "SIMPLETYPE_FACET_PATTERN";
    private static final String _KEY_SIMPLETYPE_FACET_ENUMERATION = "SIMPLETYPE_FACET_ENUMERATION";
    private static final String _KEY_SIMPLETYPE_FACET_MININCLUSIVE = "SIMPLETYPE_FACET_MININCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_MINEXCLUSIVE = "SIMPLETYPE_FACET_MINEXCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_MAXINCLUSIVE = "SIMPLETYPE_FACET_MAXINCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_MAXEXCLUSIVE = "SIMPLETYPE_FACET_MAXEXCLUSIVE";
    private static final String _KEY_SIMPLETYPE_FACET_TOTAL_DIGITS = "SIMPLETYPE_FACET_TOTAL_DIGITS";
    private static final String _KEY_SIMPLETYPE_FACET_FRACTION_DIGITS = "SIMPLETYPE_FACET_FRACTION_DIGITS";

    public static boolean isElementDefOfType(ElementDef elementDef, String typeNamespace, String typeName) {
        QualifiedName[] types = new QualifiedName[]{QualifiedName.getQualifiedName(typeNamespace, typeName)};
        return TypeUtils.matchElementDefToType(elementDef, types) == 0;
    }

    public static int matchElementDefToType(ElementDef elementDef, QualifiedName[] types) {
        if (elementDef != null && types != null && types.length > 0) {
            Type currentType = elementDef.getType();
            while (currentType != null) {
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].getName().equals(currentType.getName()) || !types[i].getNamespace().equals(currentType.getTargetNamespace())) continue;
                    return i;
                }
                if (currentType instanceof ComplexType) {
                    ComplexType complexType = (ComplexType)currentType;
                    Type newType = complexType.getBaseType();
                    if (currentType == newType) break;
                    currentType = newType;
                    continue;
                }
                currentType = null;
            }
        }
        return -1;
    }

    public static boolean isSimpleTypeElement(GrammarComponent grammarComponent) {
        if (grammarComponent instanceof ElementDef) {
            ElementDef ed = (ElementDef)grammarComponent;
            Type t = ed.getType();
            return TypeUtils.isSimpleType(t);
        }
        return false;
    }

    public static boolean isSimpleType(Type type) {
        if (type == null) {
            return false;
        }
        return type.getVariety() == 0 || type.getVariety() == 1 || type.getVariety() == 2;
    }

    public static boolean isComplexType(Type type) {
        if (type == null) {
            return false;
        }
        int v = type.getVariety();
        return v == 3 || v == 6 || v == 4 || v == 5;
    }

    public static boolean isSimpleTypeOrComplexTextOnlyElement(GrammarComponent grammarComponent) {
        if (grammarComponent instanceof ElementDef) {
            ElementDef ed = (ElementDef)grammarComponent;
            Type t = ed.getType();
            return t.getVariety() == 0 || t.getVariety() == 1 || t.getVariety() == 2 || t.getVariety() == 5;
        }
        return false;
    }

    public static SimpleType getSimpleTypeAncestor(Type type) {
        while (type != null) {
            if (type instanceof SimpleType) {
                return (SimpleType)type;
            }
            if (!(type instanceof ComplexType)) break;
            type = ((ComplexType)type).getBaseType();
        }
        return null;
    }

    public static ConstrainingFacet findFacet(SimpleType simple, int facetId) {
        Collection facets = simple.getConstrainingFacets();
        if (facets != null) {
            for (ConstrainingFacet facet : facets) {
                if (facet.getFacetID() != facetId) continue;
                return facet;
            }
        }
        return null;
    }

    public static List getElementWildcards(ElementDef elementDef) {
        Type type = elementDef.getType();
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            return TypeUtils.getElementWildcards(complexType);
        }
        return Collections.EMPTY_LIST;
    }

    public static List getElementWildcards(ComplexType complexType) {
        ArrayList wildcards = new ArrayList();
        if (complexType != null) {
            ContentGroup group = complexType.getContentGroup();
            TypeUtils._addGroupWildcards(group, wildcards);
        }
        return wildcards;
    }

    public static Wildcard getMatchingWildcard(List wildcards, String namespace) {
        Wildcard match = null;
        if (wildcards != null) {
            for (Wildcard wildcard : wildcards) {
                if (!TypeUtils.wildcardAllowsNamespace(wildcard, namespace)) continue;
                match = wildcard;
                break;
            }
        }
        return match;
    }

    public static List<Grammar> getAllowableGrammars(GrammarProvider gp, List wildcards) {
        ArrayList<Grammar> allowableGs = new ArrayList<Grammar>();
        Collection grammars = gp.getGrammars();
        for (Grammar g : grammars) {
            if (!TypeUtils.wildcardsAllowNamespace(wildcards, g.getTargetNamespace())) continue;
            allowableGs.add(g);
        }
        return Collections.unmodifiableList(allowableGs);
    }

    public static boolean wildcardsAllowNamespace(List wildcards, String namespace) {
        for (Wildcard wc : wildcards) {
            if (!TypeUtils.wildcardAllowsNamespace(wc, namespace)) continue;
            return true;
        }
        return false;
    }

    public static boolean wildcardAllowsNamespace(Wildcard wildcard, String namespace) {
        boolean allows = false;
        switch (wildcard.getVariety()) {
            case 0: {
                allows = true;
                break;
            }
            case 1: {
                String targetNamespace;
                if (namespace == null || namespace.equals(targetNamespace = wildcard.getTargetNamespace())) break;
                allows = true;
                break;
            }
            case 2: {
                List namespaceList = wildcard.getNamespaceConstraintList();
                if (!namespaceList.contains(namespace)) break;
                allows = true;
                break;
            }
        }
        return allows;
    }

    public static boolean wildcardAllowsName(Wildcard wildcard, QualifiedName qName) {
        boolean allows = false;
        String namespace = qName.getNamespace();
        switch (wildcard.getVariety()) {
            case 0: {
                allows = true;
                break;
            }
            case 1: {
                String targetNamespace;
                if (namespace == null || namespace.equals(targetNamespace = wildcard.getTargetNamespace())) break;
                allows = true;
                break;
            }
            case 2: {
                List namespaceList = wildcard.getNamespaceConstraintList();
                Pattern pattern = wildcard.getNamePattern();
                if (!namespaceList.contains(namespace) || pattern != null && !pattern.matcher(qName.getName()).matches()) break;
                allows = true;
                break;
            }
        }
        return allows;
    }

    public static boolean isIdType(SimpleType simpleType) {
        return TypeUtils.instanceOfBuiltInType(simpleType, _TYPE_ID);
    }

    public static boolean isIdRefType(SimpleType simpleType) {
        return TypeUtils.instanceOfBuiltInType(simpleType, _TYPE_IDREF);
    }

    public static boolean isIdRefsType(SimpleType simpleType) {
        return TypeUtils.instanceOfBuiltInType(simpleType, _TYPE_IDREFS);
    }

    public static boolean instanceOfBuiltInType(SimpleType simpleType, QualifiedName typeName) {
        QualifiedName qName;
        String localName;
        boolean matches = false;
        SimpleType builtInType = simpleType.getBuiltInBaseType();
        if (builtInType != null && (localName = builtInType.getName()) != null && (qName = QualifiedName.getQualifiedName(builtInType.getTargetNamespace(), localName)).equals(typeName)) {
            matches = true;
        }
        return matches;
    }

    public static String getSimpleTypeMessage(SimpleType type) {
        StringBuffer message = new StringBuffer();
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getTargetNamespace()) && "Name".equals(type.getName())) {
            message.append(TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_NAME));
        } else if (type.getVariety() == 2) {
            message.append(TypeUtils._getUnionMessage(type.getUnionMemberTypes()));
        } else {
            String fullList;
            Collection facets;
            SimpleType primitiveType;
            message.append(TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_TYPE));
            message.append("\n\n");
            message.append(TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_TYPE_NAME));
            message.append("  ");
            if (type.getName() != null) {
                message.append(type.getName());
            } else {
                message.append(TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_TYPE_ANONYMOUS));
            }
            SimpleType baseType = type.getBuiltInBaseType();
            if (baseType != null && baseType != type) {
                message.append("\n");
                message.append(TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_TYPE_BASE));
                message.append("  ");
                message.append(baseType.getName());
            }
            if ((primitiveType = type.getPrimitiveType()) != null) {
                message.append("\n");
                message.append(TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_TYPE_PRIMITIVE));
                message.append("  ");
                message.append(primitiveType.getName());
            }
            if (!(facets = type.getConstrainingFacets()).isEmpty() && (fullList = TypeUtils._getFacetDescriptions(facets)) != null) {
                message.append("\n\n");
                message.append(TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_FACETS));
                message.append("\n\n");
                message.append(fullList);
            }
        }
        return message.toString();
    }

    private static String _getFacetDescriptions(Collection facets) {
        String message = "";
        for (ConstrainingFacet facet : facets) {
            String facetValue = TypeUtils._getFacetErrorValue(facet);
            if (facetValue == null) continue;
            message = message + facetValue + "\n";
        }
        return "".equals(message) ? null : message;
    }

    private static String _getUnionMessage(List types) {
        String message = TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_UNION_TYPES) + "\n";
        for (SimpleType type : types) {
            if ("unknownType".equals(type.getName())) continue;
            message = message + "\n" + type.getName();
            Collection facets = type.getConstrainingFacets();
            if (facets.isEmpty()) {
                message = message + "\n";
                continue;
            }
            String facetValues = TypeUtils._getFacetDescriptions(facets);
            if (facetValues != null) {
                message = message + " " + TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_VALIDATION_FACETS) + "\n" + facetValues;
                continue;
            }
            message = message + "\n";
        }
        return message;
    }

    private static String _getFacetErrorValue(ConstrainingFacet facet) {
        switch (facet.getFacetID()) {
            case 7: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_LENGTH) + "  " + facet.getConstraintValue();
            }
            case 9: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_MINLENGTH) + "  " + facet.getConstraintValue();
            }
            case 8: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_MAXLENGTH) + "  " + facet.getConstraintValue();
            }
            case 11: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_PATTERN) + "  " + facet.getConstraintValue();
            }
            case 10: {
                Collection enu = facet.getEnumerationValues();
                String message = TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_ENUMERATION);
                Iterator i = enu.iterator();
                while (i.hasNext()) {
                    message = message + i.next() + " ";
                }
                return message;
            }
            case 1: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_MININCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 2: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_MINEXCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 3: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_MAXINCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 4: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_MAXEXCLUSIVE) + "  " + facet.getConstraintValue();
            }
            case 5: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_TOTAL_DIGITS) + "  " + facet.getConstraintValue();
            }
            case 6: {
                return TypeUtils._getTranslatedString(_KEY_SIMPLETYPE_FACET_FRACTION_DIGITS) + "  " + facet.getConstraintValue();
            }
        }
        return null;
    }

    private static String _getTranslatedString(String key) {
        try {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.xml.grammar.schema.error.resource.ErrorBundle", Locale.getDefault());
            return b.getString(key);
        }
        catch (Exception e) {
            return "???" + key + "???";
        }
    }

    public static void printContentGroup(ContentGroup group) {
        int variety = group.getVariety();
        String varietyString = "UNKNOWN-GROUP";
        if (variety == 7) {
            varietyString = "ALL";
        } else if (variety == 8) {
            varietyString = "CHOICE";
        } else if (variety == 9) {
            varietyString = "SEQUENCE";
        }
        System.out.println("<" + varietyString + ">");
        Collection grammarComponents = group.getComponents();
        for (GrammarComponent component : grammarComponents) {
            if (component instanceof ContentGroup) {
                TypeUtils.printContentGroup((ContentGroup)component);
                continue;
            }
            if (component instanceof Wildcard) {
                System.out.println("WILDCARD");
                continue;
            }
            if (component instanceof ElementDef) {
                ElementDef def = (ElementDef)component;
                System.out.println(def.getQualifiedName().getQualifiedName());
                continue;
            }
            System.out.println("UNKNOWN PARTICLE");
        }
        System.out.println("</" + varietyString + ">");
    }

    private static void _addGroupWildcards(ContentGroup group, List wildcards) {
        Collection groupComponents;
        if (group != null && (groupComponents = group.getComponents()) != null) {
            for (GrammarComponent component : groupComponents) {
                if (component instanceof Wildcard) {
                    Wildcard wildcard = (Wildcard)component;
                    wildcards.add(wildcard);
                    continue;
                }
                if (!(component instanceof ContentGroup)) continue;
                ContentGroup subGroup = (ContentGroup)component;
                TypeUtils._addGroupWildcards(subGroup, wildcards);
            }
        }
    }

    private TypeUtils() {
    }
}

