/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema.xsi;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContextualFixedAttributeElementDefProvider;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.proxy.FixedAttributeElementDefProxy;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.util.XmlNameUtils;
import oracle.jdeveloper.xml.dtd.grammar.GrammarFactory;
import org.w3c.dom.Element;

public class XsiTypeElementDefProvider
extends ContextualFixedAttributeElementDefProvider {
    public static final QualifiedName XSI_TYPE_ATTR_NAME = QualifiedName.getQualifiedName("http://www.w3.org/2001/XMLSchema-instance", "type");
    private static final AttributeDef _XSI_TYPE_ATTR_DEF = new BuiltInXsiTypeAttributeDef();
    private ConcurrentMap<QualifiedName, FixedAttributeElementDef> _variantCache = new ConcurrentHashMap<QualifiedName, FixedAttributeElementDef>(5);
    private final GrammarResolver _resolver;
    private final ElementDef _masterElementDef;
    private static final Logger _sLogger = Logger.getLogger(XsiTypeElementDefProvider.class.getName());

    public static XsiTypeElementDefProvider findOrCreate(GrammarResolver resolver, ElementDef masterElementDef) {
        if (resolver == null) {
            throw new IllegalArgumentException("resolver argument cannot be null");
        }
        if (masterElementDef == null) {
            throw new IllegalArgumentException("masterElementDef argument cannot be null");
        }
        Type type = masterElementDef.getType();
        if (!(type instanceof ComplexType)) {
            throw new IllegalArgumentException("masterElementDef argument must have a ComplexType");
        }
        ComplexType complexType = (ComplexType)type;
        if (!complexType.isAbstract()) {
            throw new IllegalArgumentException("masterElementDef argument must have an abstract ComplexType");
        }
        return new XsiTypeElementDefProvider(resolver, masterElementDef);
    }

    public QualifiedName getFixedAttributeName() {
        return XSI_TYPE_ATTR_NAME;
    }

    public FixedAttributeElementDef getFixedAttributeElementDef(Element optionalElement, String fixedAttrValue) {
        Type desiredType;
        Grammar grammar;
        FixedAttributeElementDef variant = null;
        QualifiedName resolvedTypeName = this._resolveTypeName(optionalElement, fixedAttrValue);
        if (resolvedTypeName != null && (variant = (FixedAttributeElementDef)this._variantCache.get(resolvedTypeName)) == null && (grammar = this._resolver.getGrammarForNamespace(resolvedTypeName.getNamespace())) != null && (desiredType = grammar.getTypeByName(resolvedTypeName.getName())) instanceof ComplexType) {
            ComplexType desiredComplexType = (ComplexType)desiredType;
            FixedAttributeElementDefProxy newVariant = new FixedAttributeElementDefProxy(this._masterElementDef, XSI_TYPE_ATTR_NAME, resolvedTypeName.getQualifiedName(), desiredComplexType, _XSI_TYPE_ATTR_DEF);
            variant = this._variantCache.putIfAbsent(resolvedTypeName, newVariant);
            if (variant == null) {
                variant = newVariant;
            }
        }
        return variant;
    }

    public Collection getFixedAttributeElementDefs() {
        return Collections.emptySet();
    }

    private QualifiedName _resolveTypeName(Element optionalElement, String fixedAttrValue) {
        QualifiedName resolvedTypeName = null;
        if (fixedAttrValue != null) {
            String beforeSeparator = null;
            String typeLocalName = null;
            int separatorIndex = fixedAttrValue.lastIndexOf(58);
            if (separatorIndex != -1) {
                if (separatorIndex != 0) {
                    beforeSeparator = fixedAttrValue.substring(0, separatorIndex);
                }
                typeLocalName = fixedAttrValue.substring(separatorIndex + 1);
            } else {
                typeLocalName = fixedAttrValue;
            }
            String typeNamespace = null;
            if (optionalElement != null) {
                typeNamespace = DomUtils.lookupNamespacePrefix(beforeSeparator, optionalElement);
            } else {
                if (separatorIndex == -1) {
                    _sLogger.log(Level.WARNING, "If no element is provided for context, the fixedAttrValue provided to XsiTypeElementDefProvider must already be resolved into the form namespace:name.  Invalid value: " + fixedAttrValue, new IllegalArgumentException("Invalid fixedAttrValue argument (see log)"));
                    return null;
                }
                typeNamespace = beforeSeparator;
            }
            try {
                XmlNameUtils.validateNamespace(typeNamespace);
                XmlNameUtils.validateName(typeLocalName);
                resolvedTypeName = QualifiedName.getQualifiedName(typeNamespace, typeLocalName);
            }
            catch (IllegalArgumentException e) {
                resolvedTypeName = null;
            }
        }
        return resolvedTypeName;
    }

    private XsiTypeElementDefProvider(GrammarResolver resolver, ElementDef masterElementDef) {
        this._resolver = resolver;
        this._masterElementDef = masterElementDef;
    }

    private static class BuiltInXsiTypeAttributeDef
    implements AttributeDef {
        private BuiltInXsiTypeAttributeDef() {
        }

        public String getTargetNamespace() {
            return XSI_TYPE_ATTR_NAME.getNamespace();
        }

        public String getName() {
            return XSI_TYPE_ATTR_NAME.getName();
        }

        public QualifiedName getQualifiedName() {
            return XSI_TYPE_ATTR_NAME;
        }

        public AttributeDef getReferencedAttributeDef() {
            return null;
        }

        public SimpleType getType() {
            return GrammarFactory.getBuiltInType(13);
        }

        public boolean isReference() {
            return false;
        }

        public boolean isRequired() {
            return false;
        }

        public String getDefaultValue() {
            return null;
        }

        public String getFixedValue() {
            return null;
        }

        public Annotation getAnnotation() {
            return null;
        }
    }
}

