/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.automata;

import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.automata.Transition;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import org.w3c.dom.Element;

public final class ElementDefTransition
extends Transition {
    private static final String _ERROR_NULL_NAME = "Cannot pass a null ElementDef to constructor";
    private ElementDef _elementDef = null;

    public ElementDefTransition(State fromState, State toState, ElementDef elementDef) {
        super(fromState, toState);
        if (elementDef == null) {
            throw new IllegalArgumentException(_ERROR_NULL_NAME);
        }
        this._elementDef = elementDef;
    }

    @Deprecated
    public final ElementDef getElementDef(GrammarProvider provider, QualifiedName name) {
        return this.getElementDef(new GrammarResolver(provider), name);
    }

    public ElementDef getElementDef(GrammarResolver resolver, QualifiedName name) {
        return this.getElementDef(resolver, name, null);
    }

    public ElementDef getElementDef(GrammarResolver resolver, QualifiedName name, Element element) {
        String fVal;
        FixedAttributeElementDef variant;
        QualifiedName fAttrName;
        ElementDef returnDef = null;
        QualifiedName defName = this._elementDef.getQualifiedName();
        if (defName.equals(name)) {
            returnDef = this._elementDef;
        } else {
            SubstitutionGroup substGroup = this._elementDef.getSubstitutionGroup();
            if (substGroup != null) {
                returnDef = substGroup.getElementDefByName(name);
            }
        }
        if (returnDef != null && element != null && (fAttrName = resolver.getFixedAttributeName(returnDef)) != null && (variant = resolver.getFixedAttributeElementDef(element, returnDef, fAttrName, fVal = element.getAttributeNS(fAttrName.getNamespace(), fAttrName.getName()))) != null) {
            returnDef = variant;
        }
        return returnDef;
    }

    public ElementDef getElementDef() {
        return this._elementDef;
    }

    public boolean accepts(GrammarResolver resolver, QualifiedName name) {
        QualifiedName defName = this._elementDef.getQualifiedName();
        if (defName.equals(name)) {
            return true;
        }
        SubstitutionGroup substGroup = this._elementDef.getSubstitutionGroup();
        return substGroup != null && substGroup.getElementDefByName(name) != null;
    }

    public Transition clone(State fromState, State toState) {
        return new ElementDefTransition(fromState, toState, this._elementDef);
    }
}

