/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.javacompiler.JrtfsStorage;
import oracle.ojc.interfaces.Storage;

class JrtfsJarAccess {
    private static final String MODULES_PATH_NAME = "/modules/";
    private URL jrtfsJar;
    private FileSystem fs;
    private List<Storage> children;

    List<Storage> getModules() {
        if (this.children == null) {
            URLClassLoader loader = new URLClassLoader(new URL[]{this.jrtfsJar});
            try {
                this.fs = FileSystems.newFileSystem(URI.create("jrt:/"), Collections.emptyMap(), (ClassLoader)loader);
            }
            catch (IOException ex) {
                this.fs = new FileSystem(){

                    @Override
                    public FileSystemProvider provider() {
                        return null;
                    }

                    @Override
                    public void close() throws IOException {
                    }

                    @Override
                    public boolean isOpen() {
                        return false;
                    }

                    @Override
                    public boolean isReadOnly() {
                        return false;
                    }

                    @Override
                    public String getSeparator() {
                        return null;
                    }

                    @Override
                    public Iterable<Path> getRootDirectories() {
                        return Collections.emptyList();
                    }

                    @Override
                    public Iterable<FileStore> getFileStores() {
                        return Collections.emptyList();
                    }

                    @Override
                    public Set<String> supportedFileAttributeViews() {
                        return Collections.emptySet();
                    }

                    @Override
                    public Path getPath(String first, String ... more) {
                        return null;
                    }

                    @Override
                    public PathMatcher getPathMatcher(String syntaxAndPattern) {
                        return null;
                    }

                    @Override
                    public UserPrincipalLookupService getUserPrincipalLookupService() {
                        return null;
                    }

                    @Override
                    public WatchService newWatchService() throws IOException {
                        return null;
                    }
                };
            }
            this.children = new ArrayList<Storage>();
            for (Path rootDir : this.fs.getRootDirectories()) {
                try {
                    Stream<Path> rootDirStream = Files.list(rootDir);
                    Iterator rootDirIter = rootDirStream.iterator();
                    while (rootDirIter.hasNext()) {
                        Path rootDirPath = (Path)rootDirIter.next();
                        if (!MODULES_PATH_NAME.equals(rootDirPath.toString().replace('\\', '/') + "/")) continue;
                        Stream<Path> moduleStream = Files.list(rootDirPath);
                        Iterator moduleIter = moduleStream.iterator();
                        while (moduleIter.hasNext()) {
                            Path modulePath = (Path)moduleIter.next();
                            JrtfsStorage child = new JrtfsStorage(this, modulePath);
                            this.children.add(child);
                        }
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        return new ArrayList<Storage>(this.children);
    }

    JrtfsJarAccess(URL jrtfsJar) {
        this.jrtfsJar = jrtfsJar;
    }

    protected void finalize() throws Throwable {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    URL getJrtfsJar() {
        return this.jrtfsJar;
    }

    long modDate() {
        return URLFileSystem.lastModified((URL)this.jrtfsJar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] read(String name, String pathString) throws IOException {
        if (name.endsWith(".class")) {
            Path path = this.fs.getPath(pathString, new String[0]);
            if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                try (InputStream inputStream = null;){
                    int read;
                    inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                    byte[] bytes = new byte[4096];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((read = inputStream.read(bytes)) >= 0) {
                        out.write(bytes);
                    }
                    byte[] byArray = out.toByteArray();
                    return byArray;
                }
            }
        }
        return new byte[0];
    }

    public void close() {
        try {
            if (this.fs != null) {
                this.fs.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

